/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;

public class ParticleColor
implements Cloneable {
    public static final ParticleColor WHITE = new ParticleColor(255, 255, 255);
    public static final ParticleColor RED = new ParticleColor(255, 50, 50);
    public static final ParticleColor GREEN = new ParticleColor(50, 255, 50);
    public static final ParticleColor BLUE = new ParticleColor(50, 50, 255);
    public static final ParticleColor YELLOW = new ParticleColor(255, 255, 0);
    public static final ParticleColor PURPLE = new ParticleColor(255, 50, 255);
    public static final ParticleColor CYAN = new ParticleColor(50, 255, 255);
    public static final ParticleColor ORANGE = new ParticleColor(255, 128, 0);
    public static final ParticleColor TO_HIGHLIGHT = RED;
    public static final ParticleColor FROM_HIGHLIGHT = CYAN;
    private final float r;
    private final float g;
    private float b;
    private final int color;

    public ParticleColor(int r, int g, int b) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.color = r << 16 | g << 8 | b;
    }

    public ParticleColor(double red, double green, double blue) {
        this((int)red, (int)green, (int)blue);
    }

    public static ParticleColor makeRandomColor(int r, int g, int b, RandomSource random) {
        return new ParticleColor(random.m_188503_(r), random.m_188503_(g), random.m_188503_(b));
    }

    public ParticleColor(float r, float g, float b) {
        this((int)r, (int)g, (int)b);
    }

    public static ParticleColor fromInt(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return new ParticleColor(r, g, b);
    }

    public static ParticleColor defaultParticleColor() {
        return new ParticleColor(255, 25, 180);
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public int getColor() {
        return this.color;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        IntWrapper wrapper = this.toWrapper();
        tag.m_128405_("r", wrapper.r);
        tag.m_128405_("g", wrapper.g);
        tag.m_128405_("b", wrapper.b);
        return tag;
    }

    public String toString() {
        return this.r + "," + this.g + "," + this.b;
    }

    public IntWrapper toWrapper() {
        return new IntWrapper(this);
    }

    public ParticleColor nextColor(RandomSource random) {
        IntWrapper wrapper = this.toWrapper();
        return new ParticleColor(random.m_188503_(wrapper.r), random.m_188503_(wrapper.g), random.m_188503_(wrapper.b));
    }

    public static ParticleColor fromString(String string) {
        if (string == null || string.isEmpty()) {
            return ParticleColor.defaultParticleColor();
        }
        String[] arr = string.split(",");
        return new ParticleColor(Integer.parseInt(arr[0].trim()), Integer.parseInt(arr[1].trim()), Integer.parseInt(arr[2].trim()));
    }

    public static ParticleColor deserialize(CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return ParticleColor.defaultParticleColor();
        }
        return new ParticleColor(tag.m_128451_("r"), tag.m_128451_("g"), tag.m_128451_("b"));
    }

    public ParticleColor clone() {
        try {
            ParticleColor clone = (ParticleColor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static class IntWrapper
    implements Cloneable {
        public int r;
        public int g;
        public int b;

        public IntWrapper(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public IntWrapper(ParticleColor color) {
            this.r = (int)((double)color.getRed() * 255.0);
            this.g = (int)((double)color.getGreen() * 255.0);
            this.b = (int)((double)color.getBlue() * 255.0);
        }

        public ParticleColor toParticleColor() {
            return new ParticleColor(this.r, this.g, this.b);
        }

        public IntWrapper clone() {
            try {
                IntWrapper clone = (IntWrapper)super.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }
}

