/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item.inv;

import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class FilterableItemHandler {
    private IItemHandler handler;
    private List<Function<ItemStack, ItemScroll.SortPref>> filters;

    public FilterableItemHandler(IItemHandler handler) {
        this(handler, new ArrayList<Function<ItemStack, ItemScroll.SortPref>>());
    }

    public FilterableItemHandler(IItemHandler handler, List<Function<ItemStack, ItemScroll.SortPref>> filters) {
        this.handler = handler;
        this.filters = filters;
    }

    public boolean canInsert(ItemStack stack) {
        return this.getHighestPreference(stack) != ItemScroll.SortPref.INVALID;
    }

    public boolean canExtract(ItemStack stack) {
        return this.getHighestPreference(stack) != ItemScroll.SortPref.INVALID;
    }

    public boolean canInteractFor(ItemStack stack, InteractType type) {
        return type == InteractType.EXTRACT ? this.canExtract(stack) : this.canInsert(stack);
    }

    public ItemScroll.SortPref getHighestPreference(ItemStack stack) {
        ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
        for (Function<ItemStack, ItemScroll.SortPref> filter : this.filters) {
            ItemScroll.SortPref newPref = filter.apply(stack);
            if (newPref == ItemScroll.SortPref.INVALID) {
                return ItemScroll.SortPref.INVALID;
            }
            if (newPref.ordinal() <= pref.ordinal()) continue;
            pref = newPref;
        }
        return pref;
    }

    public IItemHandler getHandler() {
        return this.handler;
    }

    public List<Function<ItemStack, ItemScroll.SortPref>> getFilters() {
        return this.filters;
    }
}

