/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.forge;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.Nullable;

public class ClientPlatformHelperImpl {
    public static void registerRenderType(Block block, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
    }

    public static void registerFluidRenderType(Fluid fluid, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)type);
    }

    public static void registerItemProperty(Item item, ResourceLocation name, ClampedItemPropertyFunction property) {
        ItemProperties.register((Item)item, (ResourceLocation)name, (ItemPropertyFunction)property);
    }

    public static void addParticleRegistration(Consumer<ClientPlatformHelper.ParticleEvent> eventListener) {
        Consumer<RegisterParticleProvidersEvent> eventConsumer = event -> {
            W w = new W((RegisterParticleProvidersEvent)event);
            eventListener.accept(w::register);
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addEntityRenderersRegistration(Consumer<ClientPlatformHelper.EntityRendererEvent> eventListener) {
        Consumer<EntityRenderersEvent.RegisterRenderers> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addBlockEntityRenderersRegistration(Consumer<ClientPlatformHelper.BlockEntityRendererEvent> eventListener) {
        Consumer<EntityRenderersEvent.RegisterRenderers> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addBlockColorsRegistration(Consumer<ClientPlatformHelper.BlockColorEvent> eventListener) {
        Consumer<RegisterColorHandlersEvent.Block> eventConsumer = event -> eventListener.accept(new ClientPlatformHelper.BlockColorEvent((RegisterColorHandlersEvent.Block)event){
            final /* synthetic */ RegisterColorHandlersEvent.Block val$event;
            {
                this.val$event = block;
            }

            @Override
            public void register(BlockColor color, Block ... block) {
                this.val$event.register(color, block);
            }

            @Override
            public int getColor(BlockState block, BlockAndTintGetter level, BlockPos pos, int tint) {
                return this.val$event.getBlockColors().m_92577_(block, level, pos, tint);
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addItemColorsRegistration(Consumer<ClientPlatformHelper.ItemColorEvent> eventListener) {
        Consumer<RegisterColorHandlersEvent.Item> eventConsumer = event -> eventListener.accept(new ClientPlatformHelper.ItemColorEvent((RegisterColorHandlersEvent.Item)event){
            final /* synthetic */ RegisterColorHandlersEvent.Item val$event;
            {
                this.val$event = item;
            }

            @Override
            public void register(ItemColor color, ItemLike ... items) {
                this.val$event.register(color, items);
            }

            @Override
            public int getColor(ItemStack stack, int tint) {
                return this.val$event.getItemColors().m_92676_(stack, tint);
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addAtlasTextureCallback(ResourceLocation atlasLocation, Consumer<ClientPlatformHelper.AtlasTextureEvent> eventListener) {
        Consumer<TextureStitchEvent.Pre> eventConsumer = event -> {
            if (event.getAtlas().m_118330_().equals((Object)atlasLocation)) {
                eventListener.accept(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addClientReloadListener(PreparableReloadListener listener, ResourceLocation location) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null) {
            ((ReloadableResourceManager)mc.m_91098_()).m_7217_(listener);
        }
    }

    public static void addModelLayerRegistration(Consumer<ClientPlatformHelper.ModelLayerEvent> eventListener) {
        Consumer<EntityRenderersEvent.RegisterLayerDefinitions> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addSpecialModelRegistration(Consumer<ClientPlatformHelper.SpecialModelEvent> eventListener) {
        Consumer<ModelEvent.RegisterAdditional> eventConsumer = event -> eventListener.accept(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addTooltipComponentRegistration(Consumer<ClientPlatformHelper.TooltipComponentEvent> eventListener) {
        Consumer<RegisterClientTooltipComponentFactoriesEvent> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((RegisterClientTooltipComponentFactoriesEvent)event).register(arg_0, arg_1));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addModelLoaderRegistration(Consumer<ClientPlatformHelper.ModelLoaderEvent> eventListener) {
        Consumer<ModelEvent.RegisterGeometryLoaders> eventConsumer = event -> eventListener.accept((i, l) -> event.register(i.m_135815_(), (IGeometryLoader)l));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addItemDecoratorsRegistration(Consumer<ClientPlatformHelper.ItemDecoratorEvent> eventListener) {
        Consumer<RegisterItemDecorationsEvent> eventConsumer = event -> eventListener.accept((i, l) -> event.register(i, l::render));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void addKeyBindRegistration(Consumer<ClientPlatformHelper.KeyBindEvent> eventListener) {
        Consumer<RegisterKeyMappingsEvent> eventConsumer = event -> eventListener.accept(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static int getPixelRGBA(TextureAtlasSprite sprite, int frameIndex, int x, int y) {
        return sprite.getPixelRGBA(frameIndex, x, y);
    }

    public static BakedModel getModel(ModelManager modelManager, ResourceLocation modelLocation) {
        return modelManager.getModel(modelLocation);
    }

    @Nullable
    public static Path getModIcon(String modId) {
        Optional m = ModList.get().getModContainerById(modId);
        if (m.isPresent()) {
            Path logoPath;
            IModInfo mod = ((ModContainer)m.get()).getModInfo();
            IModFile file = mod.getOwningFile().getFile();
            String logo = mod.getLogoFile().orElse(null);
            if (logo != null && file != null && Files.exists(logoPath = file.findResource(new String[]{logo}), new LinkOption[0])) {
                return logoPath;
            }
        }
        return null;
    }

    public static BlockModel parseBlockModel(JsonElement json) {
        return (BlockModel)ExtendedBlockModelDeserializer.INSTANCE.getAdapter(BlockModel.class).fromJsonTree(json);
    }

    public static void addClientSetup(Runnable clientSetup) {
        Consumer<FMLClientSetupEvent> eventConsumer = event -> event.enqueueWork(clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void registerOptionalTexturePack(ResourceLocation folderName, String displayName, boolean defaultEnabled) {
        Consumer<AddPackFindersEvent> eventConsumer = e -> {
            if (e.getPackType() == PackType.CLIENT_RESOURCES) {
                e.addRepositorySource((consumer, constructor) -> {
                    block7: {
                        IModFile file = ModList.get().getModFileById(folderName.m_135827_()).getFile();
                        try (PathPackResources pack = new PathPackResources(folderName.toString(), file.findResource(new String[]{"resourcepacks/" + folderName.m_135815_()}));){
                            consumer.accept(constructor.create(folderName.toString(), (Component)Component.m_237113_((String)displayName), defaultEnabled, () -> pack, Objects.requireNonNull((PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_)), Pack.Position.TOP, PackSource.f_10528_, false));
                        }
                        catch (IOException ee) {
                            if (DatagenModLoader.isRunningDataGen()) break block7;
                            ee.printStackTrace();
                        }
                    }
                });
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    private record W(RegisterParticleProvidersEvent event) {
        public <T extends ParticleOptions> void register(ParticleType<T> type, ClientPlatformHelper.ParticleFactory<T> provider) {
            this.event.register(type, provider::create);
        }
    }
}

