/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform;

import com.google.gson.JsonElement;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.forge.PlatformHelperImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformHelper {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addCommonSetup(Runnable commonSetup) {
        PlatformHelperImpl.addCommonSetup(commonSetup);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDev() {
        return PlatformHelperImpl.isDev();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isData() {
        return PlatformHelperImpl.isData();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoadingValid() {
        return PlatformHelperImpl.isModLoadingValid();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean evaluateRecipeCondition(JsonElement jo) {
        return PlatformHelperImpl.evaluateRecipeCondition(jo);
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Platform getPlatform() {
        return PlatformHelperImpl.getPlatform();
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Env getEnv() {
        return PlatformHelperImpl.getEnv();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGamePath() {
        return PlatformHelperImpl.getGamePath();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getModFilePath(String modId) {
        return PlatformHelperImpl.getModFilePath(modId);
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModPageUrl(String modId) {
        return PlatformHelperImpl.getModPageUrl(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModName(String modId) {
        return PlatformHelperImpl.getModName(modId);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> Field findField(Class<? super T> clazz, String fieldName) {
        void var1_1;
        return PlatformHelperImpl.findField(clazz, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        void var2_2;
        void var1_1;
        return PlatformHelperImpl.findMethod(clazz, (String)var1_1, var2_2);
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getCurrentServer() {
        return PlatformHelperImpl.getCurrentServer();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String name) {
        return PlatformHelperImpl.isModLoaded(name);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<String> getInstalledMods() {
        return PlatformHelperImpl.getInstalledMods();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerResourcePack(PackType packType, Supplier<Pack> packSupplier) {
        void var1_1;
        PlatformHelperImpl.registerResourcePack(packType, (Supplier<Pack>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isMobGriefingOn(Level level, Entity entity) {
        void var1_1;
        return PlatformHelperImpl.isMobGriefingOn(level, (Entity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isAreaLoaded(LevelReader level, BlockPos pos, int maxRange) {
        void var2_2;
        void var1_1;
        return PlatformHelperImpl.isAreaLoaded(level, (BlockPos)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatformHelperImpl.getFlammability(state, (BlockGetter)var1_1, (BlockPos)var2_2, (Direction)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static FoodProperties getFoodProperties(Item food, ItemStack stack, Player player) {
        void var2_2;
        void var1_1;
        return PlatformHelperImpl.getFoodProperties(food, (ItemStack)var1_1, (Player)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getBurnTime(ItemStack stack) {
        return PlatformHelperImpl.getBurnTime(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Packet<?> getEntitySpawnPacket(Entity entity) {
        return PlatformHelperImpl.getEntitySpawnPacket(entity);
    }

    public static CreativeModeTab createModTab(ResourceLocation name, Supplier<ItemStack> icon, boolean hasSearchBar) {
        return PlatformHelper.createModTab(name, icon, hasSearchBar, null);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CreativeModeTab createModTab(ResourceLocation name, Supplier<ItemStack> icon, boolean hasSearchBar, @Nullable BiConsumer<List<ItemStack>, CreativeModeTab> itemSupplier) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatformHelperImpl.createModTab(name, (Supplier<ItemStack>)var1_1, (boolean)var2_2, (BiConsumer<List<ItemStack>, CreativeModeTab>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SpawnEggItem newSpawnEgg(Supplier<? extends EntityType<? extends Mob>> entityType, int color, int outerColor, Item.Properties properties) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatformHelperImpl.newSpawnEgg(entityType, (int)var1_1, (int)var2_2, (Item.Properties)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FlowerPotBlock newFlowerPot(@Nullable Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> supplier, BlockBehaviour.Properties properties) {
        void var2_2;
        void var1_1;
        return PlatformHelperImpl.newFlowerPot(emptyPot, (Supplier<? extends Block>)var1_1, (BlockBehaviour.Properties)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecordItem newMusicDisc(int power, Supplier<SoundEvent> music, Item.Properties properties, int duration) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatformHelperImpl.newMusicDisc(power, (Supplier<SoundEvent>)var1_1, (Item.Properties)var2_2, (int)var3_3);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SimpleParticleType newParticle() {
        return PlatformHelperImpl.newParticle();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockEntity> BlockEntityType<T> newBlockEntityType(BlockEntitySupplier<T> blockEntitySupplier, Block ... validBlocks) {
        void var1_1;
        return PlatformHelperImpl.newBlockEntityType(blockEntitySupplier, (Block[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends Entity> EntityType<E> newEntityType(String name, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height, int clientTrackingRange, boolean velocityUpdates, int updateInterval) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatformHelperImpl.newEntityType(name, var1_1, (MobCategory)var2_2, (float)var3_3, (float)var4_4, (int)var5_5, (boolean)var6_6, (int)var7_7);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addServerReloadListener(PreparableReloadListener listener, ResourceLocation location) {
        void var1_1;
        PlatformHelperImpl.addServerReloadListener(listener, (ResourceLocation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openCustomMenu(ServerPlayer player, MenuProvider menuProvider, Consumer<FriendlyByteBuf> extraDataProvider) {
        void var2_2;
        void var1_1;
        PlatformHelperImpl.openCustomMenu(player, (MenuProvider)var1_1, (Consumer<FriendlyByteBuf>)var2_2);
    }

    public static void openCustomMenu(ServerPlayer player, MenuProvider menuProvider, BlockPos pos) {
        PlatformHelper.openCustomMenu(player, menuProvider, (FriendlyByteBuf buf) -> buf.m_130064_(pos));
    }

    @FunctionalInterface
    public static interface BlockEntitySupplier<T extends BlockEntity> {
        @NotNull
        public T create(BlockPos var1, BlockState var2);
    }

    public static enum Env {
        CLIENT,
        SERVER;


        public boolean isClient() {
            return this == CLIENT;
        }

        public boolean isServer() {
            return this == SERVER;
        }

        public void ifClient(Runnable runnable) {
            if (this.isClient()) {
                runnable.run();
            }
        }

        public void ifServer(Runnable runnable) {
            if (this.isServer()) {
                runnable.run();
            }
        }
    }

    public static enum Platform {
        FORGE,
        FABRIC;

        private static boolean quilt;

        public boolean isForge() {
            return this == FORGE;
        }

        public boolean isFabric() {
            return this == FABRIC;
        }

        public boolean isQuilt() {
            return this.isFabric() && quilt;
        }

        public void ifForge(Runnable runnable) {
            if (this.isForge()) {
                runnable.run();
            }
        }

        public void ifFabric(Runnable runnable) {
            if (this.isFabric()) {
                runnable.run();
            }
        }

        static {
            quilt = false;
            try {
                Class.forName("org.quiltmc.loader.api.QuiltLoader");
                quilt = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

