/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.entity;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.codexadrian.tempad.Tempad;
import me.codexadrian.tempad.data.LocationData;
import me.codexadrian.tempad.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimedoorEntity
extends Entity {
    public static final int ANIMATION_LENGTH = 8;
    private static final EntityDataAccessor<Integer> CLOSING_TIME = SynchedEntityData.m_135353_(TimedoorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(TimedoorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LocationData locationData = null;
    private UUID owner = null;
    private UUID linkedPortalId = null;
    private TimedoorEntity linkedPortalEntity = null;

    public TimedoorEntity(EntityType<TimedoorEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CLOSING_TIME, (Object)Tempad.getTempadConfig().getTimedoorWait());
        this.f_19804_.m_135372_(COLOR, (Object)-37120);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("location")) {
            this.setLocation(LocationData.fromTag(compoundTag.m_128469_("location")));
        }
        this.setClosingTime(compoundTag.m_128451_("closing_time"));
        if (compoundTag.m_128403_("owner")) {
            this.setOwner(compoundTag.m_128342_("owner"));
        }
        this.setColor(compoundTag.m_128451_("outline_color"));
        if (compoundTag.m_128441_("linked_portal")) {
            this.setLinkedPortalId(compoundTag.m_128342_("linked_portal"));
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (this.locationData != null) {
            compoundTag.m_128365_("location", (Tag)this.locationData.toTag());
        }
        compoundTag.m_128405_("closing_time", this.getClosingTime());
        if (this.owner != null) {
            compoundTag.m_128362_("owner", this.getOwner());
        }
        compoundTag.m_128405_("outline_color", this.getColor());
        if (this.getLinkedPortalId() != null) {
            compoundTag.m_128362_("linked_portal", this.getLinkedPortalId());
        }
    }

    @NotNull
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_8119_() {
        List entities;
        AABB box = this.m_20191_();
        if (this.m_6350_() == Direction.NORTH || this.m_6350_() == Direction.SOUTH) {
            box = box.m_82377_(0.5, 0.0, 0.0);
        }
        if (this.m_6350_() == Direction.EAST || this.m_6350_() == Direction.WEST) {
            box = box.m_82377_(0.0, 0.0, 0.5);
        }
        if (this.getLocation() != null && !(entities = this.f_19853_.m_6443_(Entity.class, box, entity -> !(entity instanceof TimedoorEntity) && entity.m_6072_() && !(entity instanceof FallingBlockEntity) && !(entity instanceof HangingEntity))).isEmpty() && !this.f_19853_.m_5776_()) {
            ServerLevel destinationLevel = Objects.requireNonNull(this.f_19853_.m_7654_()).m_129880_(this.getLocation().getLevelKey());
            entities.stream().flatMap(entity -> entity.m_20201_().m_20199_()).distinct().forEach(entity -> {
                Player player;
                entity.m_20153_();
                Vec3 deltaMovement = entity.m_20184_();
                BlockPos pos = this.getLocation().getBlockPos();
                if (destinationLevel != null) {
                    if (!this.getLocation().getLevelKey().m_135782_().equals((Object)this.f_19853_.m_46472_().m_135782_())) {
                        Services.PLATFORM.teleportEntity(destinationLevel, pos, deltaMovement, (Entity)entity);
                    } else {
                        entity.m_20324_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                        entity.m_20256_(deltaMovement);
                        entity.f_19812_ = true;
                    }
                }
                if (this.getLinkedPortalEntity() != null) {
                    this.getLinkedPortalEntity().resetClosingTime();
                }
                this.resetClosingTime();
                if (entity instanceof Player && (player = (Player)entity).m_20148_().equals(this.getOwner())) {
                    this.setClosingTime(this.f_19797_ + Tempad.getTempadConfig().getTimedoorAddWaitTime());
                    if (this.getLinkedPortalEntity() != null) {
                        this.getLinkedPortalEntity().setClosingTime(this.getLinkedPortalEntity().f_19797_ + Tempad.getTempadConfig().getTimedoorAddWaitTime());
                    }
                }
            });
            if (this.getLinkedPortalEntity() == null) {
                TimedoorEntity recipientPortal = new TimedoorEntity(Services.REGISTRY.getTimedoor(), (Level)destinationLevel);
                recipientPortal.setOwner(this.getOwner());
                recipientPortal.setClosingTime(Tempad.getTempadConfig().getTimedoorAddWaitTime());
                recipientPortal.setLocation(null);
                recipientPortal.setColor(this.getColor());
                this.setLinkedPortalId(recipientPortal.m_20148_());
                recipientPortal.setLinkedPortalId(this.m_20148_());
                BlockPos position = this.getLocation().getBlockPos().m_5484_(this.m_6350_(), 1);
                recipientPortal.m_6034_((double)position.m_123341_() + 0.5, position.m_123342_(), (double)position.m_123343_() + 0.5);
                recipientPortal.m_146922_(this.m_146908_());
                this.f_19853_.m_7967_((Entity)recipientPortal);
            }
        }
        if (this.f_19797_ > this.getClosingTime() + 8 && this.getClosingTime() != -1) {
            if (this.getLinkedPortalEntity() != null) {
                this.getLinkedPortalEntity().setLinkedPortalId(null);
            }
            this.setLinkedPortalId(null);
            this.m_146870_();
        }
    }

    public void setLocation(LocationData location) {
        this.locationData = location;
    }

    @Nullable
    public LocationData getLocation() {
        return this.locationData;
    }

    public int getClosingTime() {
        return (Integer)this.f_19804_.m_135370_(CLOSING_TIME);
    }

    public void setClosingTime(int closingTime) {
        this.f_19804_.m_135381_(CLOSING_TIME, (Object)closingTime);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public UUID getLinkedPortalId() {
        return this.linkedPortalId;
    }

    public TimedoorEntity getLinkedPortalEntity() {
        if (!this.f_19853_.m_5776_() && this.linkedPortalEntity == null) {
            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
            this.linkedPortalEntity = (TimedoorEntity)serverLevel.m_8791_(this.linkedPortalId);
        }
        return this.linkedPortalEntity;
    }

    public void setLinkedPortalId(UUID id) {
        this.linkedPortalId = id;
        this.linkedPortalEntity = null;
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void resetClosingTime() {
        if (this.getClosingTime() != -1) {
            this.setClosingTime(this.f_19797_ + Tempad.getTempadConfig().getTimedoorWait());
        }
    }
}

