/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import me.codexadrian.tempad.entity.TimedoorEntity;
import me.codexadrian.tempad.platform.Services;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class TimedoorRenderer
extends EntityRenderer<TimedoorEntity> {
    public TimedoorRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TimedoorEntity entity, float yaw, float deltaTime, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light) {
        float width = 1.4f;
        float height = 2.3f;
        float depth = 0.4f;
        int closingTime = entity.getClosingTime();
        int tickLength = 8;
        int phaseLength = tickLength / 2;
        int ticks = entity.f_19797_;
        float animation = ((float)ticks + deltaTime) / (float)tickLength;
        if (ticks < phaseLength) {
            width = Mth.m_14179_((float)(animation * 2.0f), (float)0.0f, (float)width);
            height = 0.2f;
        }
        if (ticks >= phaseLength && ticks < tickLength) {
            height = Mth.m_14179_((float)((animation - 0.5f) * 2.0f), (float)0.2f, (float)height);
        }
        if (closingTime != -1) {
            if (ticks > closingTime && ticks < closingTime + phaseLength) {
                height = Mth.m_14179_((float)(1.0f - (animation - (float)closingTime / (float)tickLength) * 2.0f), (float)0.2f, (float)height);
            }
            if (ticks >= closingTime + phaseLength) {
                width = Mth.m_14179_((float)(1.0f - (animation - (float)closingTime / (float)tickLength - 0.5f) * 2.0f), (float)0.0f, (float)width);
                height = 0.2f;
            }
        }
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(entity.m_146908_()));
        poseStack.m_85837_(0.0, (double)1.15f, 0.0);
        Matrix4f model = poseStack.m_85850_().m_85861_();
        this.renderTimedoor(model, multiBufferSource, width, height, depth, light, entity.getColor());
        super.m_7392_((Entity)entity, yaw, deltaTime, poseStack, multiBufferSource, light);
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull TimedoorEntity entity) {
        return new ResourceLocation("tempad", "");
    }

    public void renderTimedoor(Matrix4f model, MultiBufferSource multiBufferSource, float width, float height, float depth, int i, int color) {
        float xBound = width * 0.5f;
        float yBound = height * 0.5f - 0.01f;
        float zBound = depth * -0.5f;
        AbstractUniform inSize = Services.SHADERS.getTimedoorShader().m_173356_("InSize");
        AbstractUniform viewMatUniform = Services.SHADERS.getTimedoorShader().m_173356_("ViewMat");
        PoseStack viewMat = new PoseStack();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        RenderTarget renderTexture = Minecraft.m_91087_().m_91385_();
        Services.SHADERS.getBlurReloader().getRenderTarget().m_83945_(renderTexture);
        viewMat.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
        viewMat.m_85845_(Vector3f.f_122225_.m_122240_(camera.m_90590_() + 180.0f));
        viewMatUniform.m_5679_(viewMat.m_85850_().m_85861_());
        inSize.m_7971_((float)renderTexture.f_83915_, (float)renderTexture.f_83916_);
        VertexConsumer buffer = multiBufferSource.m_6299_(Services.SHADERS.getTimedoorShaderType());
        float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float green = (float)((color & 0xFF00) >> 8) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = 1.0f;
        buffer.m_85982_(model, -xBound, yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, -yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, -yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, -yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, -yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, -yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, -yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, -yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, -yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, -yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, -yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, -xBound, yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, -yBound, -zBound).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, -yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(i).m_5752_();
        buffer.m_85982_(model, xBound, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(i).m_5752_();
    }

    public boolean shouldRender(@NotNull TimedoorEntity entity, @NotNull Frustum frustum, double d, double e, double f) {
        return true;
    }
}

