/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.slot.PhantomSlot;
import me.desht.pneumaticcraft.common.inventory.slot.UnstackablePhantomSlot;
import me.desht.pneumaticcraft.common.item.logistics.AbstractLogisticsFrameItem;
import me.desht.pneumaticcraft.common.semiblock.ISyncableSemiblockItem;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class LogisticsMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity>
implements ISyncableSemiblockItem {
    public final AbstractLogisticsFrameEntity logistics;
    private final boolean itemContainer;

    public LogisticsMenu(MenuType<?> containerType, int i, Inventory playerInventory, int entityId) {
        super(containerType, i, playerInventory);
        Level world = playerInventory.f_35978_.f_19853_;
        if (entityId == -1) {
            this.logistics = AbstractLogisticsFrameEntity.fromItemStack(world, playerInventory.f_35978_, this.getHeldLogisticsFrame(playerInventory.f_35978_));
            this.itemContainer = true;
        } else {
            Entity e = world.m_6815_(entityId);
            if (e instanceof AbstractLogisticsFrameEntity) {
                this.logistics = (AbstractLogisticsFrameEntity)e;
            } else {
                this.logistics = null;
                Log.error("no logistics frame entity for id %d!", entityId);
            }
            this.itemContainer = false;
        }
        if (this.logistics != null) {
            AbstractLogisticsFrameEntity.ItemFilterHandler requests = this.logistics.getItemFilterHandler();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.m_38897_((Slot)(this.logistics.canFilterStack() ? new PhantomSlot((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29) : new UnstackablePhantomSlot((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29)));
                }
            }
            this.addPlayerSlots(playerInventory, 134);
        }
    }

    private LogisticsMenu(MenuType logisticsFrameRequester, int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(logisticsFrameRequester, i, playerInventory, buffer.m_130242_());
    }

    private ItemStack getHeldLogisticsFrame(Player player) {
        if (player.m_21205_().m_41720_() instanceof AbstractLogisticsFrameItem) {
            return player.m_21205_();
        }
        if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof AbstractLogisticsFrameItem) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        return ItemStack.f_41583_;
    }

    public boolean isItemContainer() {
        return this.itemContainer;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        super.handleGUIButtonPress(tag, shiftHeld, player);
        if (this.logistics != null) {
            this.logistics.handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    @Override
    public boolean m_6875_(Player player) {
        return this.logistics != null && this.logistics.isValid();
    }

    public void m_6877_(Player player) {
        if (this.itemContainer && this.logistics != null && !player.m_20193_().f_46443_) {
            this.syncSemiblockItemFromClient(player, null);
        }
    }

    @Override
    @Nonnull
    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot srcSlot = (Slot)this.f_38839_.get(slotIndex);
        if (slotIndex >= this.playerSlotsStart && srcSlot != null && srcSlot.m_6657_()) {
            ItemStack stackInSlot = srcSlot.m_7993_();
            for (int i = 0; i < 27; ++i) {
                Slot slot = (Slot)this.f_38839_.get(i);
                if (slot.m_6657_()) continue;
                ItemStack s = this.logistics.canFilterStack() ? stackInSlot.m_41777_() : ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)1);
                slot.m_5852_(s);
                break;
            }
        }
        return ItemStack.f_41583_;
    }

    public static LogisticsMenu createProviderContainer(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new LogisticsMenu((MenuType)ModMenuTypes.LOGISTICS_FRAME_PROVIDER.get(), i, playerInventory, buffer);
    }

    public static LogisticsMenu createRequesterContainer(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new LogisticsMenu((MenuType)ModMenuTypes.LOGISTICS_FRAME_REQUESTER.get(), i, playerInventory, buffer);
    }

    public static LogisticsMenu createStorageContainer(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new LogisticsMenu((MenuType)ModMenuTypes.LOGISTICS_FRAME_STORAGE.get(), i, playerInventory, buffer);
    }

    @Override
    public void syncSemiblockItemFromClient(Player player, FriendlyByteBuf payload) {
        if (this.logistics != null) {
            ItemStack stack;
            if (payload != null) {
                this.logistics.readFromBuf(payload);
            }
            if (!(stack = this.getHeldLogisticsFrame(player)).m_41619_()) {
                CompoundTag subtag = this.logistics.serializeNBT(new CompoundTag());
                stack.m_41784_().m_128365_("EntityTag", (Tag)subtag);
            }
        }
    }
}

