/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigJson;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public class ArmorHUDLayout
extends AuxConfigJson {
    public static final ArmorHUDLayout INSTANCE = new ArmorHUDLayout();
    private static final String HUD_LAYOUT = "hud_layout";
    private final Map<ResourceLocation, StatPanelLayout> layouts = new HashMap<ResourceLocation, StatPanelLayout>();

    private ArmorHUDLayout() {
        super(true);
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("Description", "Stores the layout of Pneumatic Armor HUD elements");
        JsonObject sub = new JsonObject();
        this.layouts.forEach((id, layout) -> sub.add(id.toString(), (JsonElement)StatPanelLayout.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, layout).result().orElseThrow()));
        json.add(HUD_LAYOUT, (JsonElement)sub);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        if (json.has(HUD_LAYOUT)) {
            JsonObject sub = json.getAsJsonObject(HUD_LAYOUT);
            sub.entrySet().forEach(entry -> {
                try {
                    ResourceLocation id = new ResourceLocation((String)entry.getKey());
                    this.layouts.put(id, (StatPanelLayout)StatPanelLayout.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()).getAsJsonObject()).result().orElseThrow());
                }
                catch (ResourceLocationException e) {
                    Log.error("invalid stat panel key (not a resource location) %s in %s!", entry.getKey(), this.getConfigFilename());
                }
                catch (NoSuchElementException e) {
                    Log.error("invalid json for key %s in %s!", entry.getKey(), this.getConfigFilename());
                }
            });
        }
    }

    @Override
    public String getConfigFilename() {
        return "PneumaticArmorHUDLayout";
    }

    @Override
    public IAuxConfig.Sidedness getSidedness() {
        return IAuxConfig.Sidedness.CLIENT;
    }

    public void updateLayout(ResourceLocation id, float x, float y, boolean leftSided) {
        this.layouts.put(id, new StatPanelLayout(x, y, leftSided));
        this.tryWriteToFile();
    }

    public StatPanelLayout getLayoutFor(ResourceLocation upgradeID, StatPanelLayout defaultStatLayout) {
        return this.layouts.computeIfAbsent(upgradeID, k -> defaultStatLayout);
    }
}

