/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeMatcher
implements IPlayerMatcher {
    private final Set<TagKey<Biome>> tags;

    public BiomeMatcher(Set<TagKey<Biome>> tags) {
        this.tags = ImmutableSet.copyOf(tags);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.tags.size());
        this.tags.forEach(key -> buffer.m_130085_(key.f_203868_()));
    }

    @Override
    public JsonElement toJson() {
        JsonArray tags = new JsonArray();
        this.tags.forEach(tag -> tags.add(tag.f_203868_().toString()));
        return tags;
    }

    @Override
    public void addDescription(Player player, List<Component> tooltip) {
        if (!this.tags.isEmpty()) {
            List<Component> items = this.tags.stream().map(tag -> Component.m_237113_((String)tag.f_203868_().toString())).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.biomes", new Object[0]), items);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(Player playerEntity) {
        if (this.tags.isEmpty()) return true;
        if (!playerEntity.f_19853_.m_204166_(playerEntity.m_20183_()).m_203616_().anyMatch(this.tags::contains)) return false;
        return true;
    }

    public static class Factory
    implements IPlayerMatcher.MatcherFactory<BiomeMatcher> {
        @Override
        public BiomeMatcher fromJson(JsonElement json) {
            HashSet<TagKey<Biome>> tags = new HashSet<TagKey<Biome>>();
            json.getAsJsonArray().forEach(element -> {
                try {
                    TagKey cat = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation(element.getAsString()));
                    tags.add(cat);
                }
                catch (ResourceLocationException e) {
                    Log.error("invalid biome tag resource location: %s", element);
                }
            });
            return new BiomeMatcher(tags);
        }

        @Override
        public BiomeMatcher fromBytes(FriendlyByteBuf buffer) {
            HashSet<TagKey<Biome>> tags = new HashSet<TagKey<Biome>>();
            int nTags = buffer.m_130242_();
            for (int i = 0; i < nTags; ++i) {
                ResourceLocation rl = buffer.m_130281_();
                tags.add((TagKey<Biome>)TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)rl));
            }
            return new BiomeMatcher(tags);
        }
    }
}

