/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.config;

import com.hrznstudio.titanium.annotation.config.ConfigFile;
import com.hrznstudio.titanium.annotation.config.ConfigVal;
import com.hrznstudio.titanium.util.AnnotationUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class AnnotationConfigManager {
    public List<Type> configClasses = new ArrayList<Type>();
    public List<SpecCache> specCaches = new ArrayList<SpecCache>();

    public void add(Type type) {
        String fileName;
        this.configClasses.add(type);
        SpecCache specCache = new SpecCache();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        for (Class configClass : type.configClass) {
            this.scanClass(configClass, builder, specCache);
        }
        File folder = new File("config" + File.separator + ModLoadingContext.get().getActiveContainer().getModId());
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(fileName = ModLoadingContext.get().getActiveContainer().getModId() + "/" + (type.fileName.isEmpty() ? ModLoadingContext.get().getActiveContainer().getModId() : type.fileName)).endsWith(".toml")) {
            fileName = fileName + ".toml";
        }
        specCache.spec = builder.build();
        ModLoadingContext.get().registerConfig(type.type, (IConfigSpec)specCache.spec, fileName);
        this.specCaches.add(specCache);
    }

    private void scanClass(Class configClass, ForgeConfigSpec.Builder builder, SpecCache specCache) {
        builder.push(configClass.getSimpleName());
        try {
            for (Field field : configClass.getFields()) {
                ForgeConfigSpec.ConfigValue configValue;
                ConfigVal value;
                if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(ConfigVal.class)) continue;
                if (field.getType().isPrimitive() || field.getType().equals(String.class)) {
                    value = field.getAnnotation(ConfigVal.class);
                    configValue = null;
                    if (!value.comment().isEmpty()) {
                        builder.comment(value.comment());
                    }
                    if (field.isAnnotationPresent(ConfigVal.InRangeDouble.class)) {
                        configValue = builder.defineInRange(value.value().isEmpty() ? field.getName() : value.value(), ((Double)field.get(null)).doubleValue(), field.getAnnotation(ConfigVal.InRangeDouble.class).min(), field.getAnnotation(ConfigVal.InRangeDouble.class).max());
                    }
                    if (field.isAnnotationPresent(ConfigVal.InRangeLong.class)) {
                        configValue = builder.defineInRange(value.value().isEmpty() ? field.getName() : value.value(), ((Long)field.get(null)).longValue(), field.getAnnotation(ConfigVal.InRangeLong.class).min(), field.getAnnotation(ConfigVal.InRangeLong.class).max());
                    }
                    if (field.isAnnotationPresent(ConfigVal.InRangeInt.class)) {
                        configValue = builder.defineInRange(value.value().isEmpty() ? field.getName() : value.value(), ((Integer)field.get(null)).intValue(), field.getAnnotation(ConfigVal.InRangeInt.class).min(), field.getAnnotation(ConfigVal.InRangeInt.class).max());
                    }
                    if (configValue == null) {
                        configValue = builder.define(value.value().isEmpty() ? field.getName() : value.value(), field.get(null));
                    }
                    specCache.cachedConfigValues.put(field, configValue);
                }
                if (field.getType().equals(List.class)) {
                    value = field.getAnnotation(ConfigVal.class);
                    configValue = null;
                    if (!value.comment().isEmpty()) {
                        builder.comment(value.comment());
                    }
                    configValue = builder.defineList(value.value().isEmpty() ? field.getName() : value.value(), (List)field.get(null), object -> true);
                    specCache.cachedConfigValues.put(field, configValue);
                    continue;
                }
                this.scanClass(field.getType(), builder, specCache);
            }
            AnnotationUtil.getFilteredAnnotatedClasses(ConfigFile.Child.class, ModLoadingContext.get().getActiveContainer().getModId()).stream().filter(aClass -> aClass.getAnnotation(ConfigFile.Child.class).value().equals(configClass)).forEach(aClass -> this.scanClass((Class)aClass, builder, specCache));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        builder.pop();
    }

    public void inject(IConfigSpec spec) {
        this.specCaches.forEach(specCache -> {
            if (specCache.spec == spec) {
                specCache.cachedConfigValues.forEach((field, configValue) -> {
                    try {
                        field.set(null, configValue.get());
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                });
            }
        });
    }

    public boolean isClassManaged(Class clazz) {
        for (Type configClass : this.configClasses) {
            for (Class aClass : configClass.configClass) {
                if (!clazz.equals(aClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static class SpecCache {
        public ForgeConfigSpec spec;
        public HashMap<Field, ForgeConfigSpec.ConfigValue> cachedConfigValues = new HashMap();
    }

    public static class Type {
        private ModConfig.Type type;
        private Class[] configClass;
        private String fileName;

        private Type(ModConfig.Type type, Class ... configClass) {
            this.type = type;
            this.configClass = configClass;
            this.fileName = "";
        }

        public static Type client(Class ... classes) {
            return new Type(ModConfig.Type.CLIENT, classes);
        }

        public static Type common(Class ... classes) {
            return new Type(ModConfig.Type.COMMON, classes);
        }

        public static Type server(Class ... classes) {
            return new Type(ModConfig.Type.SERVER, classes);
        }

        public static Type of(ModConfig.Type type, Class ... classes) {
            return new Type(type, classes);
        }

        public Type setName(String name) {
            this.fileName = name;
            return this;
        }

        public Class[] getConfigClass() {
            return this.configClass;
        }
    }
}

