/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.prunoideae.recipe.BotaniaRecipeJS;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ElvenTradeRecipeJS
extends BotaniaRecipeJS {
    private final List<ItemStack> outputItems = new ArrayList<ItemStack>();
    private final List<Ingredient> inputItems = new ArrayList<Ingredient>();

    public void create(RecipeArguments args) {
        this.outputItems.addAll(this.parseItemOutputList(args.get(0)));
        this.inputItems.addAll(this.parseItemInputList(args.get(1)));
    }

    public void deserialize() {
        this.outputItems.addAll(this.parseItemOutputList(this.json.get("output")));
        this.inputItems.addAll(this.parseItemInputList(this.json.get("ingredients")));
    }

    public void serialize() {
        if (this.serializeOutputs) {
            JsonArray outputs = new JsonArray();
            for (ItemStack output : this.outputItems) {
                outputs.add(this.itemToJson(output));
            }
            this.json.add("output", (JsonElement)outputs);
        }
        if (this.serializeInputs) {
            this.json.add("ingredients", (JsonElement)this.serializeIngredientList(this.inputItems));
        }
    }

    public boolean hasInput(IngredientMatch match) {
        return this.inputItems.stream().anyMatch(arg_0 -> ((IngredientMatch)match).contains(arg_0));
    }

    public boolean replaceInput(IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        boolean anyReplaced = false;
        for (int i = 0; i < this.inputItems.size(); ++i) {
            if (!match.contains(this.inputItems.get(i))) continue;
            this.inputItems.set(i, transformer.transform((RecipeJS)this, match, this.inputItems.get(i), with));
            anyReplaced = true;
        }
        return anyReplaced;
    }

    public boolean hasOutput(IngredientMatch match) {
        return this.outputItems.stream().anyMatch(arg_0 -> ((IngredientMatch)match).contains(arg_0));
    }

    public boolean replaceOutput(IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        boolean anyReplaced = false;
        for (int i = 0; i < this.outputItems.size(); ++i) {
            if (!match.contains(this.outputItems.get(i))) continue;
            this.outputItems.set(i, transformer.transform((RecipeJS)this, match, this.outputItems.get(i), with));
            anyReplaced = true;
        }
        return anyReplaced;
    }
}

