/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.render.barge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.murad.shipping.entity.custom.vessel.barge.FluidTankBargeEntity;
import dev.murad.shipping.entity.models.FluidTankBargeModel;
import dev.murad.shipping.entity.render.barge.AbstractVesselRenderer;
import dev.murad.shipping.util.FluidRenderUtil;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidTankBargeRenderer
extends AbstractVesselRenderer<FluidTankBargeEntity> {
    private static final ResourceLocation BARGE_TEXTURE = new ResourceLocation("littlelogistics", "textures/entity/fluid_barge.png");
    private final EntityModel model;

    public FluidTankBargeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new FluidTankBargeModel(context.m_174023_(FluidTankBargeModel.LAYER_LOCATION));
    }

    @Override
    EntityModel getModel(FluidTankBargeEntity entity) {
        return this.model;
    }

    public ResourceLocation getTextureLocation(FluidTankBargeEntity p_110775_1_) {
        return BARGE_TEXTURE;
    }

    @Override
    public void render(FluidTankBargeEntity vesselEntity, float yaw, float p_225623_3_, PoseStack matrixStack, MultiBufferSource buffer, int p_225623_6_) {
        super.render(vesselEntity, yaw, p_225623_3_, matrixStack, buffer, p_225623_6_);
        this.renderFluid(vesselEntity, yaw, p_225623_3_, matrixStack, buffer, 0, p_225623_6_);
    }

    public void renderFluid(FluidTankBargeEntity entity, float yaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        FluidStack fluid = entity.getFluidStack();
        if (fluid == null) {
            return;
        }
        Fluid renderFluid = fluid.getFluid();
        if (renderFluid == null) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        matrixStackIn.m_85837_(-0.3, 0.4, -0.25);
        matrixStackIn.m_85841_(1.0f, 1.2f, 1.0f);
        FluidRenderUtil.renderCubeUsingQuads(FluidTankBargeEntity.CAPACITY, fluid, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
    }
}

