/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.compat.curios.CuriosProxy;
import cofh.core.item.IMultiModeItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.item.IColorableItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.item.FluidContainerItemAugmentable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidReservoirItem
extends FluidContainerItemAugmentable
implements IColorableItem,
DyeableLeatherItem,
IMultiModeItem {
    protected static final int FILL = 0;
    protected static final int EMPTY = 1;

    public FluidReservoirItem(Item.Properties builder, int fluidCapacity) {
        super(builder, fluidCapacity);
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalCoreConfig.storageAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "Fluid"});
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)(this.isActive(stack) ? Component.m_237115_((String)"info.cofh_use_sneak_deactivate").m_130940_(ChatFormatting.DARK_GRAY) : Component.m_237115_((String)"info.cofh.use_sneak_activate").m_130940_(ChatFormatting.DARK_GRAY)));
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.reservoir.mode." + this.getMode(stack))).m_130940_(ChatFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (Utils.isClientWorld((Level)worldIn) || Utils.isFakePlayer((Entity)entityIn) || !this.isActive(stack)) {
            return;
        }
        Player player = (Player)entityIn;
        for (ItemStack equip : player.m_20158_()) {
            if (stack.m_41619_() || equip.equals(stack)) continue;
            equip.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> this.drainInternal(stack, c.fill(new FluidStack(this.getFluid(stack), Math.min(this.getFluidAmount(stack), 1000)), IFluidHandler.FluidAction.EXECUTE), player.f_36077_.f_35937_ ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
        }
        CuriosProxy.getAllWorn((LivingEntity)player).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                ItemStack equip = c.getStackInSlot(i);
                if (stack.m_41619_() || equip.equals(stack)) continue;
                equip.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(f -> this.drainInternal(stack, f.fill(new FluidStack(this.getFluid(stack), Math.min(this.getFluidAmount(stack), 1000)), IFluidHandler.FluidAction.EXECUTE), player.f_36077_.f_35937_ ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
            }
        });
    }

    protected boolean useDelegate(ItemStack stack, Player player, InteractionHand hand) {
        if (Utils.isFakePlayer((Entity)player)) {
            return false;
        }
        if (player.m_36341_()) {
            this.setActive(stack, !this.isActive(stack));
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.2f, this.isActive(stack) ? 0.8f : 0.5f);
            return true;
        }
        if (this.getMode(stack) == 0) {
            return this.doBucketFill(stack, player, hand);
        }
        if (this.getMode(stack) == 1) {
            return this.doBucketEmpty(stack, player, hand);
        }
        return false;
    }

    protected boolean doBucketFill(ItemStack stack, @Nonnull Player player, InteractionHand hand) {
        FluidActionResult result;
        if (this.getSpace(stack) < 1000) {
            return false;
        }
        Level world = player.m_20193_();
        BlockHitResult traceResult = FluidReservoirItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (traceResult.m_6662_() == HitResult.Type.MISS) {
            return false;
        }
        if (traceResult.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockPos pos = traceResult.m_82425_();
        Direction sideHit = traceResult.m_82434_();
        if (world.m_7966_(player, pos) && player.m_36204_(pos, sideHit, stack) && (result = FluidUtil.tryPickUpFluid((ItemStack)stack, (Player)player, (Level)world, (BlockPos)pos, (Direction)sideHit)).isSuccess()) {
            if (!player.f_36077_.f_35937_) {
                player.m_21008_(hand, result.getResult());
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            return true;
        }
        return false;
    }

    protected boolean doBucketEmpty(ItemStack stack, @Nonnull Player player, InteractionHand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        if (this.getFluidAmount(stack) < 1000) {
            return false;
        }
        Level world = player.m_20193_();
        BlockHitResult traceResult = FluidReservoirItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (traceResult.m_6662_() == HitResult.Type.MISS) {
            return false;
        }
        if (traceResult.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockPos pos = traceResult.m_82425_();
        Direction sideHit = traceResult.m_82434_();
        if (world.m_7966_(player, pos) && player.m_36204_(targetPos = pos.m_121945_(sideHit), sideHit.m_122424_(), stack) && (result = FluidUtil.tryPlaceFluid((Player)player, (Level)world, (InteractionHand)hand, (BlockPos)targetPos, (ItemStack)stack, (FluidStack)new FluidStack(this.getFluid(stack), 1000))).isSuccess()) {
            if (!player.f_36077_.f_35937_) {
                player.m_21008_(hand, result.getResult());
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            return true;
        }
        return false;
    }

    protected FluidStack drainInternal(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        return super.drain(container, maxDrain, action);
    }

    public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getMode(container) != 0) {
            return 0;
        }
        return super.fill(container, resource, action);
    }

    public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        if (this.getMode(container) != 1) {
            return FluidStack.EMPTY;
        }
        return super.drain(container, maxDrain, action);
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_20183_(), this.getMode(stack) == 0 ? SoundEvents.f_11770_ : SoundEvents.f_11769_, SoundSource.PLAYERS, 0.6f, 1.0f);
        ProxyUtils.setOverlayMessage((Player)player, (Component)Component.m_237115_((String)("info.thermal.reservoir.mode." + this.getMode(stack))));
    }

    public int getColor(ItemStack item, int colorIndex) {
        if (colorIndex == 1) {
            CompoundTag nbt = item.m_41737_("display");
            return nbt != null && nbt.m_128425_("color", 99) ? nbt.m_128451_("color") : 0xFFFFFF;
        }
        if (colorIndex == 2) {
            return this.getFluidAmount(item) > 0 ? FluidHelper.color((FluidStack)this.getFluid(item)) : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }
}

