/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.config;

import cofh.core.config.IBaseConfig;
import cofh.core.item.EnergyContainerItem;
import cofh.core.item.FluidContainerItem;
import cofh.thermal.core.ThermalCore;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public class TInoToolConfig
implements IBaseConfig {
    private Supplier<Integer> rfDrillMaxEnergy;
    private Supplier<Integer> rfSawMaxEnergy;
    private Supplier<Integer> rfCapacitorMaxEnergy;
    private Supplier<Integer> rfMagnetMaxEnergy;
    private Supplier<Integer> fluidReservoirCapacity;
    private Supplier<Integer> potionInfuserCapacity;
    private Supplier<Integer> potionQuiverCapacity;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Tools");
        builder.push("Drill");
        this.rfDrillMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Fluxbore.").defineInRange("Base Capacity", 50000, 1000, 10000000);
        builder.pop();
        builder.push("Saw");
        this.rfSawMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Fluxsaw.").defineInRange("Base Capacity", 50000, 1000, 10000000);
        builder.pop();
        builder.push("Capacitor");
        this.rfCapacitorMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Flux Capacitor.").defineInRange("Base Capacity", 500000, 1000, 10000000);
        builder.pop();
        builder.push("Magnet");
        this.rfMagnetMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Flux Magnet.").defineInRange("Base Capacity", 50000, 1000, 10000000);
        builder.pop();
        builder.push("Reservoir");
        this.fluidReservoirCapacity = builder.comment("This sets the maximum base fluid capacity for the Reservoir.").defineInRange("Base Capacity", 20000, 1000, 10000000);
        builder.pop();
        builder.push("Potion Infuser");
        this.potionInfuserCapacity = builder.comment("This sets the maximum base fluid capacity for the Potion Infuser.").defineInRange("Base Capacity", 4000, 1000, 10000000);
        builder.pop();
        builder.push("Potion Quiver");
        this.potionQuiverCapacity = builder.comment("This sets the maximum base fluid capacity for the Alchemical Quiver.").defineInRange("Base Capacity", 4000, 1000, 10000000);
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        this.setMaxEnergy("flux_drill", this.rfDrillMaxEnergy.get());
        this.setMaxEnergy("flux_saw", this.rfSawMaxEnergy.get());
        this.setMaxEnergy("flux_capacitor", this.rfCapacitorMaxEnergy.get());
        this.setMaxEnergy("flux_magnet", this.rfMagnetMaxEnergy.get());
        this.setFluidCapacity("fluid_reservoir", this.fluidReservoirCapacity.get());
        this.setFluidCapacity("potion_infuser", this.potionInfuserCapacity.get());
        this.setFluidCapacity("potion_quiver", this.potionQuiverCapacity.get());
    }

    private void setMaxEnergy(String id, int energy) {
        Item item = (Item)ThermalCore.ITEMS.get(id);
        if (item instanceof EnergyContainerItem) {
            EnergyContainerItem ec = (EnergyContainerItem)item;
            ec.setMaxEnergy(energy);
        }
    }

    private void setFluidCapacity(String id, int capacity) {
        Item item = (Item)ThermalCore.ITEMS.get(id);
        if (item instanceof FluidContainerItem) {
            FluidContainerItem fc = (FluidContainerItem)item;
            fc.setFluidCapacity(capacity);
        }
    }
}

