/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.datagen;

import at.petrak.paucal.api.PaucalAPI;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class PaucalAdvancementProvider
extends AdvancementProvider {
    private static final Gson PAUCAL_GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final String modid;
    public final DataGenerator generator;

    public PaucalAdvancementProvider(DataGenerator generatorIn, String modid) {
        super(generatorIn);
        this.generator = generatorIn;
        this.modid = modid;
    }

    public void m_213708_(CachedOutput cache) {
        Path outputFolder = this.generator.m_123916_();
        HashSet $$2 = Sets.newHashSet();
        Consumer<Advancement> consumer = $$3x -> {
            if (!$$2.add($$3x.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + $$3x.m_138327_());
            }
            Path path = PaucalAdvancementProvider.paucalCreatePath(outputFolder, $$3x);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)$$3x.m_138313_().m_138400_(), (Path)path);
            }
            catch (IOException exn) {
                PaucalAPI.LOGGER.error("{} couldn't save advancement {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), path, exn});
            }
        };
        this.makeAdvancements(consumer);
    }

    protected abstract void makeAdvancements(Consumer<Advancement> var1);

    protected DisplayInfo simpleDisplay(ItemLike icon, String name, FrameType frameType) {
        return this.simpleDisplayWithBackground(icon, name, frameType, null);
    }

    protected DisplayInfo simpleDisplayWithBackground(ItemLike icon, String name, FrameType frameType, @Nullable ResourceLocation background) {
        return this.display(new ItemStack(icon), name, frameType, background, true, true, false);
    }

    protected DisplayInfo display(ItemStack icon, String name, FrameType frameType, ResourceLocation background, boolean showToast, boolean announceChat, boolean hidden) {
        String expandedName = "advancement." + this.modid + ":" + name;
        return new DisplayInfo(icon, (Component)Component.m_237115_((String)expandedName), (Component)Component.m_237115_((String)(expandedName + ".desc")), background, frameType, showToast, announceChat, hidden);
    }

    protected String prefix(String name) {
        return this.modid + ":" + name;
    }

    protected ResourceLocation modLoc(String name) {
        return new ResourceLocation(this.modid, name);
    }

    private static Path paucalCreatePath(Path $$0, Advancement $$1) {
        return $$0.resolve("data/" + $$1.m_138327_().m_135827_() + "/advancements/" + $$1.m_138327_().m_135815_() + ".json");
    }
}

