/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal;

import at.petrak.paucal.PaucalConfig;
import at.petrak.paucal.common.Contributors;
import at.petrak.paucal.common.ModSounds;
import at.petrak.paucal.common.ModStats;
import at.petrak.paucal.common.advancement.ModAdvancementTriggers;
import at.petrak.paucal.common.command.ModCommands;
import at.petrak.paucal.common.misc.NewWorldMessage;
import at.petrak.paucal.common.misc.PatPat;
import at.petrak.paucal.forge.ForgePaucalConfig;
import at.petrak.paucal.xplat.IXplatAbstractions;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="paucal")
public class ForgePaucalInit {
    public ForgePaucalInit() {
        IXplatAbstractions.INSTANCE.init();
        Pair specPair = new ForgeConfigSpec.Builder().configure(ForgePaucalConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        PaucalConfig.setCommon((PaucalConfig.ConfigAccess)specPair.getLeft());
        ModAdvancementTriggers.registerTriggers();
        ForgePaucalInit.bind(Registry.f_122898_, ModSounds::init);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(event -> {
            if (event.getRegistryKey().equals((Object)Registry.f_122904_)) {
                ModStats.register();
            }
        });
        modBus.addListener(evt -> Contributors.loadContributors());
        evBus.addListener(evt -> {
            InteractionResult result = PatPat.onPat(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getTarget(), null);
            if (result == InteractionResult.SUCCESS) {
                evt.setCanceled(true);
                evt.setCancellationResult(InteractionResult.SUCCESS);
            }
        });
        evBus.addListener(evt -> ModCommands.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher()));
        evBus.addListener(evt -> NewWorldMessage.onLogin(evt.getEntity()));
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }
}

