/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.entities.BarrelMinecartEntity;
import blusunrize.immersiveengineering.common.entities.CrateMinecartEntity;
import blusunrize.immersiveengineering.common.entities.IEMinecartEntity;
import blusunrize.immersiveengineering.common.entities.MetalBarrelMinecartEntity;
import blusunrize.immersiveengineering.common.entities.ReinforcedCrateMinecartEntity;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.DrillheadItem;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.items.FakeIconItem;
import blusunrize.immersiveengineering.common.items.FaradaySuitItem;
import blusunrize.immersiveengineering.common.items.FertilizerItem;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.items.GliderItem;
import blusunrize.immersiveengineering.common.items.GraphiteElectrodeItem;
import blusunrize.immersiveengineering.common.items.GrindingDiskItem;
import blusunrize.immersiveengineering.common.items.HammerItem;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEMinecartItem;
import blusunrize.immersiveengineering.common.items.IESeedItem;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.IETools;
import blusunrize.immersiveengineering.common.items.JerrycanItem;
import blusunrize.immersiveengineering.common.items.LogicCircuitBoardItem;
import blusunrize.immersiveengineering.common.items.MaintenanceKitItem;
import blusunrize.immersiveengineering.common.items.ManualItem;
import blusunrize.immersiveengineering.common.items.PotionBucketItem;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.RevolverpartItem;
import blusunrize.immersiveengineering.common.items.RockcutterItem;
import blusunrize.immersiveengineering.common.items.SawbladeItem;
import blusunrize.immersiveengineering.common.items.ScrewdriverItem;
import blusunrize.immersiveengineering.common.items.ShaderBagItem;
import blusunrize.immersiveengineering.common.items.ShaderItem;
import blusunrize.immersiveengineering.common.items.SkyhookItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.items.SteelArmorItem;
import blusunrize.immersiveengineering.common.items.SurveyToolsItem;
import blusunrize.immersiveengineering.common.items.ToolUpgradeItem;
import blusunrize.immersiveengineering.common.items.ToolboxItem;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.items.WireCoilItem;
import blusunrize.immersiveengineering.common.items.WirecutterItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class IEItems {
    public static final int COKE_BURN_TIME = 3200;
    public static final DeferredRegister<Item> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"immersiveengineering");

    private IEItems() {
    }

    public static void init() {
        REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        Molds.init();
        Ingredients.init();
        Metals.init();
        Tools.init();
        Weapons.init();
        Minecarts.init();
        Misc.init();
    }

    private static <T> Consumer<T> nothing() {
        return $ -> {};
    }

    private static ItemRegObject<IEBaseItem> simpleWithStackSize(String name, int maxSize) {
        return IEItems.simple(name, p -> p.m_41487_(maxSize), i -> {});
    }

    private static ItemRegObject<IEBaseItem> simple(String name) {
        return IEItems.simple(name, $ -> {}, $ -> {});
    }

    private static ItemRegObject<IEBaseItem> simple(String name, Consumer<Item.Properties> makeProps, Consumer<IEBaseItem> processItem) {
        return IEItems.register(name, () -> (IEBaseItem)((Object)((Object)Util.m_137469_((Object)((Object)new IEBaseItem((Item.Properties)Util.m_137469_((Object)new Item.Properties(), (Consumer)makeProps))), (Consumer)processItem))));
    }

    static <T extends Item> ItemRegObject<T> register(String name, Supplier<? extends T> make) {
        return new ItemRegObject(REGISTER.register(name, make));
    }

    private static <T extends Item> ItemRegObject<T> of(T existing) {
        return new ItemRegObject(RegistryObject.create((ResourceLocation)Registry.f_122827_.m_7981_(existing), (IForgeRegistry)ForgeRegistries.ITEMS));
    }

    public static final class Molds {
        public static final ItemRegObject<IEBaseItem> MOLD_PLATE = IEItems.simpleWithStackSize("mold_plate", 1);
        public static final ItemRegObject<IEBaseItem> MOLD_GEAR = IEItems.simpleWithStackSize("mold_gear", 1);
        public static final ItemRegObject<IEBaseItem> MOLD_ROD = IEItems.simpleWithStackSize("mold_rod", 1);
        public static final ItemRegObject<IEBaseItem> MOLD_BULLET_CASING = IEItems.simpleWithStackSize("mold_bullet_casing", 1);
        public static final ItemRegObject<IEBaseItem> MOLD_WIRE = IEItems.simpleWithStackSize("mold_wire", 1);
        public static final ItemRegObject<IEBaseItem> MOLD_PACKING_4 = IEItems.simpleWithStackSize("mold_packing_4", 1);
        public static final ItemRegObject<IEBaseItem> MOLD_PACKING_9 = IEItems.simpleWithStackSize("mold_packing_9", 1);
        public static final ItemRegObject<IEBaseItem> MOLD_UNPACKING = IEItems.simpleWithStackSize("mold_unpacking", 1);

        private static void init() {
        }
    }

    public static final class Ingredients {
        public static final ItemRegObject<IEBaseItem> STICK_TREATED = IEItems.simple("stick_treated");
        public static final ItemRegObject<IEBaseItem> STICK_IRON = IEItems.simple("stick_iron");
        public static final ItemRegObject<IEBaseItem> STICK_STEEL = IEItems.simple("stick_steel");
        public static final ItemRegObject<IEBaseItem> STICK_ALUMINUM = IEItems.simple("stick_aluminum");
        public static final ItemRegObject<IEBaseItem> HEMP_FIBER = IEItems.simple("hemp_fiber");
        public static final ItemRegObject<IEBaseItem> HEMP_FABRIC = IEItems.simple("hemp_fabric");
        public static final ItemRegObject<IEBaseItem> ERSATZ_LEATHER = IEItems.simple("ersatz_leather");
        public static final ItemRegObject<IEBaseItem> COAL_COKE = IEItems.simple("coal_coke", IEItems.nothing(), i -> i.setBurnTime(3200));
        public static final ItemRegObject<IEBaseItem> SLAG = IEItems.simple("slag");
        public static final ItemRegObject<IEBaseItem> COMPONENT_IRON = IEItems.simple("component_iron");
        public static final ItemRegObject<IEBaseItem> COMPONENT_STEEL = IEItems.simple("component_steel");
        public static final ItemRegObject<IEBaseItem> COMPONENT_ELECTRONIC = IEItems.simple("component_electronic");
        public static final ItemRegObject<IEBaseItem> COMPONENT_ELECTRONIC_ADV = IEItems.simple("component_electronic_adv");
        public static final ItemRegObject<IEBaseItem> WATERWHEEL_SEGMENT = IEItems.simple("waterwheel_segment");
        public static final ItemRegObject<IEBaseItem> WINDMILL_BLADE = IEItems.simple("windmill_blade");
        public static final ItemRegObject<IEBaseItem> WINDMILL_SAIL = IEItems.simple("windmill_sail");
        public static final ItemRegObject<IEBaseItem> WOODEN_GRIP = IEItems.simple("wooden_grip");
        public static final ItemRegObject<IEBaseItem> GUNPART_BARREL = IEItems.register("gunpart_barrel", RevolverpartItem::new);
        public static final ItemRegObject<IEBaseItem> GUNPART_DRUM = IEItems.register("gunpart_drum", RevolverpartItem::new);
        public static final ItemRegObject<IEBaseItem> GUNPART_HAMMER = IEItems.register("gunpart_hammer", RevolverpartItem::new);
        public static final ItemRegObject<IEBaseItem> DUST_COKE = IEItems.simple("dust_coke");
        public static final ItemRegObject<IEBaseItem> DUST_HOP_GRAPHITE = IEItems.simple("dust_hop_graphite");
        public static final ItemRegObject<IEBaseItem> INGOT_HOP_GRAPHITE = IEItems.simple("ingot_hop_graphite");
        public static final ItemRegObject<IEBaseItem> WIRE_COPPER = IEItems.simple("wire_copper");
        public static final ItemRegObject<IEBaseItem> WIRE_ELECTRUM = IEItems.simple("wire_electrum");
        public static final ItemRegObject<IEBaseItem> WIRE_ALUMINUM = IEItems.simple("wire_aluminum");
        public static final ItemRegObject<IEBaseItem> WIRE_STEEL = IEItems.simple("wire_steel");
        public static final ItemRegObject<IEBaseItem> WIRE_LEAD = IEItems.simple("wire_lead");
        public static final ItemRegObject<IEBaseItem> DUST_SALTPETER = IEItems.simple("dust_saltpeter");
        public static final ItemRegObject<IEBaseItem> DUST_SULFUR = IEItems.simple("dust_sulfur");
        public static final ItemRegObject<IEBaseItem> DUST_WOOD = IEItems.simple("dust_wood", IEItems.nothing(), i -> i.setBurnTime(100));
        public static final ItemRegObject<IEBaseItem> LIGHT_BULB = IEItems.simple("light_bulb");
        public static final ItemRegObject<IEBaseItem> ELECTRON_TUBE = IEItems.simple("electron_tube");
        public static final ItemRegObject<IEBaseItem> CIRCUIT_BOARD = IEItems.simple("circuit_board");
        public static final ItemRegObject<IEBaseItem> DUROPLAST_PLATE = IEItems.simple("plate_duroplast");
        public static final ItemRegObject<IEBaseItem> EMPTY_CASING = IEItems.simple("empty_casing");
        public static final ItemRegObject<IEBaseItem> EMPTY_SHELL = IEItems.simple("empty_shell");

        private static void init() {
        }
    }

    public static final class Metals {
        public static final Map<EnumMetals, ItemRegObject<Item>> INGOTS = new EnumMap<EnumMetals, ItemRegObject<Item>>(EnumMetals.class);
        public static final Map<EnumMetals, ItemRegObject<Item>> NUGGETS = new EnumMap<EnumMetals, ItemRegObject<Item>>(EnumMetals.class);
        public static final Map<EnumMetals, ItemRegObject<Item>> RAW_ORES = new EnumMap<EnumMetals, ItemRegObject<Item>>(EnumMetals.class);
        public static final Map<EnumMetals, ItemRegObject<IEBaseItem>> DUSTS = new EnumMap<EnumMetals, ItemRegObject<IEBaseItem>>(EnumMetals.class);
        public static final Map<EnumMetals, ItemRegObject<IEBaseItem>> PLATES = new EnumMap<EnumMetals, ItemRegObject<IEBaseItem>>(EnumMetals.class);

        private static void init() {
            for (EnumMetals m : EnumMetals.values()) {
                ItemRegObject<Item> nugget;
                ItemRegObject<Item> ingot;
                String name = m.tagName();
                ItemRegObject<Item> rawOre = null;
                if (!m.isVanillaMetal()) {
                    ingot = IEItems.register("ingot_" + name, IEBaseItem::new);
                } else if (m == EnumMetals.IRON) {
                    ingot = IEItems.of(Items.f_42416_);
                } else if (m == EnumMetals.GOLD) {
                    ingot = IEItems.of(Items.f_42417_);
                } else if (m == EnumMetals.COPPER) {
                    ingot = IEItems.of(Items.f_151052_);
                } else {
                    throw new RuntimeException("Unkown vanilla metal: " + m.name());
                }
                if (m.shouldAddNugget()) {
                    nugget = IEItems.register("nugget_" + name, IEBaseItem::new);
                } else if (m == EnumMetals.IRON) {
                    nugget = IEItems.of(Items.f_42749_);
                } else if (m == EnumMetals.GOLD) {
                    nugget = IEItems.of(Items.f_42587_);
                } else {
                    throw new RuntimeException("Unkown vanilla metal: " + m.name());
                }
                if (m.shouldAddOre()) {
                    rawOre = IEItems.register("raw_" + name, IEBaseItem::new);
                } else if (m == EnumMetals.IRON) {
                    rawOre = IEItems.of(Items.f_151050_);
                } else if (m == EnumMetals.GOLD) {
                    rawOre = IEItems.of(Items.f_151053_);
                } else if (m == EnumMetals.COPPER) {
                    rawOre = IEItems.of(Items.f_151051_);
                }
                NUGGETS.put(m, nugget);
                INGOTS.put(m, ingot);
                if (rawOre != null) {
                    RAW_ORES.put(m, rawOre);
                }
                PLATES.put(m, IEItems.simple("plate_" + name));
                DUSTS.put(m, IEItems.simple("dust_" + name));
            }
        }
    }

    public static final class Tools {
        public static final ItemRegObject<HammerItem> HAMMER = IEItems.register("hammer", HammerItem::new);
        public static final ItemRegObject<WirecutterItem> WIRECUTTER = IEItems.register("wirecutter", WirecutterItem::new);
        public static final ItemRegObject<ScrewdriverItem> SCREWDRIVER = IEItems.register("screwdriver", ScrewdriverItem::new);
        public static final ItemRegObject<ManualItem> MANUAL = IEItems.register("manual", ManualItem::new);
        public static final ItemRegObject<VoltmeterItem> VOLTMETER = IEItems.register("voltmeter", VoltmeterItem::new);
        public static final ItemRegObject<PickaxeItem> STEEL_PICK = IEItems.register("pickaxe_steel", IETools.createPickaxe(Lib.MATERIAL_Steel));
        public static final ItemRegObject<ShovelItem> STEEL_SHOVEL = IEItems.register("shovel_steel", IETools.createShovel(Lib.MATERIAL_Steel));
        public static final ItemRegObject<AxeItem> STEEL_AXE = IEItems.register("axe_steel", IETools.createAxe(Lib.MATERIAL_Steel));
        public static final ItemRegObject<HoeItem> STEEL_HOE = IEItems.register("hoe_steel", IETools.createHoe(Lib.MATERIAL_Steel));
        public static final ItemRegObject<SwordItem> STEEL_SWORD = IEItems.register("sword_steel", IETools.createSword(Lib.MATERIAL_Steel));
        public static final Map<EquipmentSlot, ItemRegObject<SteelArmorItem>> STEEL_ARMOR = new EnumMap<EquipmentSlot, ItemRegObject<SteelArmorItem>>(EquipmentSlot.class);
        public static final ItemRegObject<ToolboxItem> TOOLBOX = IEItems.register("toolbox", ToolboxItem::new);
        public static final ItemRegObject<DrillItem> DRILL = IEItems.register("drill", DrillItem::new);
        public static final ItemRegObject<DrillheadItem> DRILLHEAD_STEEL = IEItems.register("drillhead_steel", () -> new DrillheadItem(DrillheadItem.STEEL));
        public static final ItemRegObject<DrillheadItem> DRILLHEAD_IRON = IEItems.register("drillhead_iron", () -> new DrillheadItem(DrillheadItem.IRON));
        public static final ItemRegObject<BuzzsawItem> BUZZSAW = IEItems.register("buzzsaw", BuzzsawItem::new);
        public static final ItemRegObject<SawbladeItem> SAWBLADE = IEItems.register("sawblade", () -> new SawbladeItem(10000, 8.0f, 9.0f));
        public static final ItemRegObject<RockcutterItem> ROCKCUTTER = IEItems.register("rockcutter", () -> new RockcutterItem(5000, 8.0f, 9.0f));
        public static final ItemRegObject<GrindingDiskItem> GRINDINGDISK = IEItems.register("grindingdisk", () -> new GrindingDiskItem(4000, 20.0f, 9.0f));
        public static final ItemRegObject<SurveyToolsItem> SURVEY_TOOLS = IEItems.register("survey_tools", SurveyToolsItem::new);
        public static final ItemRegObject<GliderItem> GLIDER = IEItems.register("glider", GliderItem::new);

        private static void init() {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                STEEL_ARMOR.put(slot, IEItems.register("armor_steel_" + slot.m_20751_().toLowerCase(Locale.ENGLISH), () -> new SteelArmorItem(slot)));
            }
        }
    }

    public static final class Weapons {
        public static final ItemRegObject<RevolverItem> REVOLVER = IEItems.register("revolver", RevolverItem::new);
        public static final ItemRegObject<SpeedloaderItem> SPEEDLOADER = IEItems.register("speedloader", SpeedloaderItem::new);
        public static final Map<BulletHandler.IBullet, ItemRegObject<BulletItem>> BULLETS = new IdentityHashMap<BulletHandler.IBullet, ItemRegObject<BulletItem>>();
        public static final ItemRegObject<ChemthrowerItem> CHEMTHROWER = IEItems.register("chemthrower", ChemthrowerItem::new);
        public static final ItemRegObject<RailgunItem> RAILGUN = IEItems.register("railgun", RailgunItem::new);

        private static void init() {
            for (ResourceLocation bulletType : BulletHandler.getAllKeys()) {
                BulletHandler.IBullet bullet = BulletHandler.getBullet(bulletType);
                if (!bullet.isProperCartridge()) continue;
                BULLETS.put(bullet, IEItems.register(Weapons.nameFor(bullet), () -> new BulletItem(bullet)));
            }
        }

        private static String nameFor(BulletHandler.IBullet bullet) {
            ResourceLocation name = BulletHandler.findRegistryName(bullet);
            if (name.m_135827_().equals("immersiveengineering")) {
                return name.m_135815_();
            }
            return name.m_135827_() + "_" + name.m_135815_();
        }
    }

    public static final class Minecarts {
        public static final ItemRegObject<IEMinecartItem> CART_WOODEN_CRATE = Minecarts.register("woodencrate", CrateMinecartEntity::new, false);
        public static final ItemRegObject<IEMinecartItem> CART_REINFORCED_CRATE = Minecarts.register("reinforcedcrate", ReinforcedCrateMinecartEntity::new, false);
        public static final ItemRegObject<IEMinecartItem> CART_WOODEN_BARREL = Minecarts.register("woodenbarrel", BarrelMinecartEntity::new, true);
        public static final ItemRegObject<IEMinecartItem> CART_METAL_BARREL = Minecarts.register("metalbarrel", MetalBarrelMinecartEntity::new, true);

        private static void init() {
        }

        private static ItemRegObject<IEMinecartItem> register(String name, IEMinecartEntity.MinecartConstructor constructor, boolean fitsIntoContainer) {
            return IEItems.register("minecart_" + name, () -> new IEMinecartItem(constructor, fitsIntoContainer));
        }
    }

    public static final class Misc {
        public static final Map<WireType, ItemRegObject<WireCoilItem>> WIRE_COILS = new LinkedHashMap<WireType, ItemRegObject<WireCoilItem>>();
        public static final Map<ToolUpgradeItem.ToolUpgrade, ItemRegObject<ToolUpgradeItem>> TOOL_UPGRADES = new EnumMap<ToolUpgradeItem.ToolUpgrade, ItemRegObject<ToolUpgradeItem>>(ToolUpgradeItem.ToolUpgrade.class);
        public static final ItemRegObject<IESeedItem> HEMP_SEEDS = IEItems.register("seed", () -> new IESeedItem((Block)IEBlocks.Misc.HEMP_PLANT.get()));
        public static final ItemRegObject<JerrycanItem> JERRYCAN = IEItems.register("jerrycan", JerrycanItem::new);
        public static final ItemRegObject<EngineersBlueprintItem> BLUEPRINT = IEItems.register("blueprint", EngineersBlueprintItem::new);
        public static final ItemRegObject<SkyhookItem> SKYHOOK = IEItems.register("skyhook", SkyhookItem::new);
        public static final ItemRegObject<ShaderItem> SHADER = IEItems.register("shader", ShaderItem::new);
        public static final Map<Rarity, ItemRegObject<ShaderBagItem>> SHADER_BAG = new HashMap<Rarity, ItemRegObject<ShaderBagItem>>();
        public static final ItemRegObject<EarmuffsItem> EARMUFFS = IEItems.register("earmuffs", EarmuffsItem::new);
        public static final ItemRegObject<CoresampleItem> CORESAMPLE = IEItems.register("coresample", CoresampleItem::new);
        public static final ItemRegObject<GraphiteElectrodeItem> GRAPHITE_ELECTRODE = IEItems.register("graphite_electrode", GraphiteElectrodeItem::new);
        public static final Map<EquipmentSlot, ItemRegObject<FaradaySuitItem>> FARADAY_SUIT = new EnumMap<EquipmentSlot, ItemRegObject<FaradaySuitItem>>(EquipmentSlot.class);
        public static final ItemRegObject<FluorescentTubeItem> FLUORESCENT_TUBE = IEItems.register("fluorescent_tube", FluorescentTubeItem::new);
        public static final ItemRegObject<PowerpackItem> POWERPACK = IEItems.register("powerpack", PowerpackItem::new);
        public static final ItemRegObject<IEShieldItem> SHIELD = IEItems.register("shield", IEShieldItem::new);
        public static final ItemRegObject<MaintenanceKitItem> MAINTENANCE_KIT = IEItems.register("maintenance_kit", MaintenanceKitItem::new);
        public static final ItemRegObject<LogicCircuitBoardItem> LOGIC_CIRCUIT_BOARD = IEItems.register("logic_circuit", LogicCircuitBoardItem::new);
        public static final ItemRegObject<FertilizerItem> FERTILIZER = IEItems.register("fertilizer", FertilizerItem::new);
        public static final ItemRegObject<FakeIconItem> ICON_BIRTHDAY = Misc.icon("birthday");
        public static final ItemRegObject<FakeIconItem> ICON_LUCKY = Misc.icon("lucky");
        public static final ItemRegObject<FakeIconItem> ICON_DRILLBREAK = Misc.icon("drillbreak");
        public static final ItemRegObject<FakeIconItem> ICON_RAVENHOLM = Misc.icon("ravenholm");
        public static final ItemRegObject<FakeIconItem> ICON_FRIED = Misc.icon("fried");
        public static final ItemRegObject<FakeIconItem> ICON_BTTF = Misc.icon("bttf");
        public static final ItemRegObject<PotionBucketItem> POTION_BUCKET = IEItems.register("potion_bucket", PotionBucketItem::new);

        private static ItemRegObject<FakeIconItem> icon(String name) {
            return IEItems.register("fake_icon_" + name, FakeIconItem::new);
        }

        private static void init() {
            for (WireType t : WireType.getIEWireTypes()) {
                WIRE_COILS.put(t, IEItems.register("wirecoil_" + t.getUniqueName().toLowerCase(Locale.US), () -> new WireCoilItem(t)));
            }
            for (ToolUpgradeItem.ToolUpgrade toolUpgrade : ToolUpgradeItem.ToolUpgrade.values()) {
                TOOL_UPGRADES.put(toolUpgrade, IEItems.register("toolupgrade_" + toolUpgrade.name().toLowerCase(Locale.US), () -> new ToolUpgradeItem(upgrade)));
            }
            for (ToolUpgradeItem.ToolUpgrade toolUpgrade : EquipmentSlot.values()) {
                if (toolUpgrade.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                FARADAY_SUIT.put((EquipmentSlot)toolUpgrade, IEItems.register("armor_faraday_" + toolUpgrade.m_20751_().toLowerCase(Locale.ENGLISH), () -> Misc.lambda$init$3((EquipmentSlot)toolUpgrade)));
            }
        }

        public static void registerShaderBags() {
            for (Rarity r : ShaderRegistry.rarityWeightMap.keySet()) {
                SHADER_BAG.put(r, IEItems.register("shader_bag_" + r.name().toLowerCase(Locale.US).replace(':', '_'), () -> new ShaderBagItem(r)));
            }
        }

        private static /* synthetic */ FaradaySuitItem lambda$init$3(EquipmentSlot slot) {
            return new FaradaySuitItem(slot);
        }
    }

    public record ItemRegObject<T extends Item>(RegistryObject<T> regObject) implements Supplier<T>,
    ItemLike
    {
        @Override
        @Nonnull
        public T get() {
            return (T)((Item)this.regObject.get());
        }

        @Nonnull
        public Item m_5456_() {
            return (Item)this.regObject.get();
        }

        public ResourceLocation getId() {
            return this.regObject.getId();
        }
    }
}

