/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.common.blocks.BlockIESlab;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.blocks.FakeLightBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.IEStairsBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.BalloonBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.BlockItemBalloon;
import blusunrize.immersiveengineering.common.blocks.cloth.CushionBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.StripCurtainBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.generic.HorizontalFacingBlock;
import blusunrize.immersiveengineering.common.blocks.generic.PostBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock;
import blusunrize.immersiveengineering.common.blocks.generic.WallmountBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ArcFurnaceBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.AssemblerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.AutoWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.BasicConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterBlock;
import blusunrize.immersiveengineering.common.blocks.metal.BlockItemCapacitor;
import blusunrize.immersiveengineering.common.blocks.metal.BottlingMachineBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.BreakerSwitchBlock;
import blusunrize.immersiveengineering.common.blocks.metal.BreakerSwitchBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.CapacitorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.CapacitorCreativeBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ChargingStationBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ChuteBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ClocheBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorBundledBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorProbeBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorStructuralBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.CrusherBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.DieselGeneratorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.DynamoBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ElectricLanternBlock;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyMeterBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ExcavatorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FermenterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FloodlightBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPlacerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPumpBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FurnaceHeaterBlock;
import blusunrize.immersiveengineering.common.blocks.metal.LanternBlock;
import blusunrize.immersiveengineering.common.blocks.metal.LightningrodBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MetalLadderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalMultiblockBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalPressBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.metal.MixerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.PostTransformerBlock;
import blusunrize.immersiveengineering.common.blocks.metal.RazorWireBlock;
import blusunrize.immersiveengineering.common.blocks.metal.RedstoneBreakerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.RefineryBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.SampleDrillBlock;
import blusunrize.immersiveengineering.common.blocks.metal.SawmillBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.SheetmetalTankBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.SiloBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.SqueezerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.StructuralArmBlock;
import blusunrize.immersiveengineering.common.blocks.metal.TeslaCoilBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ThermoelectricGenBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ToolboxBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TransformerBlock;
import blusunrize.immersiveengineering.common.blocks.metal.TransformerBlockItem;
import blusunrize.immersiveengineering.common.blocks.metal.TransformerHVBlock;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlock;
import blusunrize.immersiveengineering.common.blocks.metal.TurretChemBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunBlockEntity;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import blusunrize.immersiveengineering.common.blocks.plant.PottedHempBlock;
import blusunrize.immersiveengineering.common.blocks.stone.AlloySmelterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.stone.BlastFurnaceAdvancedBlockEntity;
import blusunrize.immersiveengineering.common.blocks.stone.BlastFurnaceBlockEntity;
import blusunrize.immersiveengineering.common.blocks.stone.CokeOvenBlockEntity;
import blusunrize.immersiveengineering.common.blocks.stone.CoresampleBlockEntity;
import blusunrize.immersiveengineering.common.blocks.stone.PartialConcreteBlock;
import blusunrize.immersiveengineering.common.blocks.stone.SlagGravelBlock;
import blusunrize.immersiveengineering.common.blocks.stone.StoneMultiBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.BarrelBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.CircuitTableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.CraftingTableBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.DeskBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.FluidSorterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.GunpowderBarrelBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.ItemBatcherBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.LogicUnitBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.SawdustBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.blocks.wooden.TurntableBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.WatermillBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.WindmillBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.WoodenCrateBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class IEBlocks {
    public static final DeferredRegister<Block> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"immersiveengineering");
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_PROPS = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(2.0f, 10.0f);
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_LEADED_PROPS = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(2.0f, 180.0f);
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_PROPS_NOT_SOLID = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(2.0f, 10.0f).m_60955_();
    private static final Supplier<BlockBehaviour.Properties> SHEETMETAL_PROPERTIES = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 10.0f);
    private static final Supplier<BlockBehaviour.Properties> STANDARD_WOOD_PROPERTIES = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 5.0f);
    private static final Supplier<BlockBehaviour.Properties> STANDARD_WOOD_PROPERTIES_NO_OVERLAY = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 5.0f).m_60971_((state, blockReader, pos) -> false);
    private static final Supplier<BlockBehaviour.Properties> STANDARD_WOOD_PROPERTIES_NO_OCCLUSION = () -> STANDARD_WOOD_PROPERTIES_NO_OVERLAY.get().m_60955_();
    private static final Supplier<BlockBehaviour.Properties> DEFAULT_METAL_PROPERTIES = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60999_().m_60913_(3.0f, 15.0f);
    private static final Supplier<BlockBehaviour.Properties> METAL_PROPERTIES_NO_OVERLAY = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 15.0f).m_60999_().m_60971_((state, blockReader, pos) -> false);
    private static final Supplier<BlockBehaviour.Properties> METAL_PROPERTIES_NO_OCCLUSION = () -> METAL_PROPERTIES_NO_OVERLAY.get().m_60955_();
    public static final Map<ResourceLocation, BlockEntry<SlabBlock>> TO_SLAB = new HashMap<ResourceLocation, BlockEntry<SlabBlock>>();
    public static final Map<ResourceLocation, BlockEntry<IEStairsBlock>> TO_STAIRS = new HashMap<ResourceLocation, BlockEntry<IEStairsBlock>>();

    private IEBlocks() {
    }

    private static <T extends Block> void registerStairs(BlockEntry<T> fullBlock) {
        TO_STAIRS.put(fullBlock.getId(), new BlockEntry<IEStairsBlock>("stairs_" + fullBlock.getId().m_135815_(), fullBlock::getProperties, p -> new IEStairsBlock((BlockBehaviour.Properties)p, fullBlock)));
    }

    private static <T extends Block> void registerSlab(BlockEntry<T> fullBlock) {
        TO_SLAB.put(fullBlock.getId(), new BlockEntry<SlabBlock>("slab_" + fullBlock.getId().m_135815_(), fullBlock::getProperties, p -> new BlockIESlab((BlockBehaviour.Properties)p, fullBlock)));
    }

    public static void init() {
        REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        StoneDecoration.init();
        Multiblocks.init();
        Metals.init();
        WoodenDecoration.init();
        WoodenDevices.init();
        MetalDecoration.init();
        MetalDevices.init();
        Connectors.init();
        Cloth.init();
        Misc.init();
        IEBlocks.registerSlab(StoneDecoration.COKEBRICK);
        IEBlocks.registerSlab(StoneDecoration.BLASTBRICK);
        IEBlocks.registerSlab(StoneDecoration.BLASTBRICK_REINFORCED);
        IEBlocks.registerSlab(StoneDecoration.COKE);
        IEBlocks.registerSlab(StoneDecoration.HEMPCRETE);
        IEBlocks.registerSlab(StoneDecoration.CONCRETE);
        IEBlocks.registerSlab(StoneDecoration.CONCRETE_TILE);
        IEBlocks.registerSlab(StoneDecoration.CONCRETE_LEADED);
        IEBlocks.registerSlab(StoneDecoration.INSULATING_GLASS);
        IEBlocks.registerSlab(StoneDecoration.ALLOYBRICK);
        IEBlocks.registerStairs(StoneDecoration.HEMPCRETE);
        IEBlocks.registerStairs(StoneDecoration.CONCRETE);
        IEBlocks.registerStairs(StoneDecoration.CONCRETE_TILE);
        IEBlocks.registerStairs(StoneDecoration.CONCRETE_LEADED);
        for (BlockEntry<?> entry : BlockEntry.ALL_ENTRIES) {
            if (entry == Misc.FAKE_LIGHT || entry == Misc.POTTED_HEMP || entry == StoneDecoration.CORESAMPLE || entry == MetalDevices.TOOLBOX || entry == Cloth.SHADER_BANNER || entry == Cloth.SHADER_BANNER_WALL || entry == Misc.HEMP_PLANT || entry == Connectors.POST_TRANSFORMER || IEFluids.ALL_FLUID_BLOCKS.contains(entry)) continue;
            Function<Block, BlockItemIE> toItem = entry == Cloth.BALLOON ? BlockItemBalloon::new : (entry == Connectors.TRANSFORMER ? TransformerBlockItem::new : (entry == MetalDevices.CAPACITOR_LV ? block -> new BlockItemCapacitor((Block)block, IEServerConfig.MACHINES.lvCapConfig) : (entry == MetalDevices.CAPACITOR_MV ? block -> new BlockItemCapacitor((Block)block, IEServerConfig.MACHINES.mvCapConfig) : (entry == MetalDevices.CAPACITOR_HV ? block -> new BlockItemCapacitor((Block)block, IEServerConfig.MACHINES.hvCapConfig) : (entry == WoodenDevices.CRATE || entry == WoodenDevices.REINFORCED_CRATE ? BlockItemIE.BlockItemIENoInventory::new : BlockItemIE::new)))));
            if (entry == StoneDecoration.COKE) {
                toItem = toItem.andThen(b -> b.setBurnTime(32000));
            }
            Function<Block, BlockItemIE> finalToItem = toItem;
            IEItems.REGISTER.register(entry.getId().m_135815_(), () -> (BlockItemIE)((Object)((Object)finalToItem.apply((Block)entry.get()))));
        }
    }

    public static final class BlockEntry<T extends Block>
    implements Supplier<T>,
    ItemLike {
        public static final Collection<BlockEntry<?>> ALL_ENTRIES = new ArrayList();
        private final RegistryObject<T> regObject;
        private final Supplier<BlockBehaviour.Properties> properties;

        public static BlockEntry<IEBaseBlock> simple(String name, Supplier<BlockBehaviour.Properties> properties, Consumer<IEBaseBlock> extra) {
            return new BlockEntry<IEBaseBlock>(name, properties, p -> (IEBaseBlock)Util.m_137469_((Object)new IEBaseBlock((BlockBehaviour.Properties)p), (Consumer)extra));
        }

        public static BlockEntry<IEBaseBlock> simple(String name, Supplier<BlockBehaviour.Properties> properties) {
            return BlockEntry.simple(name, properties, $ -> {});
        }

        public static BlockEntry<IEEntityBlock<?>> barrel(String name, boolean metal) {
            return new BlockEntry(name, () -> BarrelBlock.getProperties(metal), p -> BarrelBlock.make(p, metal));
        }

        public static BlockEntry<ScaffoldingBlock> scaffolding(String name, Supplier<BlockBehaviour.Properties> props) {
            return new BlockEntry<ScaffoldingBlock>(name, props, ScaffoldingBlock::new);
        }

        public static BlockEntry<FenceBlock> fence(String name, Supplier<BlockBehaviour.Properties> props) {
            return new BlockEntry<FenceBlock>(name, props, FenceBlock::new);
        }

        public static BlockEntry<PostBlock> post(String name, Supplier<BlockBehaviour.Properties> props) {
            return new BlockEntry<PostBlock>(name, props, PostBlock::new);
        }

        public static BlockEntry<WallmountBlock> wallmount(String name, Supplier<BlockBehaviour.Properties> props) {
            return new BlockEntry<WallmountBlock>(name, props, WallmountBlock::new);
        }

        public BlockEntry(String name, Supplier<BlockBehaviour.Properties> properties, Function<BlockBehaviour.Properties, T> make) {
            this.properties = properties;
            this.regObject = REGISTER.register(name, () -> (Block)make.apply((BlockBehaviour.Properties)properties.get()));
            ALL_ENTRIES.add(this);
        }

        public BlockEntry(T existing) {
            this.properties = () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)existing);
            this.regObject = RegistryObject.create((ResourceLocation)Registry.f_122824_.m_7981_(existing), (IForgeRegistry)ForgeRegistries.BLOCKS);
        }

        public BlockEntry(BlockEntry<? extends T> toCopy) {
            this.properties = toCopy.properties;
            this.regObject = toCopy.regObject;
        }

        @Override
        public T get() {
            return (T)((Block)this.regObject.get());
        }

        public BlockState defaultBlockState() {
            return this.get().m_49966_();
        }

        public ResourceLocation getId() {
            return this.regObject.getId();
        }

        public BlockBehaviour.Properties getProperties() {
            return this.properties.get();
        }

        @Nonnull
        public Item m_5456_() {
            return this.get().m_5456_();
        }
    }

    public static final class StoneDecoration {
        public static final BlockEntry<IEBaseBlock> COKEBRICK = BlockEntry.simple("cokebrick", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> BLASTBRICK = BlockEntry.simple("blastbrick", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> BLASTBRICK_REINFORCED = BlockEntry.simple("blastbrick_reinforced", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> COKE = BlockEntry.simple("coke", STONE_DECO_PROPS);
        public static final BlockEntry<SlagGravelBlock> SLAG_GRAVEL = new BlockEntry<SlagGravelBlock>("slag_gravel", () -> BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)MaterialColor.f_76409_).m_60978_(0.6f).m_60918_(SoundType.f_56739_), SlagGravelBlock::new);
        public static final BlockEntry<IEBaseBlock> HEMPCRETE = BlockEntry.simple("hempcrete", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE = BlockEntry.simple("concrete", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_TILE = BlockEntry.simple("concrete_tile", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_LEADED = BlockEntry.simple("concrete_leaded", STONE_DECO_LEADED_PROPS);
        public static final BlockEntry<IEBaseBlock> INSULATING_GLASS = BlockEntry.simple("insulating_glass", STONE_DECO_PROPS_NOT_SOLID);
        public static final BlockEntry<IEBaseBlock> SLAG_GLASS = BlockEntry.simple("slag_glass", STONE_DECO_PROPS_NOT_SOLID, shouldHave -> shouldHave.setLightOpacity(8));
        public static final BlockEntry<IEBaseBlock> CONCRETE_SPRAYED = BlockEntry.simple("concrete_sprayed", () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(0.2f, 1.0f).m_60955_());
        public static final BlockEntry<IEBaseBlock> ALLOYBRICK = BlockEntry.simple("alloybrick", STONE_DECO_PROPS);
        public static final BlockEntry<PartialConcreteBlock> CONCRETE_SHEET = new BlockEntry<PartialConcreteBlock>("concrete_sheet", PartialConcreteBlock::makeProperties, props -> new PartialConcreteBlock((BlockBehaviour.Properties)props, 1));
        public static final BlockEntry<PartialConcreteBlock> CONCRETE_QUARTER = new BlockEntry<PartialConcreteBlock>("concrete_quarter", PartialConcreteBlock::makeProperties, props -> new PartialConcreteBlock((BlockBehaviour.Properties)props, 4));
        public static final BlockEntry<PartialConcreteBlock> CONCRETE_THREE_QUARTER = new BlockEntry<PartialConcreteBlock>("concrete_three_quarter", PartialConcreteBlock::makeProperties, props -> new PartialConcreteBlock((BlockBehaviour.Properties)props, 12));
        public static final BlockEntry<HorizontalFacingBlock<CoresampleBlockEntity>> CORESAMPLE = new BlockEntry<HorizontalFacingBlock>("coresample", STONE_DECO_PROPS_NOT_SOLID, p -> new HorizontalFacingBlock<CoresampleBlockEntity>(IEBlockEntities.CORE_SAMPLE, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEBaseBlock> DUROPLAST = BlockEntry.simple("duroplast", STONE_DECO_PROPS_NOT_SOLID);

        private static void init() {
        }
    }

    public static final class Multiblocks {
        public static final BlockEntry<StoneMultiBlock<CokeOvenBlockEntity>> COKE_OVEN = new BlockEntry<StoneMultiBlock>("coke_oven", StoneMultiBlock.properties(true), p -> new StoneMultiBlock<CokeOvenBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.COKE_OVEN));
        public static final BlockEntry<StoneMultiBlock<BlastFurnaceBlockEntity.CrudeBlastFurnaceBlockEntity>> BLAST_FURNACE = new BlockEntry<StoneMultiBlock>("blast_furnace", StoneMultiBlock.properties(true), p -> new StoneMultiBlock<BlastFurnaceBlockEntity.CrudeBlastFurnaceBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.BLAST_FURNACE));
        public static final BlockEntry<StoneMultiBlock<AlloySmelterBlockEntity>> ALLOY_SMELTER = new BlockEntry<StoneMultiBlock>("alloy_smelter", StoneMultiBlock.properties(true), p -> new StoneMultiBlock<AlloySmelterBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.ALLOY_SMELTER));
        public static final BlockEntry<StoneMultiBlock<BlastFurnaceAdvancedBlockEntity>> ADVANCED_BLAST_FURNACE = new BlockEntry<StoneMultiBlock>("advanced_blast_furnace", StoneMultiBlock.properties(false), p -> new StoneMultiBlock<BlastFurnaceAdvancedBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.BLAST_FURNACE_ADVANCED));
        public static final BlockEntry<MetalMultiblockBlock<MetalPressBlockEntity>> METAL_PRESS = new BlockEntry<MetalMultiblockBlock>("metal_press", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<MetalPressBlockEntity>(IEBlockEntities.METAL_PRESS, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<CrusherBlockEntity>> CRUSHER = new BlockEntry<MetalMultiblockBlock>("crusher", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<CrusherBlockEntity>(IEBlockEntities.CRUSHER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<SawmillBlockEntity>> SAWMILL = new BlockEntry<MetalMultiblockBlock>("sawmill", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<SawmillBlockEntity>(IEBlockEntities.SAWMILL, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<SheetmetalTankBlockEntity>> TANK = new BlockEntry<MetalMultiblockBlock>("tank", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<SheetmetalTankBlockEntity>(IEBlockEntities.SHEETMETAL_TANK, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<SiloBlockEntity>> SILO = new BlockEntry<MetalMultiblockBlock>("silo", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<SiloBlockEntity>(IEBlockEntities.SILO, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<AssemblerBlockEntity>> ASSEMBLER = new BlockEntry<MetalMultiblockBlock>("assembler", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<AssemblerBlockEntity>(IEBlockEntities.ASSEMBLER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<AutoWorkbenchBlockEntity>> AUTO_WORKBENCH = new BlockEntry<MetalMultiblockBlock>("auto_workbench", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<AutoWorkbenchBlockEntity>(IEBlockEntities.AUTO_WORKBENCH, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<BottlingMachineBlockEntity>> BOTTLING_MACHINE = new BlockEntry<MetalMultiblockBlock>("bottling_machine", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<BottlingMachineBlockEntity>(IEBlockEntities.BOTTLING_MACHINE, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<SqueezerBlockEntity>> SQUEEZER = new BlockEntry<MetalMultiblockBlock>("squeezer", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<SqueezerBlockEntity>(IEBlockEntities.SQUEEZER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<FermenterBlockEntity>> FERMENTER = new BlockEntry<MetalMultiblockBlock>("fermenter", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<FermenterBlockEntity>(IEBlockEntities.FERMENTER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<RefineryBlockEntity>> REFINERY = new BlockEntry<MetalMultiblockBlock>("refinery", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<RefineryBlockEntity>(IEBlockEntities.REFINERY, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<DieselGeneratorBlockEntity>> DIESEL_GENERATOR = new BlockEntry<MetalMultiblockBlock>("diesel_generator", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<DieselGeneratorBlockEntity>(IEBlockEntities.DIESEL_GENERATOR, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<ExcavatorBlockEntity>> EXCAVATOR = new BlockEntry<MetalMultiblockBlock>("excavator", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<ExcavatorBlockEntity>(IEBlockEntities.EXCAVATOR, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<BucketWheelBlockEntity>> BUCKET_WHEEL = new BlockEntry<MetalMultiblockBlock>("bucket_wheel", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<BucketWheelBlockEntity>(IEBlockEntities.BUCKET_WHEEL, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<ArcFurnaceBlockEntity>> ARC_FURNACE = new BlockEntry<MetalMultiblockBlock>("arc_furnace", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<ArcFurnaceBlockEntity>(IEBlockEntities.ARC_FURNACE, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<LightningrodBlockEntity>> LIGHTNING_ROD = new BlockEntry<MetalMultiblockBlock>("lightning_rod", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<LightningrodBlockEntity>(IEBlockEntities.LIGHTNING_ROD, (BlockBehaviour.Properties)p));
        public static final BlockEntry<MetalMultiblockBlock<MixerBlockEntity>> MIXER = new BlockEntry<MetalMultiblockBlock>("mixer", METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalMultiblockBlock<MixerBlockEntity>(IEBlockEntities.MIXER, (BlockBehaviour.Properties)p));

        private static void init() {
        }
    }

    public static final class Metals {
        public static final Map<EnumMetals, BlockEntry<Block>> ORES = new EnumMap<EnumMetals, BlockEntry<Block>>(EnumMetals.class);
        public static final Map<EnumMetals, BlockEntry<Block>> DEEPSLATE_ORES = new EnumMap<EnumMetals, BlockEntry<Block>>(EnumMetals.class);
        public static final Map<EnumMetals, BlockEntry<Block>> RAW_ORES = new EnumMap<EnumMetals, BlockEntry<Block>>(EnumMetals.class);
        public static final Map<EnumMetals, BlockEntry<Block>> STORAGE = new EnumMap<EnumMetals, BlockEntry<Block>>(EnumMetals.class);
        public static final Map<EnumMetals, BlockEntry<IEBaseBlock>> SHEETMETAL = new EnumMap<EnumMetals, BlockEntry<IEBaseBlock>>(EnumMetals.class);

        private static void init() {
            for (EnumMetals m : EnumMetals.values()) {
                BlockEntry<Block> storage;
                String name = m.tagName();
                BlockEntry<IEBaseBlock> ore = null;
                BlockEntry<IEBaseBlock> deepslateOre = null;
                BlockEntry<IEBaseBlock> rawOre = null;
                BlockEntry<IEBaseBlock> sheetmetal = BlockEntry.simple("sheetmetal_" + name, SHEETMETAL_PROPERTIES);
                IEBlocks.registerSlab(sheetmetal);
                SHEETMETAL.put(m, sheetmetal);
                if (m.shouldAddOre()) {
                    ore = new BlockEntry<IEBaseBlock>(BlockEntry.simple("ore_" + name, () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(3.0f, 3.0f).m_60999_()));
                    deepslateOre = new BlockEntry<IEBaseBlock>(BlockEntry.simple("deepslate_ore_" + name, () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155949_(MaterialColor.f_164534_).m_60918_(SoundType.f_154677_).m_60913_(4.5f, 3.0f).m_60999_()));
                    rawOre = new BlockEntry<IEBaseBlock>(BlockEntry.simple("raw_block_" + name, () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(5.0f, 6.0f).m_60999_()));
                }
                if (!m.isVanillaMetal()) {
                    BlockEntry<IEBaseBlock> storageIE = BlockEntry.simple("storage_" + name, () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(m == EnumMetals.STEEL ? SoundType.f_56725_ : SoundType.f_56743_).m_60913_(5.0f, 10.0f).m_60999_());
                    IEBlocks.registerSlab(storageIE);
                    storage = new BlockEntry<IEBaseBlock>(storageIE);
                } else if (m == EnumMetals.IRON) {
                    storage = new BlockEntry<Block>(Blocks.f_50075_);
                    ore = new BlockEntry<Block>(Blocks.f_49996_);
                    deepslateOre = new BlockEntry<Block>(Blocks.f_152468_);
                    rawOre = new BlockEntry<Block>(Blocks.f_152598_);
                } else if (m == EnumMetals.GOLD) {
                    storage = new BlockEntry<Block>(Blocks.f_50074_);
                    ore = new BlockEntry<Block>(Blocks.f_49995_);
                    deepslateOre = new BlockEntry<Block>(Blocks.f_152467_);
                    rawOre = new BlockEntry<Block>(Blocks.f_152600_);
                } else if (m == EnumMetals.COPPER) {
                    storage = new BlockEntry<Block>(Blocks.f_152504_);
                    ore = new BlockEntry<Block>(Blocks.f_152505_);
                    deepslateOre = new BlockEntry<Block>(Blocks.f_152506_);
                    rawOre = new BlockEntry<Block>(Blocks.f_152599_);
                } else {
                    throw new RuntimeException("Unkown vanilla metal: " + m.name());
                }
                STORAGE.put(m, storage);
                if (ore != null) {
                    ORES.put(m, ore);
                }
                if (deepslateOre != null) {
                    DEEPSLATE_ORES.put(m, deepslateOre);
                }
                if (deepslateOre == null) continue;
                RAW_ORES.put(m, rawOre);
            }
        }
    }

    public static final class WoodenDecoration {
        public static final Map<TreatedWoodStyles, BlockEntry<IEBaseBlock>> TREATED_WOOD = new EnumMap<TreatedWoodStyles, BlockEntry<IEBaseBlock>>(TreatedWoodStyles.class);
        public static final BlockEntry<FenceBlock> TREATED_FENCE = BlockEntry.fence("treated_fence", STANDARD_WOOD_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<ScaffoldingBlock> TREATED_SCAFFOLDING = BlockEntry.scaffolding("treated_scaffold", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION);
        public static final BlockEntry<PostBlock> TREATED_POST = BlockEntry.post("treated_post", STANDARD_WOOD_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<SawdustBlock> SAWDUST = new BlockEntry<SawdustBlock>("sawdust", () -> BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76400_).m_60918_(SoundType.f_56746_).m_60978_(0.5f).m_60910_().m_60955_(), SawdustBlock::new);
        public static final BlockEntry<IEBaseBlock> FIBERBOARD = BlockEntry.simple("fiberboard", () -> BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(1.25f, 1.0f));

        private static void init() {
            for (TreatedWoodStyles style : TreatedWoodStyles.values()) {
                BlockEntry<IEBaseBlock> baseBlock = BlockEntry.simple("treated_wood_" + style.name().toLowerCase(Locale.US), STANDARD_WOOD_PROPERTIES, shouldHave -> shouldHave.setHasFlavour(true));
                TREATED_WOOD.put(style, baseBlock);
                IEBlocks.registerSlab(baseBlock);
                IEBlocks.registerStairs(baseBlock);
            }
        }
    }

    public static final class WoodenDevices {
        public static final BlockEntry<CraftingTableBlock> CRAFTING_TABLE = new BlockEntry<CraftingTableBlock>("craftingtable", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, CraftingTableBlock::new);
        public static final BlockEntry<DeskBlock<ModWorkbenchBlockEntity>> WORKBENCH = new BlockEntry<DeskBlock>("workbench", DeskBlock.PROPERTIES, p -> new DeskBlock<ModWorkbenchBlockEntity>(IEBlockEntities.MOD_WORKBENCH, (BlockBehaviour.Properties)p));
        public static final BlockEntry<DeskBlock<CircuitTableBlockEntity>> CIRCUIT_TABLE = new BlockEntry<DeskBlock>("circuit_table", DeskBlock.PROPERTIES, p -> new DeskBlock<CircuitTableBlockEntity>(IEBlockEntities.CIRCUIT_TABLE, (BlockBehaviour.Properties)p));
        public static final BlockEntry<GunpowderBarrelBlock> GUNPOWDER_BARREL = new BlockEntry<GunpowderBarrelBlock>("gunpowder_barrel", GunpowderBarrelBlock.PROPERTIES, GunpowderBarrelBlock::new);
        public static final BlockEntry<IEEntityBlock<?>> WOODEN_BARREL = BlockEntry.barrel("wooden_barrel", false);
        public static final BlockEntry<TurntableBlock> TURNTABLE = new BlockEntry<TurntableBlock>("turntable", STANDARD_WOOD_PROPERTIES, TurntableBlock::new);
        public static final BlockEntry<IEEntityBlock<WoodenCrateBlockEntity>> CRATE = new BlockEntry<IEEntityBlock>("crate", STANDARD_WOOD_PROPERTIES, p -> new IEEntityBlock<WoodenCrateBlockEntity>(IEBlockEntities.WOODEN_CRATE, (BlockBehaviour.Properties)p, false));
        public static final BlockEntry<IEEntityBlock<WoodenCrateBlockEntity>> REINFORCED_CRATE = new BlockEntry<IEEntityBlock>("reinforced_crate", () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 1200000.0f), p -> new IEEntityBlock<WoodenCrateBlockEntity>(IEBlockEntities.WOODEN_CRATE, (BlockBehaviour.Properties)p, false));
        public static final BlockEntry<IEEntityBlock<SorterBlockEntity>> SORTER = new BlockEntry<IEEntityBlock>("sorter", STANDARD_WOOD_PROPERTIES, p -> new IEEntityBlock<SorterBlockEntity>(IEBlockEntities.SORTER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<ItemBatcherBlock> ITEM_BATCHER = new BlockEntry<ItemBatcherBlock>("item_batcher", STANDARD_WOOD_PROPERTIES, ItemBatcherBlock::new);
        public static final BlockEntry<IEEntityBlock<FluidSorterBlockEntity>> FLUID_SORTER = new BlockEntry<IEEntityBlock>("fluid_sorter", STANDARD_WOOD_PROPERTIES, p -> new IEEntityBlock<FluidSorterBlockEntity>(IEBlockEntities.FLUID_SORTER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<WindmillBlock> WINDMILL = new BlockEntry<WindmillBlock>("windmill", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, WindmillBlock::new);
        public static final BlockEntry<WatermillBlock> WATERMILL = new BlockEntry<WatermillBlock>("watermill", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, WatermillBlock::new);
        public static final BlockEntry<WallmountBlock> TREATED_WALLMOUNT = BlockEntry.wallmount("treated_wallmount", STANDARD_WOOD_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<HorizontalFacingBlock<LogicUnitBlockEntity>> LOGIC_UNIT = new BlockEntry<HorizontalFacingBlock>("logic_unit", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, p -> new HorizontalFacingBlock<LogicUnitBlockEntity>(IEBlockEntities.LOGIC_UNIT, (BlockBehaviour.Properties)p));

        private static void init() {
        }
    }

    public static final class MetalDecoration {
        public static final BlockEntry<IEBaseBlock> LV_COIL = BlockEntry.simple("coil_lv", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> MV_COIL = BlockEntry.simple("coil_mv", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> HV_COIL = BlockEntry.simple("coil_hv", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> ENGINEERING_RS = BlockEntry.simple("rs_engineering", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> ENGINEERING_HEAVY = BlockEntry.simple("heavy_engineering", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> ENGINEERING_LIGHT = BlockEntry.simple("light_engineering", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> GENERATOR = BlockEntry.simple("generator", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> RADIATOR = BlockEntry.simple("radiator", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<FenceBlock> STEEL_FENCE = BlockEntry.fence("steel_fence", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<FenceBlock> ALU_FENCE = BlockEntry.fence("alu_fence", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<WallmountBlock> STEEL_WALLMOUNT = BlockEntry.wallmount("steel_wallmount", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<WallmountBlock> ALU_WALLMOUNT = BlockEntry.wallmount("alu_wallmount", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<PostBlock> STEEL_POST = BlockEntry.post("steel_post", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<PostBlock> ALU_POST = BlockEntry.post("alu_post", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<LanternBlock> LANTERN = new BlockEntry<LanternBlock>("lantern", LanternBlock.PROPERTIES, LanternBlock::new);
        public static final BlockEntry<StructuralArmBlock> STEEL_SLOPE = new BlockEntry<StructuralArmBlock>("steel_slope", METAL_PROPERTIES_NO_OCCLUSION, StructuralArmBlock::new);
        public static final BlockEntry<StructuralArmBlock> ALU_SLOPE = new BlockEntry<StructuralArmBlock>("alu_slope", METAL_PROPERTIES_NO_OCCLUSION, StructuralArmBlock::new);
        public static final Map<MetalLadderBlock.CoverType, BlockEntry<MetalLadderBlock>> METAL_LADDER = new EnumMap<MetalLadderBlock.CoverType, BlockEntry<MetalLadderBlock>>(MetalLadderBlock.CoverType.class);
        public static final Map<MetalScaffoldingType, BlockEntry<ScaffoldingBlock>> STEEL_SCAFFOLDING = new EnumMap<MetalScaffoldingType, BlockEntry<ScaffoldingBlock>>(MetalScaffoldingType.class);
        public static final Map<MetalScaffoldingType, BlockEntry<ScaffoldingBlock>> ALU_SCAFFOLDING = new EnumMap<MetalScaffoldingType, BlockEntry<ScaffoldingBlock>>(MetalScaffoldingType.class);
        public static final Map<DyeColor, BlockEntry<IEBaseBlock>> COLORED_SHEETMETAL = new EnumMap<DyeColor, BlockEntry<IEBaseBlock>>(DyeColor.class);

        private static void init() {
            for (DyeColor dyeColor : DyeColor.values()) {
                BlockEntry<IEBaseBlock> sheetmetal = BlockEntry.simple("sheetmetal_colored_" + dyeColor.m_41065_(), SHEETMETAL_PROPERTIES);
                COLORED_SHEETMETAL.put(dyeColor, sheetmetal);
                IEBlocks.registerSlab(sheetmetal);
            }
            for (MetalLadderBlock.CoverType coverType : MetalLadderBlock.CoverType.values()) {
                METAL_LADDER.put(coverType, new BlockEntry<MetalLadderBlock>("metal_ladder_" + coverType.name().toLowerCase(Locale.US), METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalLadderBlock(coverType, (BlockBehaviour.Properties)p)));
            }
            for (MetalScaffoldingType metalScaffoldingType : MetalScaffoldingType.values()) {
                String name = metalScaffoldingType.name().toLowerCase(Locale.ENGLISH);
                BlockEntry<ScaffoldingBlock> steelBlock = BlockEntry.scaffolding("steel_scaffolding_" + name, METAL_PROPERTIES_NO_OCCLUSION);
                BlockEntry<ScaffoldingBlock> aluBlock = BlockEntry.scaffolding("alu_scaffolding_" + name, METAL_PROPERTIES_NO_OCCLUSION);
                STEEL_SCAFFOLDING.put(metalScaffoldingType, steelBlock);
                ALU_SCAFFOLDING.put(metalScaffoldingType, aluBlock);
                IEBlocks.registerSlab(steelBlock);
                IEBlocks.registerSlab(aluBlock);
                IEBlocks.registerStairs(steelBlock);
                IEBlocks.registerStairs(aluBlock);
            }
        }
    }

    public static final class MetalDevices {
        public static final BlockEntry<RazorWireBlock> RAZOR_WIRE = new BlockEntry<RazorWireBlock>("razor_wire", RazorWireBlock.PROPERTIES, RazorWireBlock::new);
        public static final BlockEntry<HorizontalFacingBlock<ToolboxBlockEntity>> TOOLBOX = new BlockEntry<HorizontalFacingBlock>("toolbox_block", METAL_PROPERTIES_NO_OVERLAY, p -> new HorizontalFacingBlock<ToolboxBlockEntity>(IEBlockEntities.TOOLBOX, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<CapacitorBlockEntity>> CAPACITOR_LV = new BlockEntry<IEEntityBlock>("capacitor_lv", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock<CapacitorBlockEntity>(IEBlockEntities.CAPACITOR_LV, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<CapacitorBlockEntity>> CAPACITOR_MV = new BlockEntry<IEEntityBlock>("capacitor_mv", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock<CapacitorBlockEntity>(IEBlockEntities.CAPACITOR_MV, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<CapacitorBlockEntity>> CAPACITOR_HV = new BlockEntry<IEEntityBlock>("capacitor_hv", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock<CapacitorBlockEntity>(IEBlockEntities.CAPACITOR_HV, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<CapacitorCreativeBlockEntity>> CAPACITOR_CREATIVE = new BlockEntry<IEEntityBlock>("capacitor_creative", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock<CapacitorCreativeBlockEntity>(IEBlockEntities.CAPACITOR_CREATIVE, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<?>> BARREL = BlockEntry.barrel("metal_barrel", true);
        public static final BlockEntry<FluidPumpBlock> FLUID_PUMP = new BlockEntry<FluidPumpBlock>("fluid_pump", METAL_PROPERTIES_NO_OCCLUSION, FluidPumpBlock::new);
        public static final BlockEntry<IEEntityBlock<FluidPlacerBlockEntity>> FLUID_PLACER = new BlockEntry<IEEntityBlock>("fluid_placer", METAL_PROPERTIES_NO_OCCLUSION, p -> new IEEntityBlock<FluidPlacerBlockEntity>(IEBlockEntities.FLUID_PLACER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<BlastFurnacePreheaterBlock> BLAST_FURNACE_PREHEATER = new BlockEntry<BlastFurnacePreheaterBlock>("blastfurnace_preheater", METAL_PROPERTIES_NO_OCCLUSION, BlastFurnacePreheaterBlock::new);
        public static final BlockEntry<FurnaceHeaterBlock> FURNACE_HEATER = new BlockEntry<FurnaceHeaterBlock>("furnace_heater", DEFAULT_METAL_PROPERTIES, FurnaceHeaterBlock::new);
        public static final BlockEntry<HorizontalFacingBlock<DynamoBlockEntity>> DYNAMO = new BlockEntry<HorizontalFacingBlock>("dynamo", DEFAULT_METAL_PROPERTIES, p -> new HorizontalFacingBlock<DynamoBlockEntity>(IEBlockEntities.DYNAMO, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<ThermoelectricGenBlockEntity>> THERMOELECTRIC_GEN = new BlockEntry<IEEntityBlock>("thermoelectric_generator", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock<ThermoelectricGenBlockEntity>(IEBlockEntities.THERMOELECTRIC_GEN, (BlockBehaviour.Properties)p));
        public static final BlockEntry<ElectricLanternBlock> ELECTRIC_LANTERN = new BlockEntry<ElectricLanternBlock>("electric_lantern", ElectricLanternBlock.PROPERTIES, ElectricLanternBlock::new);
        public static final BlockEntry<HorizontalFacingBlock<ChargingStationBlockEntity>> CHARGING_STATION = new BlockEntry<HorizontalFacingBlock>("charging_station", METAL_PROPERTIES_NO_OVERLAY, p -> new HorizontalFacingBlock<ChargingStationBlockEntity>(IEBlockEntities.CHARGING_STATION, (BlockBehaviour.Properties)p));
        public static final BlockEntry<FluidPipeBlock> FLUID_PIPE = new BlockEntry<FluidPipeBlock>("fluid_pipe", METAL_PROPERTIES_NO_OVERLAY, FluidPipeBlock::new);
        public static final BlockEntry<SampleDrillBlock> SAMPLE_DRILL = new BlockEntry<SampleDrillBlock>("sample_drill", METAL_PROPERTIES_NO_OCCLUSION, SampleDrillBlock::new);
        public static final BlockEntry<TeslaCoilBlock> TESLA_COIL = new BlockEntry<TeslaCoilBlock>("tesla_coil", METAL_PROPERTIES_NO_OCCLUSION, TeslaCoilBlock::new);
        public static final BlockEntry<FloodlightBlock> FLOODLIGHT = new BlockEntry<FloodlightBlock>("floodlight", FloodlightBlock.PROPERTIES, FloodlightBlock::new);
        public static final BlockEntry<TurretBlock<TurretChemBlockEntity>> TURRET_CHEM = new BlockEntry<TurretBlock>("turret_chem", METAL_PROPERTIES_NO_OCCLUSION, p -> new TurretBlock<TurretChemBlockEntity>(IEBlockEntities.TURRET_CHEM, (BlockBehaviour.Properties)p));
        public static final BlockEntry<TurretBlock<TurretGunBlockEntity>> TURRET_GUN = new BlockEntry<TurretBlock>("turret_gun", METAL_PROPERTIES_NO_OCCLUSION, p -> new TurretBlock<TurretGunBlockEntity>(IEBlockEntities.TURRET_GUN, (BlockBehaviour.Properties)p));
        public static final BlockEntry<ClocheBlock> CLOCHE = new BlockEntry<ClocheBlock>("cloche", METAL_PROPERTIES_NO_OCCLUSION, ClocheBlock::new);
        public static final Map<IConveyorType<?>, BlockEntry<ConveyorBlock>> CONVEYORS = new HashMap();
        public static final Map<EnumMetals, BlockEntry<ChuteBlock>> CHUTES = new EnumMap<EnumMetals, BlockEntry<ChuteBlock>>(EnumMetals.class);

        private static void init() {
            for (EnumMetals metal : new EnumMetals[]{EnumMetals.IRON, EnumMetals.STEEL, EnumMetals.ALUMINUM, EnumMetals.COPPER}) {
                CHUTES.put(metal, new BlockEntry<ChuteBlock>("chute_" + metal.tagName(), METAL_PROPERTIES_NO_OCCLUSION, ChuteBlock::new));
            }
        }

        public static void initConveyors() {
            Preconditions.checkState((boolean)CONVEYORS.isEmpty());
            for (IConveyorType<?> type : ConveyorHandler.getConveyorTypes()) {
                ResourceLocation rl = type.getId();
                BlockEntry<ConveyorBlock> blockEntry = new BlockEntry<ConveyorBlock>(ConveyorHandler.getRegistryNameFor(rl).m_135815_(), ConveyorBlock.PROPERTIES, p -> new ConveyorBlock(type, (BlockBehaviour.Properties)p));
                CONVEYORS.put(type, blockEntry);
                IEItems.REGISTER.register(blockEntry.getId().m_135815_(), () -> new BlockItemIE((Block)blockEntry.get()));
            }
        }
    }

    public static final class Connectors {
        public static final Map<Pair<String, Boolean>, BlockEntry<BasicConnectorBlock<?>>> ENERGY_CONNECTORS = new HashMap();
        public static final BlockEntry<BasicConnectorBlock<?>> CONNECTOR_STRUCTURAL = new BlockEntry<BasicConnectorBlock>("connector_structural", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock<ConnectorStructuralBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.CONNECTOR_STRUCTURAL));
        public static final BlockEntry<TransformerBlock> TRANSFORMER = new BlockEntry<TransformerBlock>("transformer", ConnectorBlock.PROPERTIES, TransformerBlock::new);
        public static final BlockEntry<PostTransformerBlock> POST_TRANSFORMER = new BlockEntry<PostTransformerBlock>("post_transformer", ConnectorBlock.PROPERTIES, PostTransformerBlock::new);
        public static final BlockEntry<TransformerHVBlock> TRANSFORMER_HV = new BlockEntry<TransformerHVBlock>("transformer_hv", ConnectorBlock.PROPERTIES, TransformerHVBlock::new);
        public static final BlockEntry<BreakerSwitchBlock<?>> BREAKER_SWITCH = new BlockEntry<BreakerSwitchBlock>("breaker_switch", ConnectorBlock.PROPERTIES, p -> new BreakerSwitchBlock<BreakerSwitchBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.BREAKER_SWITCH));
        public static final BlockEntry<BreakerSwitchBlock<?>> REDSTONE_BREAKER = new BlockEntry<BreakerSwitchBlock>("redstone_breaker", ConnectorBlock.PROPERTIES, p -> new BreakerSwitchBlock<RedstoneBreakerBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.REDSTONE_BREAKER));
        public static final BlockEntry<EnergyMeterBlock> CURRENT_TRANSFORMER = new BlockEntry<EnergyMeterBlock>("current_transformer", ConnectorBlock.PROPERTIES, EnergyMeterBlock::new);
        public static final BlockEntry<BasicConnectorBlock<?>> CONNECTOR_REDSTONE = new BlockEntry<BasicConnectorBlock>("connector_redstone", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock<ConnectorRedstoneBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.CONNECTOR_REDSTONE));
        public static final BlockEntry<BasicConnectorBlock<?>> CONNECTOR_PROBE = new BlockEntry<BasicConnectorBlock>("connector_probe", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock<ConnectorProbeBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.CONNECTOR_PROBE));
        public static final BlockEntry<BasicConnectorBlock<?>> CONNECTOR_BUNDLED = new BlockEntry<BasicConnectorBlock>("connector_bundled", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock<ConnectorBundledBlockEntity>((BlockBehaviour.Properties)p, IEBlockEntities.CONNECTOR_BUNDLED));
        public static final BlockEntry<FeedthroughBlock> FEEDTHROUGH = new BlockEntry<FeedthroughBlock>("feedthrough", ConnectorBlock.PROPERTIES, FeedthroughBlock::new);

        public static BlockEntry<BasicConnectorBlock<?>> getEnergyConnector(String cat, boolean relay) {
            return ENERGY_CONNECTORS.get(Pair.of((Object)cat, (Object)relay));
        }

        private static void init() {
            for (String cat : new String[]{"LV", "MV", "HV"}) {
                ENERGY_CONNECTORS.put((Pair<String, Boolean>)Pair.of((Object)cat, (Object)false), BasicConnectorBlock.forPower(cat, false));
                ENERGY_CONNECTORS.put((Pair<String, Boolean>)Pair.of((Object)cat, (Object)true), BasicConnectorBlock.forPower(cat, true));
            }
        }
    }

    public static final class Cloth {
        public static final BlockEntry<CushionBlock> CUSHION = new BlockEntry<CushionBlock>("cushion", CushionBlock.PROPERTIES, CushionBlock::new);
        public static final BlockEntry<BalloonBlock> BALLOON = new BlockEntry<BalloonBlock>("balloon", BalloonBlock.PROPERTIES, BalloonBlock::new);
        public static final BlockEntry<StripCurtainBlock> STRIP_CURTAIN = new BlockEntry<StripCurtainBlock>("strip_curtain", StripCurtainBlock.PROPERTIES, StripCurtainBlock::new);
        public static final BlockEntry<ShaderBannerStandingBlock> SHADER_BANNER = new BlockEntry<ShaderBannerStandingBlock>("shader_banner", ShaderBannerBlock.PROPERTIES, ShaderBannerStandingBlock::new);
        public static final BlockEntry<ShaderBannerWallBlock> SHADER_BANNER_WALL = new BlockEntry<ShaderBannerWallBlock>("shader_banner_wall", ShaderBannerBlock.PROPERTIES, ShaderBannerWallBlock::new);

        private static void init() {
        }
    }

    public static final class Misc {
        public static final BlockEntry<HempBlock> HEMP_PLANT = new BlockEntry<HempBlock>("hemp", HempBlock.PROPERTIES, HempBlock::new);
        public static final BlockEntry<PottedHempBlock> POTTED_HEMP = new BlockEntry<PottedHempBlock>("potted_hemp", PottedHempBlock.PROPERTIES, PottedHempBlock::new);
        public static final BlockEntry<FakeLightBlock> FAKE_LIGHT = new BlockEntry<FakeLightBlock>("fake_light", FakeLightBlock.PROPERTIES, FakeLightBlock::new);

        private static void init() {
        }
    }
}

