/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.api.tool.assembler.AssemblerHandler;
import blusunrize.immersiveengineering.api.tool.assembler.FluidStackRecipeQuery;
import blusunrize.immersiveengineering.api.tool.assembler.FluidTagRecipeQuery;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import blusunrize.immersiveengineering.api.utils.TemplateWorldCreator;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.WireDamageHandler;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.client.utils.ClocheRenderFunctions;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.DropConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ExtractConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.RedstoneConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.SplitConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.VerticalConveyor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.StaticTemplateManager;
import blusunrize.immersiveengineering.common.config.IECommonConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.crafting.DefaultAssemblerAdapter;
import blusunrize.immersiveengineering.common.crafting.IngredientWithSizeSerializer;
import blusunrize.immersiveengineering.common.crafting.fluidaware.IngredientFluidStack;
import blusunrize.immersiveengineering.common.entities.CapabilitySkyhookData;
import blusunrize.immersiveengineering.common.fluids.IEFluid;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerEffects;
import blusunrize.immersiveengineering.common.items.IEMinecartItem;
import blusunrize.immersiveengineering.common.items.RailgunProjectiles;
import blusunrize.immersiveengineering.common.items.WireCoilItem;
import blusunrize.immersiveengineering.common.register.IEBannerPatterns;
import blusunrize.immersiveengineering.common.register.IEBiomeModifiers;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEEntityDataSerializers;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.register.IEParticles;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.register.IEStats;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEShaders;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.commands.IEArgumentTypes;
import blusunrize.immersiveengineering.common.util.fakeworld.TemplateWorld;
import blusunrize.immersiveengineering.common.util.loot.GrassDropModifier;
import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import blusunrize.immersiveengineering.common.wires.IEWireTypes;
import blusunrize.immersiveengineering.common.world.IEWorldGen;
import blusunrize.immersiveengineering.common.world.Villages;
import blusunrize.immersiveengineering.mixin.accessors.ConcretePowderBlockAccess;
import blusunrize.immersiveengineering.mixin.accessors.ItemEntityAccess;
import blusunrize.immersiveengineering.mixin.accessors.TemplateAccess;
import java.io.IOException;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.NewRegistryEvent;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IEContent {
    public static void modConstruction() {
        BulletItem.initBullets();
        IEWireTypes.modConstruction();
        ConveyorHandler.registerMagnetSuppression((entity, iConveyorTile) -> {
            CompoundTag data = entity.getPersistentData();
            if (!data.m_128471_("PreventRemoteMovement")) {
                data.m_128379_("PreventRemoteMovement", true);
            }
        }, (entity, iConveyorTile) -> entity.getPersistentData().m_128473_("PreventRemoteMovement"));
        ConveyorHandler.registerConveyorType(BasicConveyor.TYPE);
        ConveyorHandler.registerConveyorType(RedstoneConveyor.TYPE);
        ConveyorHandler.registerConveyorType(DropConveyor.TYPE);
        ConveyorHandler.registerConveyorType(VerticalConveyor.TYPE);
        ConveyorHandler.registerConveyorType(SplitConveyor.TYPE);
        ConveyorHandler.registerConveyorType(ExtractConveyor.TYPE);
        ShaderRegistry.rarityWeightMap.put(Rarity.COMMON, 9);
        ShaderRegistry.rarityWeightMap.put(Rarity.UNCOMMON, 7);
        ShaderRegistry.rarityWeightMap.put(Rarity.RARE, 5);
        ShaderRegistry.rarityWeightMap.put(Rarity.EPIC, 3);
        ShaderRegistry.rarityWeightMap.put(Lib.RARITY_MASTERWORK, 1);
        IEFluids.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEFluids.TYPE_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEPotions.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEParticles.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEBlockEntities.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEEntityTypes.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEMenuTypes.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEEntityDataSerializers.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEBiomeModifiers.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEStats.modConstruction();
        IEItems.init();
        IESounds.init();
        IEBlocks.init();
        GrassDropModifier.init();
        IERecipeTypes.init();
        IELootFunctions.init();
        IEArgumentTypes.init();
        IEBannerPatterns.init();
        TemplateWorld.init();
        BulletHandler.emptyCasing = IEItems.Ingredients.EMPTY_CASING;
        BulletHandler.emptyShell = IEItems.Ingredients.EMPTY_SHELL;
        ClocheRenderFunctions.init();
        IEShaders.commonConstruction();
        IEMultiblocks.init();
        IEContent.populateAPI();
    }

    @SubscribeEvent
    public static void registerCaps(RegisterCapabilitiesEvent ev) {
        ev.register(CapabilityShader.ShaderWrapper.class);
        ev.register(GlobalWireNetwork.class);
        ev.register(CapabilitySkyhookData.SkyhookUserData.class);
        ev.register(CapabilityRedstoneNetwork.RedstoneBundleConnection.class);
        ev.register(ExternalHeaterHandler.IExternalHeatable.class);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void addMissingRegistrations(NewRegistryEvent event) {
        IEItems.Misc.registerShaderBags();
    }

    public static void commonSetup(ParallelDispatchEvent ev) {
        IEWireTypes.setup();
        IEStats.setup();
        ev.enqueueWork(IEWorldGen::initLate);
        ShaderRegistry.itemShader = IEItems.Misc.SHADER.get();
        ShaderRegistry.itemShaderBag = IEItems.Misc.SHADER_BAG;
        ShaderRegistry.itemExamples.add(new ItemStack(IEItems.Weapons.REVOLVER));
        ShaderRegistry.itemExamples.add(new ItemStack(IEItems.Tools.DRILL));
        ShaderRegistry.itemExamples.add(new ItemStack(IEItems.Weapons.CHEMTHROWER));
        ShaderRegistry.itemExamples.add(new ItemStack(IEItems.Weapons.RAILGUN));
        ShaderRegistry.itemExamples.add(new ItemStack(IEItems.Misc.SHIELD));
        AssemblerHandler.registerSpecialIngredientConverter((o, remain) -> {
            if (o instanceof IngredientFluidStack) {
                return new FluidTagRecipeQuery(((IngredientFluidStack)((Object)o)).getFluidTagInput());
            }
            return null;
        });
        AssemblerHandler.registerSpecialIngredientConverter((o, remain) -> {
            ItemStack[] matching = o.m_43908_();
            if (!o.isVanilla() || matching.length != 1) {
                return null;
            }
            Item potentialBucket = matching[0].m_41720_();
            if (!(potentialBucket instanceof BucketItem)) {
                return null;
            }
            if (remain.m_41720_() != Items.f_42446_) {
                return null;
            }
            if (!potentialBucket.m_41470_() || potentialBucket.m_41469_() != Items.f_42446_) {
                return null;
            }
            Fluid contained = ((BucketItem)potentialBucket).getFluid();
            return new FluidStackRecipeQuery(new FluidStack(contained, 1000));
        });
        AssemblerHandler.registerSpecialIngredientConverter((o, remain) -> {
            ItemStack[] matching = o.m_43908_();
            if (!o.isVanilla() || matching.length != 1) {
                return null;
            }
            if (matching[0].m_41720_() != Items.f_42455_ || !ForgeMod.MILK.isPresent()) {
                return null;
            }
            if (remain.m_41720_() != Items.f_42446_) {
                return null;
            }
            return new FluidStackRecipeQuery(new FluidStack((Fluid)ForgeMod.MILK.get(), 1000));
        });
        IEFluids.CREOSOTE.getBlock().setEffect((MobEffect)IEPotions.FLAMMABLE.get(), 100, 0);
        IEFluids.ETHANOL.getBlock().setEffect(MobEffects.f_19604_, 70, 0);
        IEFluids.BIODIESEL.getBlock().setEffect((MobEffect)IEPotions.FLAMMABLE.get(), 100, 1);
        IEFluids.CONCRETE.getBlock().setEffect(MobEffects.f_19597_, 20, 3);
        IEFluids.REDSTONE_ACID.getBlock().setEffect((MobEffect)IEPotions.CONDUCTIVE.get(), 100, 1);
        IEFluids.ACETALDEHYDE.getBlock().setEffect(MobEffects.f_19604_, 70, 0);
        IEFluids.PHENOLIC_RESIN.getBlock().setEffect((MobEffect)IEPotions.STICKY.get(), 40, 1);
        ChemthrowerEffects.register();
        RailgunProjectiles.register();
        FluidPipeBlockEntity.initCovers();
        LocalNetworkHandler.register(EnergyTransferHandler.ID, EnergyTransferHandler::new);
        LocalNetworkHandler.register(RedstoneNetworkHandler.ID, RedstoneNetworkHandler::new);
        LocalNetworkHandler.register(WireDamageHandler.ID, WireDamageHandler::new);
        ev.enqueueWork(IEContent::onThreadCommonSetup);
    }

    private static void onThreadCommonSetup() {
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(IEBlocks.Misc.HEMP_PLANT.getId(), IEBlocks.Misc.POTTED_HEMP);
        DispenserBlock.m_52672_(IEItems.Misc.SHIELD, (DispenseItemBehavior)ArmorItem.f_40376_);
        DispenserBlock.m_52672_(IEItems.Minecarts.CART_METAL_BARREL, (DispenseItemBehavior)IEMinecartItem.MINECART_DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_(IEItems.Minecarts.CART_WOODEN_BARREL, (DispenseItemBehavior)IEMinecartItem.MINECART_DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_(IEItems.Minecarts.CART_REINFORCED_CRATE, (DispenseItemBehavior)IEMinecartItem.MINECART_DISPENSER_BEHAVIOR);
        DispenserBlock.m_52672_(IEItems.Minecarts.CART_WOODEN_CRATE, (DispenseItemBehavior)IEMinecartItem.MINECART_DISPENSER_BEHAVIOR);
        for (IEFluids.FluidEntry entry : IEFluids.ALL_ENTRIES) {
            DispenserBlock.m_52672_((ItemLike)entry.getBucket(), (DispenseItemBehavior)IEFluid.BUCKET_DISPENSE_BEHAVIOR);
        }
        ComposterBlock.f_51914_.putIfAbsent((Object)IEItems.Misc.HEMP_SEEDS.m_5456_(), 0.3f);
        ComposterBlock.f_51914_.putIfAbsent((Object)IEItems.Ingredients.HEMP_FIBER.m_5456_(), 0.15f);
        Villages.init();
        ShaderRegistry.compileWeight();
    }

    public static void populateAPI() {
        SetRestrictedField.startInitializing(false);
        IngredientWithSize.SERIALIZER.setValue(IngredientWithSizeSerializer.INSTANCE);
        BlueprintCraftingRecipe.blueprintItem.setValue(IEItems.Misc.BLUEPRINT);
        ExcavatorHandler.setSetDirtyCallback(IESaveData::markInstanceDirty);
        TemplateMultiblock.setCallbacks(Utils::getPickBlock, (loc, server) -> {
            try {
                return StaticTemplateManager.loadStaticTemplate(loc, server);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, template -> ((TemplateAccess)template).getPalettes());
        AssemblerHandler.defaultAdapter = new DefaultAssemblerAdapter();
        WirecoilUtils.COIL_USE.setValue(WireCoilItem::doCoilUse);
        AssemblerHandler.registerRecipeAdapter(Recipe.class, AssemblerHandler.defaultAdapter);
        BulletHandler.GET_BULLET_ITEM.setValue(b -> {
            IEItems.ItemRegObject<BulletItem> regObject = IEItems.Weapons.BULLETS.get(b);
            if (regObject != null) {
                return regObject.m_5456_();
            }
            return null;
        });
        ChemthrowerHandler.SOLIDIFY_CONCRETE_POWDER.setValue((world, pos) -> {
            Block b = world.m_8055_(pos).m_60734_();
            if (b instanceof ConcretePowderBlock) {
                world.m_7731_(pos, ((ConcretePowderBlockAccess)b).getConcrete(), 3);
            }
        });
        WireDamageHandler.GET_WIRE_DAMAGE.setValue(IEDamageSources::causeWireDamage);
        GlobalWireNetwork.SANITIZE_CONNECTIONS.setValue(() -> ((ForgeConfigSpec.BooleanValue)IEServerConfig.WIRES.sanitizeConnections).get());
        GlobalWireNetwork.VALIDATE_CONNECTIONS.setValue(() -> ((ForgeConfigSpec.BooleanValue)IECommonConfig.validateNet).get());
        ConveyorHandler.ITEM_AGE_ACCESS.setValue((entity, newAge) -> ((ItemEntityAccess)entity).setAge(newAge));
        TemplateWorldCreator.CREATOR.setValue(TemplateWorld::new);
        ConveyorHandler.CONVEYOR_BLOCKS.setValue(rl -> IEBlocks.MetalDevices.CONVEYORS.get(rl).get());
        ConveyorHandler.BLOCK_ENTITY_TYPES.setValue(rl -> ConveyorBeltBlockEntity.BE_TYPES.get(rl).get());
        SetRestrictedField.lock(false);
    }
}

