/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.gson.JsonElement;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.LanguageProvider;
import org.slf4j.Logger;

public abstract class BookProvider
implements DataProvider {
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected final DataGenerator generator;
    protected final LanguageProvider lang;
    protected final Map<ResourceLocation, BookModel> bookModels;
    protected final String modid;

    public BookProvider(DataGenerator generator, String modid, LanguageProvider lang) {
        this.modid = modid;
        this.generator = generator;
        this.lang = lang;
        this.bookModels = new HashMap<ResourceLocation, BookModel>();
    }

    protected abstract void generate();

    protected ResourceLocation modLoc(String name) {
        return new ResourceLocation(this.modid, name);
    }

    protected BookModel add(BookModel bookModel) {
        if (this.bookModels.containsKey(bookModel.getId())) {
            throw new IllegalStateException("Duplicate book " + bookModel.getId());
        }
        this.bookModels.put(bookModel.getId(), bookModel);
        return bookModel;
    }

    private Path getPath(Path path, BookModel bookModel) {
        ResourceLocation id = bookModel.getId();
        return path.resolve("data/" + id.m_135827_() + "/modonomicon/books/" + id.m_135815_() + "/book.json");
    }

    private Path getPath(Path path, BookCategoryModel bookCategoryModel) {
        ResourceLocation id = bookCategoryModel.getId();
        return path.resolve("data/" + id.m_135827_() + "/modonomicon/books/" + bookCategoryModel.getBook().getId().m_135815_() + "/categories/" + id.m_135815_() + ".json");
    }

    private Path getPath(Path path, BookEntryModel bookEntryModel) {
        ResourceLocation id = bookEntryModel.getId();
        return path.resolve("data/" + id.m_135827_() + "/modonomicon/books/" + bookEntryModel.getCategory().getBook().getId().m_135815_() + "/entries/" + id.m_135815_() + ".json");
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        Path folder = this.generator.m_123916_();
        this.generate();
        for (BookModel bookModel : this.bookModels.values()) {
            Path bookPath = this.getPath(folder, bookModel);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)bookModel.toJson(), (Path)bookPath);
            }
            catch (IOException exception) {
                LOGGER.error("Couldn't save book {}", (Object)bookPath, (Object)exception);
            }
            for (BookCategoryModel bookCategoryModel : bookModel.getCategories()) {
                Path bookCategoryPath = this.getPath(folder, bookCategoryModel);
                try {
                    DataProvider.m_236072_((CachedOutput)cache, (JsonElement)bookCategoryModel.toJson(), (Path)bookCategoryPath);
                }
                catch (IOException exception) {
                    LOGGER.error("Couldn't save book category {}", (Object)bookCategoryPath, (Object)exception);
                }
                for (BookEntryModel bookEntryModel : bookCategoryModel.getEntries()) {
                    Path bookEntryPath = this.getPath(folder, bookEntryModel);
                    try {
                        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)bookEntryModel.toJson(), (Path)bookEntryPath);
                    }
                    catch (IOException exception) {
                        LOGGER.error("Couldn't save book entry {}", (Object)bookEntryPath, (Object)exception);
                    }
                }
            }
        }
    }

    public String m_6055_() {
        return "Books: " + this.modid;
    }
}

