/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.trait;

import com.github.dragoni7.silentcompat.trait.DimensionalEffectTrait;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;

public class InverseDimensionalEffectTrait
extends DimensionalEffectTrait {
    public static final ITraitSerializer<InverseDimensionalEffectTrait> SERIALIZER = new SimpleTrait.Serializer(new ResourceLocation("silentcompat", "inverse_dimensional_effect"), InverseDimensionalEffectTrait::new, DimensionalEffectTrait::deserializeJson, DimensionalEffectTrait::readFromNetwork, DimensionalEffectTrait::writeToNetwork);

    public InverseDimensionalEffectTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    protected void applyEffects(TraitActionContext context, GearType gearType, String type, Iterable<DimensionalEffectTrait.PotionData> effects) {
        Player player = context.getPlayer();
        assert (player != null);
        if (gearType.matches(type) || "all".equals(type)) {
            int setPieceCount = this.getSetPieceCount(type, player);
            boolean hasFullSet = !"armor".equals(type) || setPieceCount >= 4;
            for (DimensionalEffectTrait.PotionData potionData : effects) {
                MobEffectInstance effect = potionData.getEffect(context.getTraitLevel(), setPieceCount, hasFullSet);
                if (effect == null || player.f_19853_.m_46472_().m_135782_().equals((Object)potionData.getDimensionId())) continue;
                player.m_7292_(effect);
            }
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        ret.add("While not in ");
        this.potions.forEach((type, list) -> {
            ret.add("  - " + type);
            list.forEach(mod -> ret.add("    - " + mod.getWikiLine()));
        });
        return ret;
    }
}

