/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.trait;

import com.github.dragoni7.silentcompat.core.registry.SilentCompatEffects;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatSoundEvents;
import com.github.dragoni7.silentcompat.projectiles.BlindingProjectile;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;

public class BlindingTrait
extends SimpleTrait {
    public static final SimpleTrait.Serializer<BlindingTrait> SERIALIZER = new SimpleTrait.Serializer(new ResourceLocation("silentcompat", "blinding"), BlindingTrait::new);

    public BlindingTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    public void onItemSwing(ItemStack stack, LivingEntity wielder, int traitLevel) {
        if (wielder instanceof Player && wielder.m_21023_((MobEffect)SilentCompatEffects.AMPLIFIED.get())) {
            Player player = (Player)wielder;
            Level level = player.f_19853_;
            if (!player.f_19853_.f_46443_ && stack.m_41773_() < stack.m_41776_() - 10 - 1) {
                GearHelper.attemptDamage((ItemStack)stack, (int)10, (LivingEntity)player, (EquipmentSlot)stack.getEquipmentSlot());
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SilentCompatSoundEvents.ELECTRIC_ZAP.get(), SoundSource.PLAYERS, 0.3f, 0.9f);
                Vec3 vec3 = player.m_20252_(1.0f);
                BlindingProjectile projectile = new BlindingProjectile(level, (LivingEntity)player, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, traitLevel * 3);
                projectile.m_6034_(player.m_20185_() + vec3.f_82479_, player.m_20227_(0.5), player.m_20189_() + vec3.f_82481_);
                projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 1.0f);
                level.m_7967_((Entity)projectile);
            }
            player.m_21195_((MobEffect)SilentCompatEffects.AMPLIFIED.get());
        }
    }

    public Collection<String> getExtraWikiLines() {
        Collection ret = super.getExtraWikiLines();
        ret.add("Consumes amplified on tool swing, launching a projectile that blinds, damages, and slows targets. Damage is equal to 3 times the trait level");
        return ret;
    }
}

