/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.event;

import com.github.dragoni7.silentcompat.consts.ModEffectsLocs;
import com.github.dragoni7.silentcompat.consts.TraitConst;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatEffects;
import com.github.dragoni7.silentcompat.networking.Networking;
import com.github.dragoni7.silentcompat.networking.PacketImmuneParticles;
import com.github.dragoni7.silentcompat.trait.LuckyBreak;
import com.github.dragoni7.silentcompat.world.VolitileExplosion;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

@Mod.EventBusSubscriber
public class TraitEventHandler {
    private static final EquipmentSlot[] ARMOR_ONLY = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity attacked = event.getEntity();
        Entity attacker = event.getSource().m_7640_();
        if (attacked instanceof Player) {
            ServerPlayer serverPlayer = null;
            if (attacked instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)attacked;
            }
            if (attacker instanceof LivingEntity) {
                ItemStack stack;
                DamageSource source = event.getSource();
                RandomSource random = attacked.m_217043_();
                int dodgeCount = 0;
                int dodgeLevel = 0;
                int emuDodgeCount = 0;
                int emuDodgeLevel = 0;
                int purifyingCount = 0;
                int purifyingLevel = 0;
                for (Object slot : ARMOR_ONLY) {
                    stack = event.getEntity().m_6844_(slot);
                    if (source.m_19360_()) {
                        if (!GearHelper.isGear((ItemStack)stack) || !TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.EMU_DODGE.get()))) continue;
                        ++emuDodgeCount;
                        if (emuDodgeLevel >= TraitHelper.getTraitLevel((ItemStack)stack, (ITrait)((ITrait)TraitConst.EMU_DODGE.get()))) continue;
                        emuDodgeLevel = TraitHelper.getTraitLevel((ItemStack)stack, (ITrait)((ITrait)TraitConst.EMU_DODGE.get()));
                        continue;
                    }
                    if (GearHelper.isGear((ItemStack)stack) && TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.DODGING.get())) && !source.m_19376_()) {
                        ++dodgeCount;
                        if (dodgeLevel >= TraitHelper.getTraitLevel((ItemStack)stack, (ITrait)((ITrait)TraitConst.DODGING.get()))) continue;
                        dodgeLevel = TraitHelper.getTraitLevel((ItemStack)stack, (ITrait)((ITrait)TraitConst.DODGING.get()));
                        continue;
                    }
                    if (!GearHelper.isGear((ItemStack)stack) || !TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.PURIFYING.get()))) continue;
                    ++purifyingCount;
                    if (purifyingLevel >= TraitHelper.getTraitLevel((ItemStack)stack, (ITrait)((ITrait)TraitConst.PURIFYING.get()))) continue;
                    purifyingLevel = TraitHelper.getTraitLevel((ItemStack)stack, (ITrait)((ITrait)TraitConst.PURIFYING.get()));
                }
                if (dodgeCount == 4) {
                    switch (dodgeLevel) {
                        case 1: {
                            if (random.m_188501_() < 0.15f) {
                                TraitEventHandler.addImmunityEffects(serverPlayer, attacker);
                                event.setCanceled(true);
                                break;
                            }
                        }
                        case 2: {
                            if (random.m_188501_() < 0.25f) {
                                TraitEventHandler.addImmunityEffects(serverPlayer, attacker);
                                event.setCanceled(true);
                                break;
                            }
                        }
                        case 3: {
                            if (random.m_188501_() < 0.35f) {
                                TraitEventHandler.addImmunityEffects(serverPlayer, attacker);
                                event.setCanceled(true);
                                break;
                            }
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (emuDodgeCount == 4 && random.m_188501_() < 0.45f) {
                    TraitEventHandler.addImmunityEffects(serverPlayer, attacker);
                    event.setCanceled(true);
                }
                if (purifyingCount == 4 && random.m_188501_() < 0.15f) {
                    for (MobEffectInstance effect : attacked.m_21220_()) {
                        if (effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
                        attacked.m_21195_(effect.m_19544_());
                    }
                }
                for (Object slot : EquipmentSlot.values()) {
                    MobEffect frosted;
                    MobEffect blasting;
                    stack = event.getEntity().m_6844_(slot);
                    if (GearHelper.isGear((ItemStack)stack) && TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.UNSTABLE_MAGIC.get())) && random.m_188501_() < 0.45f) {
                        int effect = random.m_216332_(1, 5);
                        MobEffect mobEffect = MobEffects.f_19605_;
                        switch (effect) {
                            case 1: {
                                mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ModEffectsLocs.MANAREGEN);
                                break;
                            }
                            case 2: {
                                mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ModEffectsLocs.SPELLDAMAGE);
                                break;
                            }
                            case 3: {
                                mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ModEffectsLocs.RECOVERY);
                                break;
                            }
                            case 4: {
                                mobEffect = MobEffects.f_19596_;
                                break;
                            }
                            case 5: {
                                mobEffect = MobEffects.f_19606_;
                            }
                        }
                        if (!attacked.m_21023_(mobEffect)) {
                            attacked.m_147215_(new MobEffectInstance(mobEffect, 40), (Entity)attacked);
                        }
                    }
                    if (GearHelper.isGear((ItemStack)stack) && TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.LUCKY_BREAK.get()))) {
                        float luck = ((Player)attacked).m_36336_();
                        double effectChance = 0.1;
                        effectChance = luck >= 0.0f ? (double)((2.0f + luck) / (20.0f + luck)) : (double)(1.0f / (10.0f - luck));
                        if (attacked.m_217043_().m_188500_() <= effectChance) {
                            int i = attacked.m_217043_().m_216332_(0, LuckyBreak.EFFECTS.size() - 1);
                            attacked.m_7292_(new MobEffectInstance(LuckyBreak.EFFECTS.get(i), 100));
                        }
                    }
                    if (GearHelper.isGear((ItemStack)stack) && TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.RETAILIATING_BLAST.get())) && attacked.m_217043_().m_216332_(1, 4) % 4 == 0 && !((LivingEntity)attacker).m_21023_(blasting = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ModEffectsLocs.BLASTING))) {
                        ((LivingEntity)attacker).m_7292_(new MobEffectInstance(blasting, 80));
                    }
                    if (GearHelper.isGear((ItemStack)stack) && TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.FIRE_REACT.get())) && !attacker.m_5825_()) {
                        attacker.m_20254_(1);
                    }
                    if (!GearHelper.isGear((ItemStack)stack) || !TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.COLD.get())) || !attacker.m_142079_() || ((LivingEntity)attacker).m_21023_(frosted = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ModEffectsLocs.FROSTED))) continue;
                    ((LivingEntity)attacker).m_7292_(new MobEffectInstance(frosted, 20));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(LivingHurtEvent event) {
        double neptunesMight;
        double knightly;
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        if (source == null || !"player".equals(source.f_19326_)) {
            return;
        }
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        ItemStack weapon = player.m_21205_();
        if (!(weapon.m_41720_() instanceof ICoreTool)) {
            return;
        }
        double abyssalSynergy = TraitHelper.getTraitLevel((ItemStack)weapon, TraitConst.ABYSSAL_SYNERGY);
        double height = player.m_20186_();
        if (abyssalSynergy > 0.0 && height < 0.0) {
            double depthDamage = abyssalSynergy / 10.0 / 2.0 * height;
            event.setAmount(Mth.m_14154_((float)((float)depthDamage)) + event.getAmount());
        }
        if ((knightly = (double)TraitHelper.getTraitLevel((ItemStack)weapon, TraitConst.KNIGHTLY)) > 0.0 && attacked.m_21230_() > 0) {
            if (attacked.m_21207_() > 0.0f) {
                int extraDamage = (int)(2.0f * attacked.m_21207_());
                event.setAmount(event.getAmount() + (float)extraDamage);
            } else {
                event.setAmount(event.getAmount() + 2.0f);
            }
        }
        if ((neptunesMight = (double)TraitHelper.getTraitLevel((ItemStack)weapon, TraitConst.NEPTUNES_MIGHT)) > 0.0 && player.m_204029_(FluidTags.f_13131_)) {
            event.setAmount(event.getAmount() * 1.5f);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        if (source == null || !"player".equals(source.f_19326_)) {
            return;
        }
        Entity attacker = source.m_7639_();
        Player player = (Player)attacker;
        if (attacked.m_21023_((MobEffect)SilentCompatEffects.VOLITILE.get())) {
            int amp = attacked.m_21124_((MobEffect)SilentCompatEffects.VOLITILE.get()).m_19564_();
            VolitileExplosion explosion = new VolitileExplosion(player, (Entity)attacked, DamageSource.f_19319_, null, attacked.m_20185_(), attacked.m_20227_(0.0625), attacked.m_20189_(), (float)(2.0 + (double)amp));
            explosion.m_46061_();
            explosion.m_46075_(true);
        }
    }

    @SubscribeEvent
    public static void onKillEntity(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        Entity killer = source.m_7640_();
        if (killer instanceof Player) {
            Player player = (Player)killer;
            int amplifyingCount = 0;
            MobEffect amplified = (MobEffect)SilentCompatEffects.AMPLIFIED.get();
            int devouringCount = 0;
            MobEffect devouring = (MobEffect)SilentCompatEffects.DEVOURING.get();
            int restorationCount = 0;
            MobEffect restoration = (MobEffect)SilentCompatEffects.RESTORATION.get();
            for (EquipmentSlot slot : ARMOR_ONLY) {
                ItemStack stack = player.m_6844_(slot);
                if (GearHelper.isGear((ItemStack)stack) && TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.AMPLIFYING.get()))) {
                    ++amplifyingCount;
                }
                if (GearHelper.isGear((ItemStack)stack) && TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.DEVOURING.get()))) {
                    ++devouringCount;
                }
                if (!GearHelper.isGear((ItemStack)stack) || !TraitHelper.hasTrait((ItemStack)stack, (ITrait)((ITrait)TraitConst.RESTORATION.get()))) continue;
                ++restorationCount;
            }
            if (amplifyingCount == 4 && !player.m_21023_(amplified) && player.m_217043_().m_188501_() < 0.45f) {
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12090_, SoundSource.PLAYERS, 0.6f, 2.6f);
                player.m_7292_(new MobEffectInstance(amplified, 280, 0, false, false, true));
            }
            if (devouringCount == 4) {
                if (player.m_21023_(devouring)) {
                    if (player.m_6103_() + 2.0f < 12.0f) {
                        player.m_7911_(player.m_6103_() + 2.0f);
                    }
                    player.m_21195_(devouring);
                    player.m_7292_(new MobEffectInstance(devouring, 100, 0, false, false, true));
                    player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11859_, SoundSource.PLAYERS, 0.7f, 0.1f);
                } else if (!player.m_21023_(devouring) && player.m_217043_().m_188501_() < 0.45f) {
                    if (player.m_6103_() + 2.0f < 12.0f) {
                        player.m_7911_(player.m_6103_() + 2.0f);
                    }
                    player.m_7292_(new MobEffectInstance(devouring, 100, 0, false, false, true));
                    player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11859_, SoundSource.PLAYERS, 0.7f, 0.1f);
                }
            }
            if (restorationCount == 4 && !player.m_21023_(restoration) && player.m_217043_().m_188501_() < 0.45f) {
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.7f, 1.6f);
                player.m_7292_(new MobEffectInstance(restoration, 140, 0, false, false, true));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)SilentCompatEffects.SCORCH.get()) && entity.m_20070_()) {
            entity.m_21195_((MobEffect)SilentCompatEffects.SCORCH.get());
        }
        if (entity instanceof Player) {
            ItemStack weapon = entity.m_21205_();
            if (!(weapon.m_41720_() instanceof ICoreTool)) {
                return;
            }
            if (TraitHelper.hasTrait((ItemStack)weapon, TraitConst.SUNSPOT) && entity.m_21023_((MobEffect)SilentCompatEffects.RESTORATION.get()) && entity.m_146900_().m_60734_() instanceof BaseFireBlock) {
                int level = TraitHelper.getTraitLevel((ItemStack)weapon, TraitConst.SUNSPOT);
                entity.f_19853_.m_7471_(entity.m_20183_(), true);
                entity.m_5634_(entity.m_21233_() / (float)(4 - level));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, level - 1));
                entity.m_21195_((MobEffect)SilentCompatEffects.RESTORATION.get());
            }
        }
    }

    private static void addImmunityEffects(ServerPlayer player, Entity attacker) {
        if (player != null) {
            Networking.sendToClient(new PacketImmuneParticles(player.m_19879_()), player);
        }
        attacker.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 0.4f, 1.5f);
    }
}

