/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.event;

import com.github.dragoni7.silentcompat.client.particles.ElementalExplosionParticle;
import com.github.dragoni7.silentcompat.client.particles.ImmuneParticle;
import com.github.dragoni7.silentcompat.client.particles.JoltChainParticle;
import com.github.dragoni7.silentcompat.client.particles.JoltParticle;
import com.github.dragoni7.silentcompat.client.particles.VoidParticles;
import com.github.dragoni7.silentcompat.client.projectiles.BlindingProjectileRender;
import com.github.dragoni7.silentcompat.client.projectiles.UmbralBlastProjectileModel;
import com.github.dragoni7.silentcompat.client.projectiles.UmbralBlastProjectileRender;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatEffects;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatEntities;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    public static final ResourceLocation AMPLIFIED = new ResourceLocation("silentcompat", "shaders/post/amplified.json");
    public static final ResourceLocation DEVOURING = new ResourceLocation("silentcompat", "shaders/post/devouring.json");
    public static final ResourceLocation RESTORATION = new ResourceLocation("silentcompat", "shaders/post/restoration.json");

    public static void setUp(IEventBus modBus) {
        modBus.addListener(ClientEventHandler::registerParticles);
        modBus.addListener(ClientEventHandler::registerEntityLayers);
        modBus.addListener(ClientEventHandler::registerEntityRenders);
    }

    private static void registerParticles(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)SilentCompatParticles.JOLT.get(), JoltParticle.Provider::new);
        event.register((ParticleType)SilentCompatParticles.JOLT_CHAIN.get(), JoltChainParticle.Provider::new);
        event.register((ParticleType)SilentCompatParticles.IMMUNE.get(), ImmuneParticle.ImmuneParticleProvider::new);
        event.register((ParticleType)SilentCompatParticles.VOID.get(), VoidParticles.Provider::new);
        event.register((ParticleType)SilentCompatParticles.VOLITILE.get(), ElementalExplosionParticle.Provider::new);
        event.register((ParticleType)SilentCompatParticles.IGNITION.get(), ElementalExplosionParticle.Provider::new);
        event.register((ParticleType)SilentCompatParticles.RESTORATION.get(), FlameParticle.Provider::new);
    }

    private static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(UmbralBlastProjectileModel.LAYER_LOCATION, UmbralBlastProjectileModel::createBodyLayer);
    }

    private static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SilentCompatEntities.BLINDING_PROJECTILE.get(), BlindingProjectileRender::new);
        event.registerEntityRenderer((EntityType)SilentCompatEntities.UMBRAL_BLAST_PROJECTILE.get(), UmbralBlastProjectileRender::new);
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() == Minecraft.m_91087_().f_91074_) {
            GameRenderer renderer = Minecraft.m_91087_().f_91063_;
            MobEffectInstance amplified = event.getEntity().m_21124_((MobEffect)SilentCompatEffects.AMPLIFIED.get());
            MobEffectInstance devouring = event.getEntity().m_21124_((MobEffect)SilentCompatEffects.DEVOURING.get());
            MobEffectInstance restoration = event.getEntity().m_21124_((MobEffect)SilentCompatEffects.RESTORATION.get());
            if (amplified != null && renderer.m_109149_() == null) {
                renderer.m_109128_(AMPLIFIED);
            }
            if (amplified == null && renderer.m_109149_() != null && renderer.m_109149_().m_110022_() != null && AMPLIFIED.toString().equals(renderer.m_109149_().m_110022_())) {
                renderer.m_109086_();
            }
            if (devouring != null && renderer.m_109149_() == null) {
                renderer.m_109128_(DEVOURING);
            }
            if (devouring == null && renderer.m_109149_() != null && renderer.m_109149_().m_110022_() != null && DEVOURING.toString().equals(renderer.m_109149_().m_110022_())) {
                renderer.m_109086_();
            }
            if (restoration != null && renderer.m_109149_() == null) {
                renderer.m_109128_(RESTORATION);
            }
            if (restoration == null && renderer.m_109149_() != null && renderer.m_109149_().m_110022_() != null && RESTORATION.toString().equals(renderer.m_109149_().m_110022_())) {
                renderer.m_109086_();
            }
        }
    }
}

