/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.silentcompat.core.registry;

import com.github.dragoni7.silentcompat.SilentCompat;
import com.github.dragoni7.silentcompat.core.registry.MaterialRegistry;
import com.github.dragoni7.silentcompat.core.registry.SilentCompatItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;

public class MaterialSet {
    public final String name;
    public final TagKey<Item> ingotTag;
    public final TagKey<Item> nuggetTag;
    public final TagKey<Item> blockItemTag;
    public final TagKey<Block> blockTag;
    public final RegistryObject<Item> ingot;
    public final RegistryObject<Item> nugget;
    public final RegistryObject<Item> blockItem;
    public final RegistryObject<Block> block;

    public MaterialSet(String name, MaterialColor color) {
        this.name = name;
        this.ingotTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "ingots/" + name));
        this.nuggetTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "nuggets/" + name));
        this.blockItemTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "storage_blocks/" + name));
        this.blockTag = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "storage_blocks/" + name));
        this.block = MaterialRegistry.BLOCKS.register(name + "_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_155949_(color)));
        this.ingot = SilentCompatItems.ITEMS.register(name + "_ingot", () -> new Item(new Item.Properties().m_41491_(SilentCompat.SilentCompatTab)));
        this.nugget = SilentCompatItems.ITEMS.register(name + "_nugget", () -> new Item(new Item.Properties().m_41491_(SilentCompat.SilentCompatTab)));
        this.blockItem = SilentCompatItems.ITEMS.register(name + "_block", () -> new BlockItem((Block)this.block.get(), new Item.Properties().m_41491_(SilentCompat.SilentCompatTab)));
    }
}

