/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.recipe;

import java.util.List;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import org.moddingx.libx.base.decoration.DecorationContext;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;
import org.moddingx.libx.datagen.provider.recipe.StoneCuttingExtension;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedDoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedFenceBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedFenceGateBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedPressurePlate;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedSign;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedSlabBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedStairBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedStoneButton;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedTrapdoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedWallBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedWoodButton;
import org.moddingx.libx.impl.datagen.recipe.ObjectCraftingBuilder;

public class DecorationRecipes {
    public static void defaultRecipes(Block block, RecipeExtension ext) {
        if (block instanceof DecoratedSlabBlock) {
            DecoratedSlabBlock decorated = (DecoratedSlabBlock)block;
            if (ext instanceof StoneCuttingExtension) {
                StoneCuttingExtension cut = (StoneCuttingExtension)ext;
                if (decorated.parent.getContext().baseMaterial() == DecorationContext.BaseMaterial.STONE) {
                    DecorationRecipes.stoneCutting(ext, Ingredient.m_43929_((ItemLike[])new ItemLike[]{decorated.parent}), (ItemLike)decorated, 2);
                }
            }
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{decorated, 6, "###", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedStairBlock) {
            DecoratedStairBlock decorated = (DecoratedStairBlock)block;
            if (ext instanceof StoneCuttingExtension) {
                StoneCuttingExtension cut = (StoneCuttingExtension)ext;
                if (decorated.parent.getContext().baseMaterial() == DecorationContext.BaseMaterial.STONE) {
                    DecorationRecipes.stoneCutting(ext, Ingredient.m_43929_((ItemLike[])new ItemLike[]{decorated.parent}), (ItemLike)decorated, 1);
                }
            }
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{decorated, 4, "#  ", "## ", "###", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedWallBlock) {
            DecoratedWallBlock decorated = (DecoratedWallBlock)block;
            if (ext instanceof StoneCuttingExtension) {
                StoneCuttingExtension cut = (StoneCuttingExtension)ext;
                if (decorated.parent.getContext().baseMaterial() == DecorationContext.BaseMaterial.STONE) {
                    DecorationRecipes.stoneCutting(ext, Ingredient.m_43929_((ItemLike[])new ItemLike[]{decorated.parent}), (ItemLike)decorated, 1);
                }
            }
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{decorated, 6, "###", "###", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedFenceBlock) {
            DecoratedFenceBlock decorated = (DecoratedFenceBlock)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{decorated, 3, "#s#", "#s#", Character.valueOf('#'), decorated.parent, Character.valueOf('s'), Tags.Items.RODS_WOODEN});
        } else if (block instanceof DecoratedFenceGateBlock) {
            DecoratedFenceGateBlock decorated = (DecoratedFenceGateBlock)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{decorated, "s#s", "s#s", Character.valueOf('#'), decorated.parent, Character.valueOf('s'), Tags.Items.RODS_WOODEN});
        } else if (block instanceof DecoratedDoorBlock) {
            DecoratedDoorBlock decorated = (DecoratedDoorBlock)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{decorated, 3, "##", "##", "##", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedTrapdoorBlock) {
            DecoratedTrapdoorBlock decorated = (DecoratedTrapdoorBlock)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{decorated, 2, "###", "###", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedWoodButton) {
            DecoratedWoodButton decorated = (DecoratedWoodButton)block;
            ObjectCraftingBuilder.buildShapeless(ext, new Object[]{decorated, decorated.parent});
        } else if (block instanceof DecoratedStoneButton) {
            DecoratedStoneButton decorated = (DecoratedStoneButton)block;
            ObjectCraftingBuilder.buildShapeless(ext, new Object[]{decorated, decorated.parent});
        } else if (block instanceof DecoratedPressurePlate) {
            DecoratedPressurePlate decorated = (DecoratedPressurePlate)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{decorated, "##", Character.valueOf('#'), decorated.parent});
        } else if (block instanceof DecoratedSign.Standing) {
            DecoratedSign.Standing decorated = (DecoratedSign.Standing)block;
            ObjectCraftingBuilder.buildShaped(ext, new Object[]{decorated, 3, "###", "###", " s ", Character.valueOf('#'), decorated.parent, Character.valueOf('s'), Tags.Items.RODS_WOODEN});
        }
    }

    private static void stoneCutting(RecipeExtension ext, Ingredient input, ItemLike output, int amount) {
        SingleItemRecipeBuilder builder = SingleItemRecipeBuilder.m_126316_((Ingredient)input, (ItemLike)output, (int)amount);
        List<CriterionTriggerInstance> criteria = ext.criteria(input);
        for (int i = 0; i < criteria.size(); ++i) {
            builder.m_126132_("has_item" + i, criteria.get(i));
        }
        builder.m_126140_(ext.consumer(), ext.provider().loc(output, "stonecutting"));
    }
}

