/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.itshallnottick.integration;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.event.ClaimedChunkEvent;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.wuffs.itshallnottick.client.ClaimedChunksClient;
import dev.wuffs.itshallnottick.network.PacketHandler;
import dev.wuffs.itshallnottick.network.SendClaimedChunksPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class FTBChunks {
    public static void setup() {
        ClaimedChunkEvent.AFTER_CLAIM.register(FTBChunks::onClaimChange);
        ClaimedChunkEvent.AFTER_UNCLAIM.register(FTBChunks::onClaimChange);
        TeamEvent.PLAYER_LOGGED_IN.register(FTBChunks::playerLogged);
    }

    private static void playerLogged(PlayerLoggedInAfterTeamEvent event) {
        PacketHandler.sendToClient(new SendClaimedChunksPacket(FTBChunksAPI.getManager().getAllClaimedChunks().stream().map(ClaimedChunk::getPos).map(dev.wuffs.itshallnottick.network.ChunkDimPos::fromLatsPos).toList()), event.getPlayer());
    }

    private static void onClaimChange(CommandSourceStack commandSourceStack, ClaimedChunk claimedChunk) {
        PacketHandler.HANDLER.send(PacketDistributor.PLAYER.with(() -> {
            try {
                return commandSourceStack.m_81375_();
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }), (Object)new SendClaimedChunksPacket(FTBChunksAPI.getManager().getAllClaimedChunks().stream().map(ClaimedChunk::getPos).map(dev.wuffs.itshallnottick.network.ChunkDimPos::fromLatsPos).toList()));
    }

    public static boolean isInClaimedChunk(Level level, BlockPos blockPos) {
        if (level.f_46443_) {
            return ClaimedChunksClient.getInstance().isChunkClaimed(new dev.wuffs.itshallnottick.network.ChunkDimPos(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4, (ResourceKey<Level>)level.m_46472_()));
        }
        if (!FTBChunksAPI.isManagerLoaded()) {
            return false;
        }
        ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(level, blockPos));
        return chunk != null;
    }
}

