/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.itshallnottick;

import dev.wuffs.itshallnottick.Config;
import dev.wuffs.itshallnottick.ItShallNotTick;
import dev.wuffs.itshallnottick.integration.FTBChunks;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    public static Object2BooleanMap<EntityType<?>> isIgnored = new Object2BooleanOpenHashMap();

    public static boolean isInClaimedChunk(Level level, BlockPos blockPos) {
        if (ItShallNotTick.isFTBChunksLoaded) {
            return FTBChunks.isInClaimedChunk(level, blockPos);
        }
        return false;
    }

    public static boolean enoughPlayers(Level level) {
        if (level.f_46443_) {
            return false;
        }
        MinecraftServer server = level.m_7654_();
        if (server != null) {
            return server.m_6846_().m_11309_() >= (Integer)Config.minPlayers.get();
        }
        return false;
    }

    public static boolean isNearPlayer(Level level, BlockPos blockPos, int maxHeight, int maxDistanceSquare) {
        return Utils.isNearPlayerInternal(level, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), maxHeight, maxDistanceSquare, false);
    }

    private static boolean isNearPlayerInternal(Level world, double posx, double posy, double posz, int maxHeight, int maxDistanceSquare, boolean allowNullPlayers) {
        List closest = world.m_6907_();
        for (Player player : closest) {
            double z;
            double x;
            boolean nearPlayer;
            if (player == null) {
                return allowNullPlayers;
            }
            if (!(Math.abs(player.m_20186_() - posy) < (double)maxHeight) || !(nearPlayer = (x = player.m_20185_() - posx) * x + (z = player.m_20189_() - posz) * z < (double)maxDistanceSquare)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity player, Entity entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.m_20186_() - entity.m_20186_()) < (double)maxHeight) {
            double z;
            double x = player.m_20185_() - entity.m_20185_();
            return x * x + (z = player.m_20189_() - entity.m_20189_()) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(BlockPos player, Vec3 entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs((double)player.m_123342_() - entity.f_82480_) < (double)maxHeight) {
            double z;
            double x = (double)player.m_123341_() - entity.f_82479_;
            return x * x + (z = (double)player.m_123343_() - entity.f_82481_) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity player, double cameraX, double cameraY, double cameraZ, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.m_20186_() - cameraY) < (double)maxHeight) {
            double z;
            double x = player.m_20185_() - cameraX;
            return x * x + (z = player.m_20189_() - cameraZ) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isIgnoredEntity(Entity entity) {
        if (((List)Config.entityIgnoreList.get()).isEmpty()) {
            return false;
        }
        EntityType entityType = entity.m_6095_();
        return isIgnored.computeIfAbsent((Object)entityType, et -> {
            String entityRegName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).toString();
            if (entityRegName == null) {
                return false;
            }
            boolean ignored = false;
            if (!Config.entityResources.isEmpty()) {
                ignored = Config.entityResources.contains(entityRegName);
            }
            if (!Config.entityWildcards.isEmpty() && !ignored) {
                ignored = Config.entityWildcards.stream().anyMatch(e -> entityRegName.toString().startsWith((String)e));
            }
            if (!Config.entityTagKeys.isEmpty() && !ignored) {
                ignored = Config.entityTagKeys.stream().anyMatch(arg_0 -> ((EntityType)entityType).m_204039_(arg_0));
            }
            return ignored;
        });
    }
}

