/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.blockentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.containers.slots.SlotInput;
import net.creeperhost.polylib.containers.slots.SlotOutput;
import net.creeperhost.polylib.inventory.PolyItemInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityInventory
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public Optional<PolyItemInventory> inventoryOptional = Optional.empty();
    private final List<Slot> slots = new ArrayList<Slot>();
    private SimpleContainerData containerData = new SimpleContainerData(0);

    public BlockEntityInventory(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void setContainerDataSize(int value) {
        this.containerData = new SimpleContainerData(value);
    }

    public SimpleContainerData getContainerData() {
        return this.containerData;
    }

    public void setContainerDataValue(int i, int value) {
        if (this.containerData == null) {
            PolyLib.LOGGER.error("failed to set container data due to containerData being null");
            return;
        }
        if (i > this.containerData.m_6499_()) {
            PolyLib.LOGGER.error("failed to set container data due to containerData size being lower then " + i);
            return;
        }
        this.containerData.m_8050_(i, value);
    }

    public void setContainerDataValue(int i, Supplier<Integer> value) {
        if (this.containerData == null) {
            PolyLib.LOGGER.error("failed to set container data due to containerData being null");
            return;
        }
        if (this.containerData.m_6499_() == 0 || i > this.containerData.m_6499_()) {
            PolyLib.LOGGER.error("failed to set container data due to containerData size being lower then " + i);
            this.setContainerDataSize(i + 1);
        }
        try {
            this.containerData.m_8050_(i, value.get().intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInventory(@javax.annotation.Nullable PolyItemInventory polyInventory) {
        this.inventoryOptional = Optional.ofNullable(polyInventory);
    }

    public Optional<PolyItemInventory> getInventoryOptional() {
        return this.inventoryOptional;
    }

    public void addSlot(Slot slot) {
        this.slots.add(slot);
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public int m_6643_() {
        return this.getInventoryOptional().isPresent() ? this.getInventoryOptional().get().m_6643_() : 0;
    }

    public boolean m_7983_() {
        return this.getInventoryOptional().isPresent() && this.getInventoryOptional().get().m_7983_();
    }

    public ItemStack m_8020_(int i) {
        return this.getInventoryOptional().isPresent() ? this.getInventoryOptional().get().m_8020_(i) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int i, int j) {
        return this.getInventoryOptional().isPresent() ? this.getInventoryOptional().get().m_7407_(i, j) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int i) {
        return this.getInventoryOptional().isPresent() ? this.getInventoryOptional().get().m_8016_(i) : ItemStack.f_41583_;
    }

    public void m_6836_(int i, @NotNull ItemStack itemStack) {
        this.getInventoryOptional().ifPresent(polyInventory -> polyInventory.m_6836_(i, itemStack));
    }

    public boolean m_6542_(@NotNull Player player) {
        return this.getInventoryOptional().isPresent() && this.getInventoryOptional().get().m_6542_(player);
    }

    public void m_6211_() {
        this.getInventoryOptional().ifPresent(PolyItemInventory::m_6211_);
    }

    public int m_6893_() {
        return this.inventoryOptional.isPresent() ? this.inventoryOptional.get().m_6893_() : 64;
    }

    public boolean m_7013_(int i, @NotNull ItemStack itemStack) {
        if (!this.getSlots().isEmpty() && this.getSlots().size() > i) {
            return !(this.getSlots().get(i) instanceof SlotOutput);
        }
        return true;
    }

    public int[] m_7071_(@NotNull Direction direction) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int i, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        if (!this.getSlots().isEmpty() && this.getSlots().size() > i) {
            if (this.getSlots().get(i) instanceof SlotOutput) {
                return false;
            }
            ItemStack stackInSlot = this.m_8020_(i);
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.m_6893_())) {
                return false;
            }
            return this.getSlots().get(i).m_5857_(itemStack);
        }
        return true;
    }

    public boolean m_7157_(int i, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        if (!this.getSlots().isEmpty() && this.getSlots().size() > i) {
            return !(this.getSlots().get(i) instanceof SlotInput);
        }
        return true;
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        this.getInventoryOptional().ifPresent(polyInventory -> compoundTag.m_128391_(polyInventory.serializeNBT()));
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.getInventoryOptional().ifPresent(polyInventory -> polyInventory.deserializeNBT(compoundTag));
    }
}

