/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.blocks.IColorable;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class ColoredBlock
extends XyBlock
implements IColorable {
    public static final BooleanProperty Spawnable = BooleanProperty.m_61465_((String)"allow_spawns");
    protected final int _color;

    public ColoredBlock(CustomColors color) {
        this(color.Color, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155949_(ColorUtils.getMaterialColor(color)).m_60999_().m_155954_(Blocks.f_50069_.m_155943_()));
    }

    public ColoredBlock(CustomColors color, BlockBehaviour.Properties properties) {
        this(color.Color, properties.m_155949_(ColorUtils.getMaterialColor(color)));
    }

    public static Supplier<Block> supplier(CustomColors color) {
        return () -> new ColoredBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_60918_(SoundType.f_154654_).m_60999_().m_60978_(Blocks.f_50069_.m_155943_()));
    }

    public static Supplier<Block> supplier() {
        return () -> new ColoredBlock(-1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_60918_(SoundType.f_154654_).m_60999_().m_60978_(Blocks.f_50069_.m_155943_()));
    }

    public ColoredBlock(int color, BlockBehaviour.Properties properties) {
        super(properties);
        this._color = color;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)Spawnable, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        InteractionResult interactionResult = ColoredBlock.tryToAllowSpawns(state, level, pos, player, interactionHand);
        return interactionResult != InteractionResult.PASS ? interactionResult : super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    public static InteractionResult tryToAllowSpawns(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (stack.m_41720_() == Items.f_42784_ && !((Boolean)state.m_61143_((Property)Spawnable)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, pos, stack);
            }
            BlockState spawnableBlockState = (BlockState)state.m_61124_((Property)Spawnable, (Comparable)Boolean.valueOf(true));
            stack.m_41774_(player.m_7500_() ? 0 : 1);
            level.m_7731_(pos, spawnableBlockState, 11);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)spawnableBlockState));
            level.m_5898_(player, 3003, pos, 0);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{Spawnable});
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)Spawnable, (Comparable)Boolean.valueOf(false));
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return entityType == EntityType.f_20532_ || (Boolean)state.m_61143_((Property)Spawnable) != false;
    }

    @Override
    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return this.getColorOfItem(ItemStack.f_41583_, index);
    }

    @Override
    public int getColorOfItem(ItemStack stack, int index) {
        return index != 0 ? -1 : this._color;
    }
}

