/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.client.render.texture;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface ConnectedTextureHandler {
    public static ConnectedTextureHandler isSameBlock() {
        return ConnectedTextureHandler.testingState((localState, neighborState) -> neighborState.m_60713_(localState.m_60734_()));
    }

    public static ConnectedTextureHandler hasTag(TagKey<Block> tag) {
        return ConnectedTextureHandler.testingState((localState, neighborState) -> neighborState.m_204336_(tag));
    }

    public static ConnectedTextureHandler testingState(final BiPredicate<BlockState, BlockState> predicate) {
        return new ConnectedTextureHandler(){

            private boolean hasTagUncovered(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction face) {
                BlockState neighborState = level.m_8055_(pos);
                return predicate.test(state, neighborState) && Block.m_152444_((BlockState)neighborState, (BlockGetter)level, (BlockPos)pos, (Direction)face, (BlockPos)pos.m_121945_(face));
            }

            @Override
            public boolean shouldConnectTexture(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction face, Direction side) {
                return this.hasTagUncovered(level, pos.m_121945_(side), state, face);
            }

            @Override
            public boolean shouldConnectTexture(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction face, Direction corner1, Direction corner2) {
                return this.hasTagUncovered(level, pos.m_121945_(corner1).m_121945_(corner2), state, face);
            }
        };
    }

    public static ConnectedTextureHandler fromBlock() {
        return new ConnectedTextureHandler(){

            @Override
            public boolean shouldConnectTexture(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction face, Direction side) {
                Block block = state.m_60734_();
                if (block instanceof ConnectedTextureHandler) {
                    ConnectedTextureHandler cth = (ConnectedTextureHandler)block;
                    return cth.shouldConnectTexture(level, pos, state, face, side);
                }
                throw new IllegalStateException("The block does not provide a connected texture handler.");
            }

            @Override
            public boolean shouldConnectTexture(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction face, Direction corner1, Direction corner2) {
                Block block = state.m_60734_();
                if (block instanceof ConnectedTextureHandler) {
                    ConnectedTextureHandler cth = (ConnectedTextureHandler)block;
                    return cth.shouldConnectTexture(level, pos, state, face, corner1, corner2);
                }
                throw new IllegalStateException("The block does not provide a connected texture handler.");
            }
        };
    }

    public boolean shouldConnectTexture(BlockAndTintGetter var1, BlockPos var2, BlockState var3, Direction var4, Direction var5);

    public boolean shouldConnectTexture(BlockAndTintGetter var1, BlockPos var2, BlockState var3, Direction var4, Direction var5, Direction var6);
}

