/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.client.render.texture;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class CloudFX
extends TextureAtlasSprite {
    float[] red;
    float[] green;
    float[] blue;
    float[] alpha;
    byte alphaByte;

    protected CloudFX(TextureAtlas atlas, TextureAtlasSprite.Info info, int mapMax, int width, int height, int x, int y, NativeImage nativeImage) {
        super(atlas, info, mapMax, width, height, x, y, nativeImage);
        int squaredSize = info.m_118434_() * info.m_118437_();
        this.red = new float[squaredSize];
        this.green = new float[squaredSize];
        this.blue = new float[squaredSize];
        this.alpha = new float[squaredSize];
        this.alphaByte = nativeImage.m_85087_(0, 0);
    }

    protected void m_118375_(int jim, int bob, NativeImage @NotNull [] nativeImage) {
        this.generateImage(jim, bob, nativeImage[0]);
        for (int i = 1; i < nativeImage.length; ++i) {
            NativeImage currentImage = nativeImage[i];
            for (int x = 0; x < currentImage.m_84982_(); ++x) {
                for (int y = 0; y < currentImage.m_85084_(); ++y) {
                    currentImage.m_84988_(x, y, nativeImage[0].m_84985_(x << i, y << i));
                }
            }
        }
        super.m_118375_(jim, bob, nativeImage);
    }

    public void generateImage(int jim, int bob, NativeImage image) {
        int tileSizeBase = image.m_84982_();
        this.evolveNoise(tileSizeBase, tileSizeBase - 1);
        float[] greenTemp = this.green;
        this.green = this.red;
        this.red = greenTemp;
        for (int x = 0; x < tileSizeBase; ++x) {
            for (int y = 0; y < tileSizeBase; ++y) {
                float intensity = Mth.m_14036_((float)(this.red[x + tileSizeBase * y] * 2.0f), (float)0.01f, (float)1.0f);
                int rgba = 65793 * ((int)(intensity * 255.0f) & 0xFF) | (this.alphaByte & 0xFF) << 24;
                image.m_84988_(x + jim, y + bob, rgba);
            }
        }
    }

    private void evolveNoise(int tileSizeBase, int tileSizeMask) {
        for (int i = 0; i < tileSizeBase; ++i) {
            for (int j = 0; j < tileSizeBase; ++j) {
                float modifier = -0.02f;
                int rotation1 = (int)(Math.sin((float)j * 4.7123895f) * 1.0);
                int rotation2 = (int)(Math.sin((float)i * 4.7123895f) * 1.0);
                for (int k = i - 1; k <= i + 1; ++k) {
                    for (int l = j - 1; l <= j + 1; ++l) {
                        modifier += this.red[(k + rotation1 & tileSizeMask) + (l + rotation2 & tileSizeMask) * tileSizeBase];
                    }
                }
                int iTileSizeMask = i & tileSizeMask;
                int jTileSizeMask = j & tileSizeMask;
                int i1TileSizeMask = i + 1 & tileSizeMask;
                int j1TileSizeMask = j + 1 & tileSizeMask;
                int coord = i + j * tileSizeBase;
                this.green[coord] = modifier * 0.1f + (this.blue[iTileSizeMask + jTileSizeMask * tileSizeBase] + this.blue[i1TileSizeMask + jTileSizeMask * tileSizeBase] + this.blue[i1TileSizeMask + j1TileSizeMask * tileSizeBase] + this.blue[iTileSizeMask + j1TileSizeMask * tileSizeBase]) * 0.2f;
                int n = coord;
                this.blue[n] = this.blue[n] + this.alpha[coord] * 0.01f;
                if (this.blue[coord] < 0.0f) {
                    this.blue[coord] = 0.0f;
                }
                int n2 = coord;
                this.alpha[n2] = this.alpha[n2] - 0.062f;
                if (Math.random() >= 0.0062) continue;
                this.alpha[coord] = 1.33f;
            }
        }
    }
}

