/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model;

import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.ClientFuelRodsLayout;
import it.zerono.mods.zerocore.lib.client.model.data.NamedModelProperty;
import java.util.Objects;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public final class ReactorFuelRodModelData {
    public static final ModelProperty<Short> REACTANTS_MODEL_KEY = new NamedModelProperty("REACTANTS_MODEL_KEY", Objects::nonNull);
    public static final ModelProperty<Boolean> VERTICAL = new NamedModelProperty("VERTICAL", Objects::nonNull);
    public static final ModelProperty<Boolean> OCCLUDED = new NamedModelProperty("OCCLUDED", Objects::nonNull);
    public static final ModelProperty<Byte> FUEL_LEVEL = new NamedModelProperty("FUEL_LEVEL", Objects::nonNull);
    public static final ModelProperty<Byte> WASTE_LEVEL = new NamedModelProperty("WASTE_LEVEL", Objects::nonNull);
    private static final Short2ObjectMap<ModelData> s_cache = new Short2ObjectArrayMap(512);

    public static ModelData from(ClientFuelRodsLayout.FuelData fuelData, boolean rodIsOccluded) {
        return (ModelData)s_cache.computeIfAbsent(ReactorFuelRodModelData.createKey(fuelData, rodIsOccluded), k -> ModelData.builder().with(REACTANTS_MODEL_KEY, (Object)((short)(k & 0xFF))).with(VERTICAL, (Object)fuelData.isVertical()).with(OCCLUDED, (Object)rodIsOccluded).with(FUEL_LEVEL, (Object)fuelData.getFuelLevel()).with(WASTE_LEVEL, (Object)fuelData.getWasteLevel()).build());
    }

    public static short getModelKey(ModelData data) {
        Short v = (Short)data.get(REACTANTS_MODEL_KEY);
        return null != v ? v : (short)0;
    }

    public static boolean isVertical(ModelData data) {
        Boolean v = (Boolean)data.get(VERTICAL);
        return null != v && v != false;
    }

    public static boolean isOccluded(ModelData data) {
        Boolean v = (Boolean)data.get(OCCLUDED);
        return null != v && v != false;
    }

    public static byte getFuelLevel(ModelData data) {
        Byte v = (Byte)data.get(FUEL_LEVEL);
        return null != v ? v : (byte)0;
    }

    public static byte getWasteLevel(ModelData data) {
        Byte v = (Byte)data.get(WASTE_LEVEL);
        return null != v ? v : (byte)0;
    }

    private ReactorFuelRodModelData() {
    }

    private static short createKey(ClientFuelRodsLayout.FuelData fuelData, boolean rodIsOccluded) {
        return (short)((fuelData.isVertical() ? 32768 : 0) | (rodIsOccluded ? 16384 : 0) | fuelData.getFuelLevel() << 4 | fuelData.getWasteLevel() & 0xF);
    }
}

