/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.salvage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.SgItems;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.FragmentItem;

public class SalvagingRecipe
implements Recipe<Container> {
    private final ResourceLocation recipeId;
    protected Ingredient ingredient;
    private final List<ItemStack> results = new ArrayList<ItemStack>();

    public SalvagingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<ItemStack> getPossibleResults(Container inv) {
        return new ArrayList<ItemStack>(this.results);
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.ingredient.test(inv.m_8020_(0));
    }

    @Deprecated
    public ItemStack m_5874_(Container inv) {
        return this.m_8043_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Deprecated
    public ItemStack m_8043_() {
        return !this.results.isEmpty() ? this.results.get(0) : ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SgRecipes.SALVAGING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)SgRecipes.SALVAGING_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static List<ItemStack> salvage(PartData part) {
        if (part.get() instanceof CompoundPart && part.getItem().m_41720_() instanceof CompoundPartItem) {
            int craftedCount = ((CompoundPartItem)part.getItem().m_41720_()).getCraftedCount(part.getItem());
            if (craftedCount < 1) {
                SilentGear.LOGGER.warn("Compound part's crafted count is less than 1? {}", (Object)part.getItem());
                return Collections.singletonList(part.getItem());
            }
            MaterialList materials = part.getMaterials();
            LinkedHashMap<IMaterialInstance, Integer> fragments = new LinkedHashMap<IMaterialInstance, Integer>();
            for (IMaterialInstance material : materials) {
                int fragmentCount = 8 / craftedCount;
                fragments.merge(material.onSalvage(), fragmentCount, Integer::sum);
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            for (Map.Entry entry : fragments.entrySet()) {
                IMaterialInstance material = (IMaterialInstance)entry.getKey();
                int count = (Integer)entry.getValue();
                int fulls = count / 8;
                int frags = count % 8;
                if (fulls > 0) {
                    ret.add(material.getItem());
                }
                if (frags <= 0) continue;
                ret.add(((FragmentItem)((Object)SgItems.FRAGMENT.get())).create(material, frags));
            }
            return ret;
        }
        return Collections.singletonList(part.getItem());
    }

    public static class Serializer
    implements RecipeSerializer<SalvagingRecipe> {
        public SalvagingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            SalvagingRecipe recipe = new SalvagingRecipe(recipeId);
            recipe.ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            JsonArray resultsArray = json.getAsJsonArray("results");
            for (JsonElement element : resultsArray) {
                if (element.isJsonObject()) {
                    Item item = GsonHelper.m_13909_((JsonObject)element.getAsJsonObject(), (String)"item");
                    int count = GsonHelper.m_13824_((JsonObject)element.getAsJsonObject(), (String)"count", (int)1);
                    recipe.results.add(new ItemStack((ItemLike)item, count));
                    continue;
                }
                recipe.results.add(new ItemStack((ItemLike)GsonHelper.m_13874_((JsonElement)element, (String)"item")));
            }
            return recipe;
        }

        @Nullable
        public SalvagingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            SalvagingRecipe recipe = new SalvagingRecipe(recipeId);
            recipe.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int resultCount = buffer.readByte();
            for (int i = 0; i < resultCount; ++i) {
                recipe.results.add(buffer.m_130267_());
            }
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, SalvagingRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.writeByte(recipe.results.size());
            recipe.results.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
        }
    }
}

