/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.stack;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public class StackUpgradeConfig {
    private static final String REGISTRY_NAME_MATCHER = "([a-z1-9_.-]+:[a-z1-9_/.-]+)";
    private final ForgeConfigSpec.ConfigValue<List<String>> nonStackableItemsList;
    @Nullable
    private Set<Item> nonStackableItems = null;

    public StackUpgradeConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Stack Upgrade Settings").push("stackUpgrade");
        this.nonStackableItemsList = builder.comment("List of items that are not supposed to stack in storage even when stack upgrade is inserted. Item registry names are expected here.").define("nonStackableItems", this::getDefaultNonStackableList, itemNames -> {
            List registryNames = (List)itemNames;
            return registryNames != null && registryNames.stream().allMatch(itemName -> itemName.matches(REGISTRY_NAME_MATCHER));
        });
        builder.pop();
    }

    private List<String> getDefaultNonStackableList() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(RegistryHelper.getItemKey(Items.f_151058_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42265_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42266_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42267_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42268_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42269_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42270_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42271_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42272_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42273_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42274_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42275_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42224_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42225_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42226_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42227_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42228_).toString());
        ret.add(RegistryHelper.getItemKey(Items.f_42229_).toString());
        return ret;
    }

    public boolean canStackItem(Item item) {
        if (!Config.COMMON_SPEC.isLoaded()) {
            return true;
        }
        if (this.nonStackableItems == null) {
            this.nonStackableItems = new HashSet<Item>();
            ((List)this.nonStackableItemsList.get()).forEach(name -> {
                ResourceLocation registryName = new ResourceLocation(name);
                if (ForgeRegistries.ITEMS.containsKey(registryName)) {
                    this.nonStackableItems.add((Item)ForgeRegistries.ITEMS.getValue(registryName));
                } else {
                    SophisticatedCore.LOGGER.error("Item {} is set to not be affected by stack upgrade in config, but it does not exist in item registry", name);
                }
            });
        }
        return !this.nonStackableItems.contains(item);
    }

    public void clearNonStackableItems() {
        this.nonStackableItems = null;
    }
}

