/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.SoundStopNotificationMessage;

public class StorageSoundHandler {
    private static final int SOUND_STOP_CHECK_INTERVAL = 10;
    private static final Map<UUID, SoundInstance> storageSounds = new ConcurrentHashMap<UUID, SoundInstance>();
    private static long lastPlaybackChecked = 0L;

    private StorageSoundHandler() {
    }

    public static void playStorageSound(UUID storageUuid, SoundInstance sound) {
        StorageSoundHandler.stopStorageSound(storageUuid);
        storageSounds.put(storageUuid, sound);
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
    }

    public static void stopStorageSound(UUID storageUuid) {
        if (storageSounds.containsKey(storageUuid)) {
            Minecraft.m_91087_().m_91106_().m_120399_(storageSounds.remove(storageUuid));
            SophisticatedCore.PACKET_HANDLER.sendToServer(new SoundStopNotificationMessage(storageUuid));
        }
    }

    public static void tick(TickEvent.LevelTickEvent event) {
        if (!storageSounds.isEmpty() && lastPlaybackChecked < event.level.m_46467_() - 10L) {
            lastPlaybackChecked = event.level.m_46467_();
            storageSounds.entrySet().removeIf(entry -> {
                if (!Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)entry.getValue())) {
                    SophisticatedCore.PACKET_HANDLER.sendToServer(new SoundStopNotificationMessage((UUID)entry.getKey()));
                    return true;
                }
                return false;
            });
        }
    }

    public static void playStorageSound(SoundEvent soundEvent, UUID storageUuid, BlockPos pos) {
        StorageSoundHandler.playStorageSound(storageUuid, (SoundInstance)SimpleSoundInstance.m_119747_((SoundEvent)soundEvent, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    public static void playStorageSound(SoundEvent soundEvent, UUID storageUuid, int entityId) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(entityId);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        StorageSoundHandler.playStorageSound(storageUuid, (SoundInstance)new EntityBoundSoundInstance(soundEvent, SoundSource.RECORDS, 2.0f, 1.0f, entity, level.f_46441_.m_188505_()));
    }

    public static void onWorldUnload(LevelEvent.Unload evt) {
        storageSounds.clear();
        lastPlaybackChecked = 0L;
    }
}

