/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;

public class InsertIntoHeldStorageMessage {
    private final int slotIndex;

    public InsertIntoHeldStorageMessage(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public static void encode(InsertIntoHeldStorageMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.slotIndex);
    }

    public static InsertIntoHeldStorageMessage decode(FriendlyByteBuf packetBuffer) {
        return new InsertIntoHeldStorageMessage(packetBuffer.readInt());
    }

    static void onMessage(InsertIntoHeldStorageMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> InsertIntoHeldStorageMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, InsertIntoHeldStorageMessage msg) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu containerMenu = player.f_36096_;
        ItemStack storageStack = containerMenu.m_142621_();
        Item item = storageStack.m_41720_();
        if (item instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)item;
            ItemStack stackToStash = containerMenu.m_38853_(msg.slotIndex).m_7993_();
            containerMenu.m_38853_(msg.slotIndex).m_5852_(stashStorageItem.stash(storageStack, stackToStash));
        }
    }
}

