/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.panorama;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ExternalTexturePanoramaRenderer
extends GuiComponent {
    private ExternalTextureResourceLocation overlay_texture;
    private float time;
    private String name = null;
    public String dir;
    private boolean prepared = false;
    private List<ExternalTextureResourceLocation> pano = new ArrayList<ExternalTextureResourceLocation>();
    private float speed = 1.0f;
    private double fov = 85.0;
    private float angle = 25.0f;
    private Minecraft mc = Minecraft.m_91087_();

    public ExternalTexturePanoramaRenderer(String panoDir) {
        this.dir = panoDir;
        File props = new File(this.dir + "/properties.txt");
        if (props.exists()) {
            PropertiesSet s = PropertiesSerializer.getProperties((String)props.getPath());
            if (s != null) {
                List l = s.getPropertiesOfType("panorama-meta");
                if (l != null && !l.isEmpty()) {
                    String an;
                    String fo;
                    String sp;
                    this.name = ((PropertiesSection)l.get(0)).getEntryValue("name");
                    if (this.name == null) {
                        System.out.println("############## ERROR [FANCYMENU] ##############");
                        System.out.println("Missing 'name' value in properties file for panorama cube: " + this.dir);
                        System.out.println("###############################################");
                    }
                    if ((sp = ((PropertiesSection)l.get(0)).getEntryValue("speed")) != null && MathUtils.isFloat((String)sp)) {
                        this.speed = Float.parseFloat(sp);
                    }
                    if ((fo = ((PropertiesSection)l.get(0)).getEntryValue("fov")) != null && MathUtils.isDouble((String)fo)) {
                        this.fov = Double.parseDouble(fo);
                    }
                    if ((an = ((PropertiesSection)l.get(0)).getEntryValue("angle")) != null && MathUtils.isFloat((String)an)) {
                        this.angle = Float.parseFloat(an);
                    }
                } else {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing 'panorama-meta' section in properties file for panorama cube: " + this.dir);
                    System.out.println("###############################################");
                }
            } else {
                System.out.println("############## ERROR [FANCYMENU] ##############");
                System.out.println("An error happened while trying to get properties for panorama cube: " + this.dir);
                System.out.println("###############################################");
            }
        } else {
            System.out.println("############## ERROR [FANCYMENU] ##############");
            System.out.println("Properties file not found for panorama cube: " + this.dir);
            System.out.println("###############################################");
        }
    }

    public void preparePanorama() {
        File imagesDir;
        if (!this.prepared && this.name != null && (imagesDir = new File(this.dir + "/panorama")).exists() && imagesDir.isDirectory()) {
            for (int i = 0; i < 6; ++i) {
                File f = new File(this.dir + "/panorama/panorama_" + i + ".png");
                if (!f.exists() || !f.isFile()) {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing panorama image 'panorama_" + i + ".png' for panorama cube: " + this.name);
                    System.out.println("###############################################");
                    return;
                }
                ExternalTextureResourceLocation r = new ExternalTextureResourceLocation(f.getPath());
                this.pano.add(r);
            }
            File overlay = new File(this.dir + "/overlay.png");
            if (overlay.exists()) {
                this.overlay_texture = new ExternalTextureResourceLocation(overlay.getPath());
            }
            this.prepared = true;
        }
    }

    public void render() {
        try {
            this.renderRaw(1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void renderRaw(float panoramaAlpha) {
        if (this.prepared) {
            this.time += Minecraft.m_91087_().m_91297_() * this.speed;
            float pitch = Mth.m_14031_((float)(this.time * 0.001f)) * 5.0f + this.angle;
            float yaw = -this.time * 0.1f;
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            Matrix4f matrix4f = Matrix4f.m_27625_((double)this.fov, (float)((float)this.mc.m_91268_().m_85441_() / (float)this.mc.m_91268_().m_85442_()), (float)0.05f, (float)10.0f);
            RenderSystem.m_157183_();
            RenderSystem.m_157425_((Matrix4f)matrix4f);
            PoseStack matrix = RenderSystem.m_157191_();
            matrix.m_85836_();
            matrix.m_166856_();
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            RenderSystem.m_157182_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69464_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69453_();
            for (int j = 0; j < 4; ++j) {
                matrix.m_85836_();
                float f = ((float)(j % 2) / 2.0f - 0.5f) / 256.0f;
                float g = ((float)(j / 2) / 2.0f - 0.5f) / 256.0f;
                matrix.m_85837_((double)f, (double)g, 0.0);
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
                RenderSystem.m_157182_();
                for (int k = 0; k < 6; ++k) {
                    ExternalTextureResourceLocation r = this.pano.get(k);
                    if (r == null) continue;
                    if (!r.isReady()) {
                        r.loadTexture();
                    }
                    RenderSystem.m_157456_((int)0, (ResourceLocation)r.getResourceLocation());
                    bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    int l = Math.round(255.0f * panoramaAlpha) / (j + 1);
                    if (k == 0) {
                        bufferBuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    }
                    if (k == 1) {
                        bufferBuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    }
                    if (k == 2) {
                        bufferBuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    }
                    if (k == 3) {
                        bufferBuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    }
                    if (k == 4) {
                        bufferBuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    }
                    if (k == 5) {
                        bufferBuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, l).m_5752_();
                        bufferBuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, l).m_5752_();
                    }
                    tesselator.m_85914_();
                }
                matrix.m_85849_();
                RenderSystem.m_157182_();
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            }
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.m_157424_();
            matrix.m_85849_();
            RenderSystem.m_157182_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69481_();
            RenderSystem.m_69482_();
            if (this.overlay_texture != null) {
                if (!this.overlay_texture.isReady()) {
                    this.overlay_texture.loadTexture();
                }
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69478_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.overlay_texture.getResourceLocation());
                ExternalTexturePanoramaRenderer.m_93133_((PoseStack)CurrentScreenHandler.getPoseStack(), (int)0, (int)0, (float)0.0f, (float)0.0f, (int)Minecraft.m_91087_().f_91080_.f_96543_, (int)Minecraft.m_91087_().f_91080_.f_96544_, (int)Minecraft.m_91087_().f_91080_.f_96543_, (int)Minecraft.m_91087_().f_91080_.f_96544_);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.speed = speed;
    }

    public void setFov(double fov) {
        if (fov > 179.0) {
            fov = 179.0;
        }
        this.fov = fov;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

