/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler.custom;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationLayer;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationLayerRegistry;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.titlescreen.splash.TitleScreenSplashElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.titlescreen.splash.TitleScreenSplashItem;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.reflection.ReflectionHelper;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.internal.BrandingControl;

public class MainMenuHandler
extends MenuHandlerBase {
    private static final CubeMap PANORAMA_CUBE_MAP = new CubeMap(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation MINECRAFT_TITLE_TEXTURE = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation EDITION_TITLE_TEXTURE = new ResourceLocation("textures/gui/title/edition.png");
    private static final Random RANDOM = new Random();
    private PanoramaRenderer panorama = new PanoramaRenderer(PANORAMA_CUBE_MAP);
    protected boolean showLogo = true;
    protected boolean showBranding = true;
    protected boolean showForgeNotificationCopyright = true;
    protected boolean showForgeNotificationTop = true;
    protected boolean showRealmsNotification = true;
    protected TitleScreenSplashItem splashItem = null;

    public MainMenuHandler() {
        super(TitleScreen.class.getName());
    }

    @Override
    public void onMenuReloaded(MenuReloadedEvent e) {
        super.onMenuReloaded(e);
        TitleScreenSplashItem.cachedSplashText = null;
    }

    @Override
    public void onInitPre(ScreenEvent.Init.Pre e) {
        if (this.shouldCustomize(e.getScreen()) && MenuCustomization.isMenuCustomizable(e.getScreen()) && e.getScreen() instanceof TitleScreen) {
            MainMenuHandler.setShowFadeInAnimation(false, (TitleScreen)e.getScreen());
        }
        super.onInitPre(e);
    }

    @Override
    public void onButtonsCached(ButtonCachedEvent e) {
        if (this.shouldCustomize(e.getScreen()) && MenuCustomization.isMenuCustomizable(e.getScreen())) {
            TitleScreenSplashElement element;
            this.showLogo = true;
            this.showBranding = true;
            this.showForgeNotificationCopyright = true;
            this.showForgeNotificationTop = true;
            this.showRealmsNotification = true;
            DeepCustomizationLayer layer = DeepCustomizationLayerRegistry.getLayerByMenuIdentifier(this.getMenuIdentifier());
            if (layer != null && (element = (TitleScreenSplashElement)layer.getElementByIdentifier("title_screen_splash")) != null) {
                this.splashItem = (TitleScreenSplashItem)element.constructDefaultItemInstance();
            }
            super.onButtonsCached(e);
        }
    }

    @Override
    protected void applyLayout(PropertiesSection sec, String renderOrder, ButtonCachedEvent e) {
        DeepCustomizationItem i;
        String elementId;
        DeepCustomizationElement element;
        String action;
        super.applyLayout(sec, renderOrder, e);
        DeepCustomizationLayer layer = DeepCustomizationLayerRegistry.getLayerByMenuIdentifier(this.getMenuIdentifier());
        if (layer != null && (action = sec.getEntryValue("action")) != null && action.startsWith("deep_customization_element:") && (element = layer.getElementByIdentifier(elementId = action.split("[:]", 2)[1])) != null && (i = element.constructCustomizedItemInstance(sec)) != null) {
            if (elementId.equals("title_screen_branding")) {
                boolean bl = this.showBranding = !i.hidden;
            }
            if (elementId.equals("title_screen_logo")) {
                boolean bl = this.showLogo = !i.hidden;
            }
            if (elementId.equals("title_screen_splash")) {
                this.splashItem = (TitleScreenSplashItem)i;
            }
            if (elementId.equals("title_screen_realms_notification")) {
                boolean bl = this.showRealmsNotification = !i.hidden;
            }
            if (elementId.equals("title_screen_forge_copyright")) {
                boolean bl = this.showForgeNotificationCopyright = !i.hidden;
            }
            if (elementId.equals("title_screen_forge_top")) {
                this.showForgeNotificationTop = !i.hidden;
            }
        }
    }

    @SubscribeEvent
    public void onRender(ScreenEvent.Render.Pre e) {
        if (this.shouldCustomize(e.getScreen()) && MenuCustomization.isMenuCustomizable(e.getScreen())) {
            e.setCanceled(true);
            e.getScreen().m_7333_(e.getPoseStack());
        }
    }

    @Override
    public void drawToBackground(ScreenEvent.BackgroundRendered e) {
        if (this.shouldCustomize(e.getScreen())) {
            Font font = Minecraft.m_91087_().f_91062_;
            int width = e.getScreen().f_96543_;
            int height = e.getScreen().f_96544_;
            int j = width / 2 - 137;
            float minecraftLogoSpelling = RANDOM.nextFloat();
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            PoseStack matrix = CurrentScreenHandler.getPoseStack();
            RenderSystem.m_69478_();
            if (!this.canRenderBackground()) {
                this.panorama.m_110003_(Minecraft.m_91087_().m_91297_(), 1.0f);
                RenderUtils.bindTexture((ResourceLocation)PANORAMA_OVERLAY);
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MainMenuHandler.m_93160_((PoseStack)matrix, (int)0, (int)0, (int)e.getScreen().f_96543_, (int)e.getScreen().f_96544_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            }
            super.drawToBackground(e);
            if (this.showLogo) {
                RenderUtils.bindTexture((ResourceLocation)MINECRAFT_TITLE_TEXTURE);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if ((double)minecraftLogoSpelling < 1.0E-4) {
                    this.m_93228_(matrix, j + 0, 30, 0, 0, 99, 44);
                    this.m_93228_(matrix, j + 99, 30, 129, 0, 27, 44);
                    this.m_93228_(matrix, j + 99 + 26, 30, 126, 0, 3, 44);
                    this.m_93228_(matrix, j + 99 + 26 + 3, 30, 99, 0, 26, 44);
                    this.m_93228_(matrix, j + 155, 30, 0, 45, 155, 44);
                } else {
                    this.m_93228_(matrix, j + 0, 30, 0, 0, 155, 44);
                    this.m_93228_(matrix, j + 155, 30, 0, 45, 155, 44);
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)EDITION_TITLE_TEXTURE);
                MainMenuHandler.m_93133_((PoseStack)matrix, (int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            }
            if (this.showBranding) {
                BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                    int n = e.getScreen().f_96544_;
                    int n2 = brdline;
                    Objects.requireNonNull(font);
                    GuiComponent.m_93236_((PoseStack)matrix, (Font)font, (String)brd, (int)2, (int)(n - (10 + n2 * (9 + 1))), (int)0xFFFFFF);
                });
            }
            if (this.showForgeNotificationTop) {
                ForgeHooksClient.renderMainMenu((TitleScreen)((TitleScreen)e.getScreen()), (PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (int)e.getScreen().f_96543_, (int)e.getScreen().f_96544_, (int)255);
            }
            if (this.showForgeNotificationCopyright) {
                BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                    int n = e.getScreen().f_96543_ - font.m_92895_(brd) - 1;
                    int n2 = e.getScreen().f_96544_;
                    int n3 = brdline + 1;
                    Objects.requireNonNull(font);
                    GuiComponent.m_93236_((PoseStack)matrix, (Font)font, (String)brd, (int)n, (int)(n2 - (11 + n3 * (9 + 1))), (int)0xFFFFFF);
                });
            }
            if (!PopupHandler.isPopupActive()) {
                this.renderButtons(e, mouseX, mouseY);
            }
            if (this.showRealmsNotification) {
                this.drawRealmsNotification(matrix, e.getScreen());
            }
            this.renderSplash(matrix, e.getScreen());
        }
    }

    protected void renderSplash(PoseStack matrix, Screen s) {
        try {
            if (this.splashItem != null) {
                this.splashItem.render(matrix, s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderButtons(ScreenEvent.BackgroundRendered e, int mouseX, int mouseY) {
        List<Widget> buttons = this.getButtonList(e.getScreen());
        float partial = Minecraft.m_91087_().m_91296_();
        if (buttons != null) {
            for (int i = 0; i < buttons.size(); ++i) {
                buttons.get(i).m_6305_(CurrentScreenHandler.getPoseStack(), mouseX, mouseY, partial);
            }
        }
    }

    private void drawRealmsNotification(PoseStack matrix, Screen gui) {
        if (((Boolean)Minecraft.m_91087_().f_91066_.m_231822_().m_231551_()).booleanValue()) {
            Field f = ReflectionHelper.findField(TitleScreen.class, (String)"f_96726_");
            Screen realms = null;
            try {
                realms = (Screen)f.get(gui);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (realms != null) {
                realms.m_6305_(matrix, (int)Minecraft.m_91087_().f_91067_.m_91589_(), (int)Minecraft.m_91087_().f_91067_.m_91594_(), Minecraft.m_91087_().m_91296_());
            }
        }
    }

    private List<Widget> getButtonList(Screen gui) {
        List<Object> buttons = new ArrayList<Widget>();
        try {
            Field f = ReflectionHelper.findField(Screen.class, (String)"f_169369_");
            try {
                buttons = (List)f.get(gui);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buttons;
    }

    protected static void setShowFadeInAnimation(boolean showFadeIn, TitleScreen s) {
        try {
            Field f = ReflectionHelper.findField(TitleScreen.class, (String)"f_96714_");
            f.setBoolean(s, showFadeIn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

