/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.annotations.OptifineFix;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.awt.Color;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class WebTextureCustomizationItem
extends CustomizationItemBase {
    public static Map<String, WebTextureResourceLocation> cachedWebImages = new HashMap<String, WebTextureResourceLocation>();
    public volatile WebTextureResourceLocation texture;
    public String rawURL = "";
    public volatile boolean ready = false;

    @OptifineFix
    public WebTextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addwebtexture")) {
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.rawURL = this.value;
                this.value = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(this.value), (String)"\u00a7", (String)"&");
                if (this.getWidth() <= 0 && this.getHeight() <= 0) {
                    this.setWidth(100);
                }
                if (cachedWebImages.containsKey(this.actionId)) {
                    this.texture = cachedWebImages.get(this.actionId);
                    this.calculateAspectRatio();
                    if (this.texture != null && this.texture.getResourceLocation() != null && this.texture.getURL() != null && this.texture.getURL().equals(this.value)) {
                        this.ready = true;
                    } else {
                        this.texture = null;
                    }
                }
                if (this.texture == null) {
                    new Thread(() -> {
                        try {
                            if (WebTextureCustomizationItem.isValidUrl(this.value)) {
                                long currentTime;
                                this.texture = TextureHandler.getWebResource((String)this.value, (boolean)false);
                                CustomizationHelper.runTaskInMainThread(() -> {
                                    try {
                                        this.texture.loadTexture();
                                        cachedWebImages.put(this.actionId, this.texture);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                });
                                long startTime = System.currentTimeMillis();
                                while (!(startTime + 15000L < (currentTime = System.currentTimeMillis()) || this.texture.isReady() && this.texture.getResourceLocation() != null)) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (Exception exception) {}
                                }
                                if (this.texture != null && this.texture.getResourceLocation() == null) {
                                    this.texture = null;
                                    FancyMenu.LOGGER.error("[FANCYMENU] Web texture loaded but resource location was still null! Unable to use web texture!");
                                }
                                this.calculateAspectRatio();
                            }
                            this.ready = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                }
            }
        }
    }

    protected void calculateAspectRatio() {
        if (this.texture == null || !this.texture.isReady()) {
            if (this.getWidth() <= 0) {
                this.setWidth(100);
            }
            if (this.getHeight() <= 0) {
                this.setHeight(100);
            }
            this.ready = true;
            return;
        }
        int w = this.texture.getWidth();
        int h = this.texture.getHeight();
        double ratio = (double)w / (double)h;
        if (this.getWidth() < 0 && this.getHeight() >= 0) {
            this.setWidth((int)((double)this.getHeight() * ratio));
        }
        if (this.getHeight() < 0 && this.getWidth() >= 0) {
            this.setHeight((int)((double)this.getWidth() / ratio));
        }
    }

    @Override
    public void render(PoseStack matrix, Screen menu) throws IOException {
        if (this.shouldRender() || WebTextureCustomizationItem.isEditorActive()) {
            int x = this.getPosX(menu);
            int y = this.getPosY(menu);
            if (this.isTextureReady()) {
                RenderUtils.bindTexture((ResourceLocation)this.texture.getResourceLocation());
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                WebTextureCustomizationItem.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.getHeight(), (int)this.getWidth(), (int)this.getHeight());
                RenderSystem.m_69461_();
            } else if (WebTextureCustomizationItem.isEditorActive()) {
                WebTextureCustomizationItem.m_93172_((PoseStack)matrix, (int)this.getPosX(menu), (int)this.getPosY(menu), (int)(this.getPosX(menu) + this.getWidth()), (int)(this.getPosY(menu) + this.getHeight()), (int)Color.MAGENTA.getRGB());
                if (this.ready) {
                    Font font = Minecraft.m_91087_().f_91062_;
                    int n = this.getPosX(menu) + this.getWidth() / 2;
                    int n2 = this.getPosY(menu) + this.getHeight() / 2;
                    Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                    WebTextureCustomizationItem.m_93208_((PoseStack)matrix, (Font)font, (String)"\u00a7lMISSING", (int)n, (int)(n2 - 9 / 2), (int)-1);
                }
            }
            if (!this.ready && WebTextureCustomizationItem.isEditorActive()) {
                Font font = Minecraft.m_91087_().f_91062_;
                int n = this.getPosX(menu) + this.getWidth() / 2;
                int n3 = this.getPosY(menu) + this.getHeight() / 2;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                WebTextureCustomizationItem.m_93208_((PoseStack)matrix, (Font)font, (String)"\u00a7lLOADING TEXTURE..", (int)n, (int)(n3 - 9 / 2), (int)-1);
            }
        }
    }

    public boolean isTextureReady() {
        return this.texture != null && this.texture.isReady() && this.texture.getResourceLocation() != null && this.ready;
    }

    @Override
    public boolean shouldRender() {
        if (this.getWidth() < 0 || this.getHeight() < 0) {
            return false;
        }
        return super.shouldRender();
    }

    public static boolean isValidUrl(String url) {
        if (url != null && (url.startsWith("http://") || url.startsWith("https://"))) {
            try {
                URL u = new URL(url);
                HttpURLConnection c = (HttpURLConnection)u.openConnection();
                c.addRequestProperty("User-Agent", "Mozilla/4.0");
                c.setRequestMethod("HEAD");
                int r = c.getResponseCode();
                if (r == 200) {
                    return true;
                }
            }
            catch (Exception e1) {
                try {
                    URL u = new URL(url);
                    HttpURLConnection c = (HttpURLConnection)u.openConnection();
                    c.addRequestProperty("User-Agent", "Mozilla/4.0");
                    int r = c.getResponseCode();
                    if (r == 200) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return false;
    }
}

