/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.visibilityrequirements;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.api.visibilityrequirements.VisibilityRequirement;
import de.keksuccino.fancymenu.menu.fancy.helper.PlaceholderEditBox;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.visibilityrequirements.LegacyVisibilityRequirements;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ScrollableScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.visibilityrequirements.VisibilityRequirementContainer;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;

public class VisibilityRequirementsScreen
extends ScrollableScreen {
    protected static final Color ENTRY_BACK_1 = new Color(0, 0, 0, 50);
    protected static final Color ENTRY_BACK_2 = new Color(0, 0, 0, 90);
    public CustomizationItemBase parentItem;
    protected int entryBackTick = 0;
    protected AdvancedButton doneButton;
    protected List<PlaceholderEditBox> contextMenuRenderQueue = new ArrayList<PlaceholderEditBox>();

    public VisibilityRequirementsScreen(Screen parent, CustomizationItemBase parentItem) {
        super(parent, Locals.localize((String)"fancymenu.helper.ui.visibility_requirements.manage", (String[])new String[0]));
        this.parentItem = parentItem;
        this.doneButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, press -> Minecraft.m_91087_().m_91152_(this.parent));
        this.doneButton.ignoreLeftMouseDownClickBlock = true;
        UIBase.colorizeButton(this.doneButton);
        VisibilityRequirementContainer c = this.parentItem.visibilityRequirementContainer;
        LegacyVisibilityRequirements.getLegacyRequirements(this, c).forEach(req -> this.addRequirement((Requirement)((Object)req)));
        for (VisibilityRequirementContainer.RequirementPackage p : c.customRequirements.values()) {
            VisibilityRequirement v = p.requirement;
            String valuePreset = null;
            if (v.hasValue()) {
                valuePreset = v.getValuePreset();
                if (valuePreset == null) {
                    valuePreset = "";
                }
                if (p.value != null) {
                    valuePreset = p.value;
                }
            }
            Consumer<String> valueCallback = null;
            if (v.hasValue()) {
                valueCallback = call -> {
                    p.value = call;
                };
            }
            CharacterFilter charFilter = v.getValueInputFieldFilter();
            Object desc = "";
            for (String s : v.getDescription()) {
                if (s.equalsIgnoreCase("")) {
                    s = " ";
                }
                if (((String)desc).equalsIgnoreCase("")) {
                    desc = (String)desc + s;
                    continue;
                }
                desc = (String)desc + "%n%" + s;
            }
            Requirement req2 = new Requirement(this, v.getDisplayName(), (String)desc, v.getValueDisplayName(), p.checkFor, p.showIf, enabledCallback -> {
                p.checkFor = enabledCallback;
            }, showIfCallback -> {
                p.showIf = showIfCallback;
            }, valueCallback, charFilter, valuePreset);
            this.addRequirement(req2);
        }
    }

    @Override
    public boolean isOverlayButtonHovered() {
        return this.doneButton.m_198029_();
    }

    protected void addRequirement(Requirement requirement) {
        if (this.entryBackTick == 0) {
            this.scrollArea.addEntry((ScrollAreaEntry)new RequirementScrollEntry(this.scrollArea, requirement, ENTRY_BACK_1));
            this.entryBackTick = 1;
        } else {
            this.scrollArea.addEntry((ScrollAreaEntry)new RequirementScrollEntry(this.scrollArea, requirement, ENTRY_BACK_2));
            this.entryBackTick = 0;
        }
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.SeparatorEntry(this.scrollArea, 1, new Color(255, 255, 255, 100)));
    }

    @Override
    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        int xCenter = this.f_96543_ / 2;
        this.doneButton.setX(xCenter - this.doneButton.m_5711_() / 2);
        this.doneButton.setY(this.f_96544_ - 35);
        this.doneButton.m_6305_(matrix, mouseX, mouseY, partialTicks);
        for (PlaceholderEditBox b : this.contextMenuRenderQueue) {
            b.renderContextMenu(matrix);
        }
        this.contextMenuRenderQueue.clear();
    }

    public static class Requirement
    extends GuiComponent {
        protected VisibilityRequirementsScreen parent;
        protected String name;
        protected String desc;
        protected String valueName;
        protected Consumer<Boolean> enabledCallback;
        protected Consumer<Boolean> showIfCallback;
        protected Consumer<String> valueCallback;
        protected CharacterFilter valueFilter;
        protected boolean enabled;
        protected boolean showIf;
        protected String valueString;
        protected boolean hasValue = false;
        protected List<Runnable> preRenderTasks = new ArrayList<Runnable>();
        protected List<AdvancedButton> buttonList = new ArrayList<AdvancedButton>();
        protected AdvancedButton enableRequirementButton;
        protected AdvancedButton showIfButton;
        protected AdvancedButton showIfNotButton;
        protected AdvancedTextField valueTextField;

        public Requirement(VisibilityRequirementsScreen parent, String name, String desc, @Nullable String valueName, boolean enabled, boolean showIf, Consumer<Boolean> enabledCallback, Consumer<Boolean> showIfCallback, @Nullable Consumer<String> valueCallback, CharacterFilter valueFilter, String valueString) {
            this.parent = parent;
            this.name = name;
            this.desc = desc;
            this.valueName = valueName;
            this.enabledCallback = enabledCallback;
            this.showIfCallback = showIfCallback;
            this.valueCallback = valueCallback;
            this.valueFilter = valueFilter;
            this.enabled = enabled;
            this.showIf = showIf;
            this.valueString = valueString;
            this.init();
        }

        protected void init() {
            String enabledString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.enabled", (String[])new String[]{this.name});
            if (!this.enabled) {
                enabledString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.disabled", (String[])new String[]{this.name});
            }
            this.enableRequirementButton = new AdvancedButton(0, 0, 150, 20, enabledString, true, press -> {
                if (!this.parent.isOverlayButtonHovered()) {
                    if (this.enabled) {
                        this.enabled = false;
                        this.enabledCallback.accept(false);
                        ((AdvancedButton)press).setMessage(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.disabled", (String[])new String[]{this.name}));
                    } else {
                        this.enabled = true;
                        this.enabledCallback.accept(true);
                        ((AdvancedButton)press).setMessage(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.enabled", (String[])new String[]{this.name}));
                    }
                }
            });
            ArrayList<String> descLines = new ArrayList<String>();
            descLines.addAll(Arrays.asList(StringUtils.splitLines((String)this.desc, (String)"%n%")));
            descLines.add("");
            descLines.add(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.toggle.btn.desc", (String[])new String[0]));
            this.enableRequirementButton.setDescription(descLines.toArray(new String[0]));
            this.preRenderTasks.add(() -> this.enableRequirementButton.m_93674_(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.enableRequirementButton.m_6035_()) + 10));
            this.addButton(this.enableRequirementButton);
            Object showIfString = "\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]);
            if (!this.showIf) {
                showIfString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]);
            }
            this.showIfButton = new AdvancedButton(0, 0, 100, 20, (String)showIfString, true, press -> {
                if (!this.parent.isOverlayButtonHovered()) {
                    this.showIf = true;
                    this.showIfCallback.accept(true);
                    ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]));
                    this.showIfNotButton.setMessage(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]));
                }
            });
            this.showIfButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfButton);
            Object showIfNotString = "\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]);
            if (this.showIf) {
                showIfNotString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]);
            }
            this.showIfNotButton = new AdvancedButton(0, 0, 100, 20, (String)showIfNotString, true, press -> {
                if (!this.parent.isOverlayButtonHovered()) {
                    this.showIf = false;
                    this.showIfCallback.accept(false);
                    ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]));
                    this.showIfButton.setMessage(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]));
                }
            });
            this.showIfNotButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfNotButton);
            if (this.valueCallback != null && this.valueName != null) {
                this.hasValue = true;
                this.valueTextField = new PlaceholderEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 150, 20, true, this.valueFilter);
                ((PlaceholderEditBox)this.valueTextField).renderContextMenu = false;
                this.valueTextField.m_94190_(true);
                this.valueTextField.m_94178_(false);
                this.valueTextField.m_94199_(1000);
                if (this.valueString != null) {
                    this.valueTextField.m_94144_(this.valueString);
                }
            }
        }

        public void render(PoseStack matrix, int mouseX, int mouseY, RequirementScrollEntry entry) {
            for (Runnable r : this.preRenderTasks) {
                r.run();
            }
            float partial = Minecraft.m_91087_().m_91296_();
            int originX = entry.x + entry.getWidth() / 2;
            int originY = entry.y + entry.getHeight() / 2;
            originY = this.hasValue ? (originY += 23) : (originY += 45);
            this.enableRequirementButton.f_93620_ = originX - this.enableRequirementButton.m_5711_() / 2;
            this.enableRequirementButton.f_93621_ = originY - 70;
            this.showIfButton.f_93620_ = originX - this.showIfButton.m_5711_() - 5;
            this.showIfButton.f_93621_ = originY - 40;
            this.showIfNotButton.f_93623_ = this.enabled;
            this.showIfNotButton.f_93620_ = originX + 5;
            this.showIfNotButton.f_93621_ = originY - 40;
            this.showIfButton.f_93623_ = this.enabled;
            if (this.valueTextField != null) {
                Requirement.m_93208_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)(this.valueName + ":"), (int)originX, (int)(originY - 10), (int)-1);
                this.valueTextField.f_93620_ = originX - this.valueTextField.m_5711_() / 2;
                this.valueTextField.f_93621_ = originY + 3;
                this.valueTextField.m_6305_(matrix, mouseX, mouseY, partial);
                this.parent.contextMenuRenderQueue.add((PlaceholderEditBox)this.valueTextField);
                this.valueTextField.f_93623_ = this.enabled;
                this.valueTextField.m_94186_(this.enabled);
                this.valueCallback.accept(this.valueTextField.m_94155_());
                this.valueString = this.valueTextField.m_94155_();
            }
            this.renderButtons(matrix, mouseX, mouseY, partial);
        }

        protected void renderButtons(PoseStack matrix, int mouseX, int mouseY, float partial) {
            for (AdvancedButton b : this.buttonList) {
                b.m_6305_(matrix, mouseX, mouseY, partial);
            }
        }

        protected void addButton(AdvancedButton b) {
            if (!this.buttonList.contains(b)) {
                this.buttonList.add(b);
                UIBase.colorizeButton(b);
            }
        }
    }

    public static class RequirementScrollEntry
    extends ScrollableScreen.ScrollAreaEntryBase {
        public Requirement requirement;
        public boolean hasValue = false;
        public Color backgroundColor;

        public RequirementScrollEntry(ScrollArea parent, Requirement requirement, Color backgroundColor) {
            super(parent, call -> {});
            this.requirement = requirement;
            this.backgroundColor = backgroundColor;
            if (requirement.valueCallback != null && requirement.valueName != null) {
                this.hasValue = true;
                this.setHeight(110);
            } else {
                this.setHeight(66);
            }
        }

        @Override
        public void renderEntry(PoseStack matrix) {
            super.renderEntry(matrix);
            RequirementScrollEntry.m_93172_((PoseStack)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)this.backgroundColor.getRGB());
            this.requirement.render(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), this);
        }
    }
}

