/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.buttonactions;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionRegistry;
import de.keksuccino.fancymenu.menu.fancy.helper.PlaceholderEditBox;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.LayoutButton;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.buttonactions.LegacyButtonActions;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ScrollableScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ButtonActionScreen
extends ScrollableScreen {
    protected static final Color ENTRY_BACK_1 = new Color(0, 0, 0, 50);
    protected static final Color ENTRY_BACK_2 = new Color(0, 0, 0, 90);
    public LayoutButton parentButton;
    protected List<ButtonAction> buttonActions = new ArrayList<ButtonAction>();
    protected int entryBackTick = 0;
    protected AdvancedButton doneButton;
    protected PlaceholderEditBox valueTextField;
    protected Consumer<List<String>> callback;

    public ButtonActionScreen(Screen parent, LayoutButton parentButton) {
        this(parent, parentButton, null);
    }

    public ButtonActionScreen(Screen parent, Consumer<List<String>> callback) {
        this(parent, null, callback);
    }

    protected ButtonActionScreen(Screen parent, @Nullable LayoutButton parentButton, @Nullable Consumer<List<String>> callback) {
        super(parent, Locals.localize((String)"fancymenu.helper.ui.button_action.set", (String[])new String[0]));
        this.parentButton = parentButton;
        this.callback = callback;
        this.doneButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, press -> {
            if (!this.valueTextField.variableMenu.isOpen()) {
                this.onDone();
                this.m_7379_();
            }
        });
        this.doneButton.ignoreLeftMouseDownClickBlock = true;
        UIBase.colorizeButton(this.doneButton);
        this.valueTextField = new PlaceholderEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 150, 20, true, null);
        this.valueTextField.m_94190_(true);
        this.valueTextField.m_94178_(false);
        this.valueTextField.m_94199_(1000);
        if (this.parentButton != null && this.parentButton.actionContent != null) {
            this.valueTextField.m_94144_(this.parentButton.actionContent);
        }
        LegacyButtonActions.getLegacyActions(this).forEach(action -> this.addButtonAction((ButtonAction)((Object)action)));
        for (ButtonActionContainer c : ButtonActionRegistry.getActions()) {
            this.addButtonAction(new ButtonAction(this, c.getAction(), c.getActionDescription(), c.hasValue(), c.getValueDescription(), c.getValueExample(), null));
        }
        ButtonAction selectedAction = null;
        if (this.parentButton != null && this.parentButton.actionType != null) {
            selectedAction = this.getButtonActionByName(this.parentButton.actionType);
        }
        if (selectedAction == null) {
            selectedAction = this.buttonActions.get(0);
        }
        this.setButtonActionSelected(selectedAction, true);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.scrollArea.height = this.f_96544_ - 165;
    }

    @Override
    public boolean isOverlayButtonHovered() {
        return this.doneButton.m_198029_();
    }

    protected void addButtonAction(ButtonAction action) {
        this.buttonActions.add(action);
        if (this.entryBackTick == 0) {
            this.scrollArea.addEntry((ScrollAreaEntry)new ButtonActionScrollEntry(this.scrollArea, action, ENTRY_BACK_1));
            this.entryBackTick = 1;
        } else {
            this.scrollArea.addEntry((ScrollAreaEntry)new ButtonActionScrollEntry(this.scrollArea, action, ENTRY_BACK_2));
            this.entryBackTick = 0;
        }
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.SeparatorEntry(this.scrollArea, 1, new Color(255, 255, 255, 100)));
    }

    protected void setButtonActionSelected(ButtonAction action, boolean selected) {
        action.selected = selected;
        this.buttonActions.forEach(ba -> {
            if (ba != action) {
                ba.selected = false;
            }
        });
    }

    @Nullable
    protected ButtonAction getSelectedButtonAction() {
        for (ButtonAction a : this.buttonActions) {
            if (!a.selected) continue;
            return a;
        }
        return null;
    }

    @Nullable
    protected ButtonAction getButtonActionByName(String name) {
        for (ButtonAction a : this.buttonActions) {
            if (!a.name.equals(name)) continue;
            return a;
        }
        return null;
    }

    protected void onDone() {
        ButtonAction selected = this.getSelectedButtonAction();
        if (selected == null) {
            selected = this.buttonActions.get(0);
        }
        String value = null;
        if (selected.hasValue) {
            value = this.valueTextField.m_94155_();
        }
        if (this.parentButton != null) {
            if (!this.parentButton.actionType.equals(selected.name) || !this.parentButton.actionContent.equals(value)) {
                this.parentButton.handler.history.saveSnapshot(this.parentButton.handler.history.createSnapshot());
            }
            this.parentButton.actionType = selected.name;
            this.parentButton.actionContent = value;
        }
        if (this.callback != null) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(selected.name);
            if (value == null) {
                value = "";
            }
            l.add(value);
            this.callback.accept(l);
        }
    }

    @Override
    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        int footerHeight;
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        ButtonAction selected = this.getSelectedButtonAction();
        if (selected == null) {
            selected = this.buttonActions.get(0);
        }
        int xCenter = this.f_96543_ / 2;
        ButtonActionScreen.m_93172_((PoseStack)matrix, (int)0, (int)(this.f_96544_ - 115), (int)this.f_96543_, (int)this.f_96544_, (int)HEADER_FOOTER_COLOR.getRGB());
        this.doneButton.setX(xCenter - this.doneButton.m_5711_() / 2);
        this.doneButton.setY(this.f_96544_ - 35);
        this.doneButton.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (selected.hasValue) {
            ButtonActionScreen.m_93215_((PoseStack)matrix, (Font)this.f_96547_, (Component)Component.m_237113_((String)Locals.localize((String)"helper.creator.custombutton.config.actionvalue", (String[])new String[]{selected.valueDesc})), (int)xCenter, (int)(this.f_96544_ - 100), (int)-1);
            this.valueTextField.m_94214_(xCenter - this.valueTextField.m_5711_() / 2);
            this.valueTextField.setY(this.f_96544_ - 85);
            this.valueTextField.m_94186_(selected.hasValue);
            this.valueTextField.f_93623_ = selected.hasValue;
            for (AdvancedButton b : this.valueTextField.variableMenu.getContent()) {
                b.ignoreLeftMouseDownClickBlock = true;
            }
            this.valueTextField.m_6305_(matrix, mouseX, mouseY, partialTicks);
            ButtonActionScreen.m_93215_((PoseStack)matrix, (Font)this.f_96547_, (Component)Component.m_237113_((String)Locals.localize((String)"helper.creator.custombutton.config.actionvalue.example", (String[])new String[]{selected.valueExample})), (int)xCenter, (int)(this.f_96544_ - 60), (int)-1);
        }
        if (mouseY < this.f_96544_ - (footerHeight = 115)) {
            for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
                String desc;
                if (!(e instanceof ButtonActionScrollEntry) || !e.isHoveredOrFocused() || (desc = ((ButtonActionScrollEntry)e).action.desc) == null) continue;
                ButtonActionScreen.renderDescription(matrix, Arrays.asList(StringUtils.splitLines((String)desc, (String)"%n%")), mouseX, mouseY);
            }
        }
    }

    public void setValueString(String value) {
        this.valueTextField.m_94144_(value);
    }

    public void setButtonAction(String buttonAction) {
        ButtonAction b = this.getButtonActionByName(buttonAction);
        if (b == null) {
            b = this.buttonActions.get(0);
        }
        this.setButtonActionSelected(b, true);
    }

    public static class ButtonAction
    extends GuiComponent {
        protected ButtonActionScreen parent;
        protected String name;
        protected String desc;
        protected String valueDesc;
        protected String valueExample;
        protected CharacterFilter valueFilter = null;
        protected boolean hasValue;
        protected boolean selected = false;

        public ButtonAction(ButtonActionScreen parent, String name, String desc, boolean hasValue, @Nullable String valueDesc, @Nullable String valueExample, @Nullable CharacterFilter valueFilter) {
            this.parent = parent;
            this.name = name;
            this.desc = desc;
            this.valueDesc = valueDesc;
            this.valueFilter = valueFilter;
            this.hasValue = hasValue;
            this.valueExample = valueExample;
        }

        public void render(PoseStack matrix, int mouseX, int mouseY, ButtonActionScrollEntry entry) {
            int centerX = entry.x + entry.getWidth() / 2;
            int centerY = entry.y + entry.getHeight() / 2;
            Font font = Minecraft.m_91087_().f_91062_;
            Color nameBackColor = new Color(255, 255, 255, 30);
            String renderName = "\u00a7l" + this.name;
            if (this.selected) {
                renderName = "\u00a7a\u00a7l" + this.name;
            }
            int nameWidth = font.m_92895_(renderName);
            int nameX = centerX - nameWidth / 2;
            int nameY = centerY - 5;
            Objects.requireNonNull(font);
            ButtonAction.m_93172_((PoseStack)matrix, (int)(nameX - 5), (int)(nameY - 5), (int)(nameX + nameWidth + 5), (int)(nameY + 9 + 5), (int)nameBackColor.getRGB());
            ButtonAction.m_93208_((PoseStack)matrix, (Font)font, (String)renderName, (int)centerX, (int)nameY, (int)-1);
        }

        protected void setSelected(boolean selected) {
            this.parent.setButtonActionSelected(this, selected);
        }
    }

    public static class ButtonActionScrollEntry
    extends ScrollableScreen.ScrollAreaEntryBase {
        public ButtonAction action;
        public Color backgroundColor;
        protected boolean leftMouseDown = false;

        public ButtonActionScrollEntry(ScrollArea parent, ButtonAction action, Color backgroundColor) {
            super(parent, call -> {});
            this.action = action;
            this.backgroundColor = backgroundColor;
            this.setHeight(30);
        }

        @Override
        public void renderEntry(PoseStack matrix) {
            super.renderEntry(matrix);
            int footerHeight = 115;
            if (!this.leftMouseDown && MouseInput.getMouseY() < this.action.parent.f_96544_ - footerHeight && this.isHoveredOrFocused() && MouseInput.isLeftMouseDown() && !this.action.parent.valueTextField.variableMenu.isOpen()) {
                this.action.setSelected(true);
            }
            this.leftMouseDown = MouseInput.isLeftMouseDown();
            ButtonActionScrollEntry.m_93172_((PoseStack)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)this.backgroundColor.getRGB());
            this.action.render(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), this);
        }
    }
}

