/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper;

import com.google.common.io.Files;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroScreen;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationButton;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.SetupSharingEngine;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.CreateCustomGuiPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMContextMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.MenuBar;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMNotificationPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMTextInputPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMYesNoPopup;
import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.gui.screens.ConfigScreen;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.gui.screens.popup.TextInputPopup;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.awt.Color;
import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomizationHelperUI
extends UIBase {
    public static MenuBar bar;
    public static boolean showButtonInfo;
    public static boolean showMenuInfo;
    protected static List<ButtonData> buttons;
    protected static int tick;
    protected static long lastButtonInfoRightClick;
    protected static final ResourceLocation CLOSE_BUTTON_TEXTURE;
    protected static final ResourceLocation RELOAD_BUTTON_TEXTURE;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new CustomizationHelperUI());
    }

    public static void updateUI() {
        try {
            boolean extended = true;
            if (bar != null) {
                extended = bar.isExtended();
            }
            bar = new MenuBar();
            FMContextMenu currentMenu = new FMContextMenu();
            currentMenu.setAutoclose(true);
            bar.addChild(currentMenu, "fm.ui.tab.current", MenuBar.ElementAlignment.LEFT);
            String toggleLabel = Locals.localize((String)"helper.popup.togglecustomization.enable", (String[])new String[0]);
            if (MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_)) {
                toggleLabel = Locals.localize((String)"helper.popup.togglecustomization.disable", (String[])new String[0]);
            }
            CustomizationButton toggleCustomizationButton = new CustomizationButton(0, 0, 0, 0, toggleLabel, true, press -> {
                if (MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_)) {
                    press.m_93666_((Component)Component.m_237113_((String)Locals.localize((String)"helper.popup.togglecustomization.enable", (String[])new String[0])));
                    MenuCustomization.disableCustomizationForMenu(Minecraft.m_91087_().f_91080_);
                    CustomizationHelper.reloadSystemAndMenu();
                } else {
                    press.m_93666_((Component)Component.m_237113_((String)Locals.localize((String)"helper.popup.togglecustomization.disable", (String[])new String[0])));
                    MenuCustomization.enableCustomizationForMenu(Minecraft.m_91087_().f_91080_);
                    CustomizationHelper.reloadSystemAndMenu();
                }
            });
            toggleCustomizationButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.onoff.btndesc", (String[])new String[0]), (String)"%n%"));
            currentMenu.addContent(toggleCustomizationButton);
            FMContextMenu layoutsMenu = new FMContextMenu();
            layoutsMenu.setAutoclose(true);
            currentMenu.addChild(layoutsMenu);
            CustomizationButton newLayoutButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.layouts.new", (String[])new String[0]), true, press -> {
                LayoutEditorScreen.isActive = true;
                Screen s = Minecraft.m_91087_().f_91080_;
                Minecraft.m_91087_().m_91152_((Screen)new LayoutEditorScreen(s));
                MenuCustomization.stopSounds();
                MenuCustomization.resetSounds();
                for (IAnimationRenderer r : AnimationHandler.getAnimations()) {
                    if (!(r instanceof AdvancedAnimation)) continue;
                    ((AdvancedAnimation)r).stopAudio();
                    if (!((AdvancedAnimation)r).replayIntro()) continue;
                    r.resetAnimation();
                }
            });
            newLayoutButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.layouts.new.desc", (String[])new String[0]), (String)"%n%"));
            layoutsMenu.addContent(newLayoutButton);
            ManageLayoutsContextMenu manageLayoutsMenu = new ManageLayoutsContextMenu(false);
            manageLayoutsMenu.setAutoclose(true);
            layoutsMenu.addChild(manageLayoutsMenu);
            CustomizationButton manageLayoutsButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.layouts.manage", (String[])new String[0]), true, press -> {
                manageLayoutsMenu.setParentButton((AdvancedButton)press);
                manageLayoutsMenu.openMenuAt((AbstractWidget)press);
            });
            manageLayoutsButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.layouts.manage.desc", (String[])new String[0]), (String)"%n%"));
            layoutsMenu.addContent(manageLayoutsButton);
            CustomizationButton layoutsButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.layouts", (String[])new String[0]), true, press -> {
                layoutsMenu.setParentButton((AdvancedButton)press);
                layoutsMenu.openMenuAt(0, press.f_93621_);
            });
            if (!MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_)) {
                layoutsButton.f_93623_ = false;
            }
            layoutsButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.layouts.desc", (String[])new String[0]), (String)"%n%"));
            currentMenu.addContent(layoutsButton);
            FMContextMenu advancedMenu = new FMContextMenu();
            advancedMenu.setAutoclose(true);
            currentMenu.addChild(advancedMenu);
            OverrideMenuContextMenu overrideMenu = new OverrideMenuContextMenu();
            overrideMenu.setAutoclose(true);
            advancedMenu.addChild(overrideMenu);
            String overrLabel = Locals.localize((String)"helper.buttons.tools.overridemenu", (String[])new String[0]);
            if (CustomizationHelper.isScreenOverridden(Minecraft.m_91087_().f_91080_)) {
                overrLabel = Locals.localize((String)"helper.buttons.tools.resetoverride", (String[])new String[0]);
            }
            CustomizationButton overrideButton = new CustomizationButton(0, 0, 0, 0, overrLabel, true, press -> {
                if (!CustomizationHelper.isScreenOverridden(Minecraft.m_91087_().f_91080_)) {
                    overrideMenu.setParentButton((AdvancedButton)press);
                    overrideMenu.openMenuAt(0, press.f_93621_);
                } else {
                    for (String s : FileUtils.getFiles((String)FancyMenu.getCustomizationPath().getPath())) {
                        PropertiesSet props = PropertiesSerializer.getProperties((String)s);
                        if (props == null) continue;
                        PropertiesSet props2 = new PropertiesSet(props.getPropertiesType());
                        List l = props.getProperties();
                        ArrayList<PropertiesSection> l2 = new ArrayList<PropertiesSection>();
                        boolean b = false;
                        List metas = props.getPropertiesOfType("customization-meta");
                        if (metas == null || metas.isEmpty()) {
                            metas = props.getPropertiesOfType("type-meta");
                        }
                        if (metas == null || metas.isEmpty()) continue;
                        String identifier = ((PropertiesSection)metas.get(0)).getEntryValue("identifier");
                        Screen overridden = ((CustomGuiBase)Minecraft.m_91087_().f_91080_).getOverriddenScreen();
                        if (identifier == null || !identifier.equalsIgnoreCase(overridden.getClass().getName())) continue;
                        for (PropertiesSection sec : l) {
                            String action = sec.getEntryValue("action");
                            if (sec.getSectionType().equalsIgnoreCase("customization-meta") || sec.getSectionType().equalsIgnoreCase("type-meta")) {
                                l2.add(sec);
                                continue;
                            }
                            if (action != null && !action.equalsIgnoreCase("overridemenu")) {
                                l2.add(sec);
                            }
                            if (action == null || !action.equalsIgnoreCase("overridemenu")) continue;
                            b = true;
                        }
                        if (!b) continue;
                        File f = new File(s);
                        if (f.exists() && f.isFile()) {
                            f.delete();
                        }
                        if (l2.size() <= 1) continue;
                        for (PropertiesSection sec : l2) {
                            props2.addProperties(sec);
                        }
                        PropertiesSerializer.writeProperties((PropertiesSet)props2, (String)s);
                    }
                    CustomizationHelper.reloadSystemAndMenu();
                    if (Minecraft.m_91087_().f_91080_ instanceof CustomGuiBase) {
                        Minecraft.m_91087_().m_91152_(((CustomGuiBase)Minecraft.m_91087_().f_91080_).getOverriddenScreen());
                    }
                }
            });
            overrideButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.overridewith.btndesc", (String[])new String[0]), (String)"%n%"));
            if (!(Minecraft.m_91087_().f_91080_ instanceof CustomGuiBase)) {
                advancedMenu.addContent(overrideButton);
            } else if (((CustomGuiBase)Minecraft.m_91087_().f_91080_).getOverriddenScreen() != null) {
                advancedMenu.addContent(overrideButton);
            }
            CustomizationButton advancedButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.advanced", (String[])new String[0]), true, press -> {
                advancedMenu.setParentButton((AdvancedButton)press);
                advancedMenu.openMenuAt(0, press.f_93621_);
            });
            if (!MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_)) {
                advancedButton.f_93623_ = false;
            }
            advancedButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.advanced.desc", (String[])new String[0]), (String)"%n%"));
            if (((Boolean)FancyMenu.config.getOrDefault("advancedmode", (Object)false)).booleanValue()) {
                currentMenu.addContent(advancedButton);
            }
            CustomizationButton closeCustomGuiButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.misc.closegui", (String[])new String[0]), true, press -> Minecraft.m_91087_().m_91152_(null));
            closeCustomGuiButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.misc.closegui.desc", (String[])new String[0]), (String)"%n%"));
            if (Minecraft.m_91087_().f_91080_ instanceof CustomGuiBase && ((CustomGuiBase)Minecraft.m_91087_().f_91080_).getOverriddenScreen() == null) {
                currentMenu.addContent(closeCustomGuiButton);
            }
            CustomizationButton currentTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current", (String[])new String[0]), true, press -> {
                currentMenu.setParentButton((AdvancedButton)press);
                currentMenu.openMenuAt(press.f_93620_, press.f_93621_ + press.m_93694_());
            });
            bar.addElement(currentTab, "fm.ui.tab.current", MenuBar.ElementAlignment.LEFT, false);
            FMContextMenu universalLayoutsMenu = new FMContextMenu();
            universalLayoutsMenu.setAutoclose(true);
            bar.addChild(universalLayoutsMenu, "fm.ui.tab.universal_layouts", MenuBar.ElementAlignment.LEFT);
            CustomizationButton newUniversalLayoutButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.universal_layouts.new", (String[])new String[0]), true, press -> {
                LayoutEditorScreen.isActive = true;
                Minecraft.m_91087_().m_91152_((Screen)new LayoutEditorScreen(new CustomGuiBase("", "%fancymenu:universal_layout%", true, Minecraft.m_91087_().f_91080_, null)));
                MenuCustomization.stopSounds();
                MenuCustomization.resetSounds();
                for (IAnimationRenderer r : AnimationHandler.getAnimations()) {
                    if (!(r instanceof AdvancedAnimation)) continue;
                    ((AdvancedAnimation)r).stopAudio();
                    if (!((AdvancedAnimation)r).replayIntro()) continue;
                    r.resetAnimation();
                }
            });
            universalLayoutsMenu.addContent(newUniversalLayoutButton);
            ManageLayoutsContextMenu manageUniversalLayoutsMenu = new ManageLayoutsContextMenu(true);
            manageUniversalLayoutsMenu.setAutoclose(true);
            universalLayoutsMenu.addChild(manageUniversalLayoutsMenu);
            CustomizationButton manageUniversalLayoutsButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.universal_layouts.manage", (String[])new String[0]), true, press -> {
                manageUniversalLayoutsMenu.setParentButton((AdvancedButton)press);
                manageUniversalLayoutsMenu.openMenuAt((AbstractWidget)press);
            });
            universalLayoutsMenu.addContent(manageUniversalLayoutsButton);
            CustomizationButton universalLayoutsTabButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.universal_layouts", (String[])new String[0]), true, press -> {
                universalLayoutsMenu.setParentButton((AdvancedButton)press);
                universalLayoutsMenu.openMenuAt(press.f_93620_, press.f_93621_ + press.m_93694_());
            });
            universalLayoutsTabButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.universal_layouts.btn.desc", (String[])new String[0]), (String)"%n%"));
            bar.addElement(universalLayoutsTabButton, "fm.ui.tab.universal_layouts", MenuBar.ElementAlignment.LEFT, false);
            FMContextMenu setupMenu = new FMContextMenu();
            setupMenu.setAutoclose(true);
            bar.addChild(setupMenu, "fm.ui.tab.setup_import_export", MenuBar.ElementAlignment.LEFT);
            CustomizationButton setupTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.setup", (String[])new String[0]), true, press -> {
                setupMenu.setParentButton((AdvancedButton)press);
                setupMenu.openMenuAt(press.f_93620_, press.f_93621_ + press.m_93694_());
            });
            bar.addElement(setupTab, "fm.ui.tab.setup_import_export", MenuBar.ElementAlignment.LEFT, false);
            CustomizationButton exportSetupButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.setup.export", (String[])new String[0]), true, press -> SetupSharingEngine.exportSetup());
            exportSetupButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.setup.export.btn.desc", (String[])new String[0]), (String)"%n%"));
            setupMenu.addContent(exportSetupButton);
            FMContextMenu importMenu = new FMContextMenu();
            importMenu.setAutoclose(true);
            setupMenu.addChild(importMenu);
            CustomizationButton importSetupButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.setup.import", (String[])new String[0]), true, press -> {
                importMenu.setParentButton((AdvancedButton)press);
                importMenu.openMenuAt(0, press.f_93621_);
            });
            importSetupButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.setup.import.btn.desc", (String[])new String[0]), (String)"%n%"));
            setupMenu.addContent(importSetupButton);
            CustomizationButton chooseFromSavedButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved", (String[])new String[0]), true, press -> SetupSharingEngine.importSetupFromSavedSetups());
            chooseFromSavedButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.btn.desc", (String[])new String[0]), (String)"%n%"));
            importMenu.addContent(chooseFromSavedButton);
            CustomizationButton enterPathButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefrompath", (String[])new String[0]), true, press -> SetupSharingEngine.importSetup());
            enterPathButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefrompath.btn.desc", (String[])new String[0]), (String)"%n%"));
            importMenu.addContent(enterPathButton);
            FMContextMenu restoreMenu = new FMContextMenu();
            restoreMenu.setAutoclose(true);
            setupMenu.addChild(restoreMenu);
            CustomizationButton restoreButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.setup.restore", (String[])new String[0]), true, press -> {
                restoreMenu.setParentButton((AdvancedButton)press);
                restoreMenu.openMenuAt(0, press.f_93621_);
            });
            restoreButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.setup.restore.btn.desc", (String[])new String[0]), (String)"%n%"));
            setupMenu.addContent(restoreButton);
            try {
                File[] backupsSorted;
                File backups = SetupSharingEngine.SETUP_BACKUP_DIR;
                backups.mkdirs();
                boolean hasContent = false;
                for (File f : backupsSorted = SetupSharingEngine.sortByDateModified(backups.listFiles())) {
                    if (!SetupSharingEngine.isValidSetup(f.getPath())) continue;
                    String btnName = "Backup";
                    try {
                        LocalDateTime dt = LocalDateTime.ofInstant(Instant.ofEpochMilli(f.lastModified()), ZoneId.systemDefault());
                        DateTimeFormatter dtf = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
                        dtf.withZone(ZoneId.systemDefault());
                        dtf.withLocale(Locale.getDefault());
                        btnName = dt.format(dtf);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                    CustomizationButton backupEntryButton = new CustomizationButton(0, 0, 0, 0, btnName, true, press -> {
                        FMYesNoPopup backupConfirmPop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                            if (call.booleanValue()) {
                                new Thread(() -> {
                                    SetupSharingEngine.StatusPopup restoreBlockerPopup = new SetupSharingEngine.StatusPopup(Locals.localize((String)"fancymenu.helper.setupsharing.restore.restoring", (String[])new String[0]));
                                    PopupHandler.displayPopup((Popup)restoreBlockerPopup);
                                    try {
                                        File backupInstance;
                                        File config;
                                        try {
                                            File fmFolder = FancyMenu.MOD_DIR;
                                            if (fmFolder.isDirectory()) {
                                                org.apache.commons.io.FileUtils.deleteDirectory((File)fmFolder);
                                            }
                                        }
                                        catch (Exception e2) {
                                            e2.printStackTrace();
                                        }
                                        File homeRaw = Minecraft.m_91087_().f_91069_;
                                        File home = new File(homeRaw.getAbsolutePath().replace("\\", "/"));
                                        if (home.isDirectory() && (config = new File(home.getPath() + "/config")).isDirectory() && (backupInstance = new File(f.getPath() + "/setup")).isDirectory()) {
                                            org.apache.commons.io.FileUtils.copyDirectory((File)backupInstance, (File)home);
                                            FMNotificationPopup pop = new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, () -> CustomizationHelper.reloadSystemAndMenu(), Locals.localize((String)"fancymenu.helper.setupsharing.restore.success", (String[])new String[0]));
                                            PopupHandler.displayPopup((Popup)pop);
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        FMYesNoPopup pop = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call2 -> {
                                            if (call2.booleanValue()) {
                                                try {
                                                    CustomizationHelper.openFile(SetupSharingEngine.SETUP_BACKUP_DIR);
                                                }
                                                catch (Exception e3) {
                                                    e3.printStackTrace();
                                                }
                                            }
                                            CustomizationHelper.reloadSystemAndMenu();
                                        }, Locals.localize((String)"fancymenu.helper.setupsharing.restore.error", (String[])new String[0]));
                                        PopupHandler.displayPopup((Popup)pop);
                                    }
                                    restoreBlockerPopup.setDisplayed(false);
                                }).start();
                            }
                        }, Locals.localize((String)"fancymenu.helper.setupsharing.restore.confirm", (String[])new String[0]));
                        PopupHandler.displayPopup((Popup)backupConfirmPop);
                    });
                    backupEntryButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.setup.restore.entry.btn.desc", (String[])new String[0]), (String)"%n%"));
                    restoreMenu.addContent(backupEntryButton);
                    hasContent = true;
                }
                if (!hasContent) {
                    CustomizationButton emptyButton = new CustomizationButton(0, 0, 0, 0, "----------", true, press -> {});
                    restoreMenu.addContent(emptyButton);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            FMContextMenu customGuiMenu = new FMContextMenu();
            customGuiMenu.setAutoclose(true);
            bar.addChild(customGuiMenu, "fm.ui.tab.customguis", MenuBar.ElementAlignment.LEFT);
            CustomizationButton newCustomGuiButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.customguis.new", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                if (call.booleanValue()) {
                    PopupHandler.displayPopup((Popup)new CreateCustomGuiPopup());
                }
            }, Locals.localize((String)"helper.ui.customguis.new.sure", (String[])new String[0]))));
            newCustomGuiButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.customguis.new.desc", (String[])new String[0]), (String)"%n%"));
            customGuiMenu.addContent(newCustomGuiButton);
            ManageCustomGuiContextMenu manageCustomGuiMenu = new ManageCustomGuiContextMenu();
            manageCustomGuiMenu.setAutoclose(true);
            customGuiMenu.addChild(manageCustomGuiMenu);
            CustomizationButton manageCustomGuiButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.customguis.manage", (String[])new String[0]), true, press -> {
                manageCustomGuiMenu.setParentButton((AdvancedButton)press);
                manageCustomGuiMenu.openMenuAt(0, press.f_93621_);
            });
            manageCustomGuiButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.customguis.manage.desc", (String[])new String[0]), (String)"%n%"));
            customGuiMenu.addContent(manageCustomGuiButton);
            CustomizationButton customGuiTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.customguis", (String[])new String[0]), true, press -> {
                customGuiMenu.setParentButton((AdvancedButton)press);
                customGuiMenu.openMenuAt(press.f_93620_, press.f_93621_ + press.m_93694_());
            });
            if (((Boolean)FancyMenu.config.getOrDefault("advancedmode", (Object)false)).booleanValue()) {
                bar.addElement(customGuiTab, "fm.ui.tab.customguis", MenuBar.ElementAlignment.LEFT, false);
            }
            FMContextMenu toolsMenu = new FMContextMenu();
            toolsMenu.setAutoclose(true);
            bar.addChild(toolsMenu, "fm.ui.tab.tools", MenuBar.ElementAlignment.LEFT);
            CustomizationButton menuInfoButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.tools.menuinfo.off", (String[])new String[0]), true, press -> {
                if (showMenuInfo) {
                    showMenuInfo = false;
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.ui.tools.menuinfo.off", (String[])new String[0]));
                } else {
                    showMenuInfo = true;
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.ui.tools.menuinfo.on", (String[])new String[0]));
                }
            });
            if (showMenuInfo) {
                menuInfoButton.setMessage(Locals.localize((String)"helper.ui.tools.menuinfo.on", (String[])new String[0]));
            }
            menuInfoButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.tools.menuinfo.desc", (String[])new String[0]), (String)"%n%"));
            toolsMenu.addContent(menuInfoButton);
            CustomizationButton buttonInfoButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.tools.buttoninfo.off", (String[])new String[0]), true, press -> {
                if (showButtonInfo) {
                    showButtonInfo = false;
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.ui.tools.buttoninfo.off", (String[])new String[0]));
                } else {
                    showButtonInfo = true;
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.ui.tools.buttoninfo.on", (String[])new String[0]));
                }
            }){

                public void m_6305_(PoseStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                    Screen current = Minecraft.m_91087_().f_91080_;
                    if (current != null && MenuCustomization.isMenuCustomizable(current)) {
                        this.f_93623_ = true;
                        this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.tools.buttoninfo.desc", (String[])new String[0]), (String)"%n%"));
                    } else {
                        this.f_93623_ = false;
                        this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.tools.buttoninfo.enablecustomizations", (String[])new String[0]), (String)"%n%"));
                    }
                    super.m_6305_(p_93657_, p_93658_, p_93659_, p_93660_);
                }
            };
            if (showButtonInfo) {
                buttonInfoButton.setMessage(Locals.localize((String)"helper.ui.tools.buttoninfo.on", (String[])new String[0]));
            }
            toolsMenu.addContent(buttonInfoButton);
            CustomizationButton clearVariablesButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.tools.clear_variables", (String[])new String[0]), true, press -> {
                FMYesNoPopup p = new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                    if (call.booleanValue()) {
                        VariableHandler.clearVariables();
                    }
                }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.tools.clear_variables.confirm", (String[])new String[0]), (String)"%n%"));
                PopupHandler.displayPopup((Popup)p);
            });
            clearVariablesButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.tools.clear_variables.desc", (String[])new String[0]), (String)"%n%"));
            toolsMenu.addContent(clearVariablesButton);
            CustomizationButton toolsTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.tools", (String[])new String[0]), true, press -> {
                toolsMenu.setParentButton((AdvancedButton)press);
                toolsMenu.openMenuAt(press.f_93620_, press.f_93621_ + press.m_93694_());
            });
            bar.addElement(toolsTab, "fm.ui.tab.tools", MenuBar.ElementAlignment.LEFT, false);
            FMContextMenu miscMenu = new FMContextMenu();
            miscMenu.setAutoclose(true);
            bar.addChild(miscMenu, "fm.ui.tab.misc", MenuBar.ElementAlignment.LEFT);
            CustomizationButton closeGuiButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.misc.closegui", (String[])new String[0]), true, press -> Minecraft.m_91087_().m_91152_(null));
            closeGuiButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.misc.closegui.desc", (String[])new String[0]), (String)"%n%"));
            miscMenu.addContent(closeGuiButton);
            CustomizationButton openWorldLoadingScreenButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.misc.openworldloading", (String[])new String[0]), true, press -> {
                LevelLoadingScreen wl = new LevelLoadingScreen(new StoringChunkProgressListener(0));
                Minecraft.m_91087_().m_91152_((Screen)wl);
            });
            openWorldLoadingScreenButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.misc.openworldloading.desc", (String[])new String[0]), (String)"%n%"));
            miscMenu.addContent(openWorldLoadingScreenButton);
            CustomizationButton openMessageScreenButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.misc.openmessagescreen", (String[])new String[0]), true, press -> Minecraft.m_91087_().m_91152_((Screen)new GenericDirtMessageScreen((Component)Component.m_237113_((String)"hello \u30fb\u03c9\u30fb"))));
            openMessageScreenButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.misc.openmessagescreen.desc", (String[])new String[0]), (String)"%n%"));
            miscMenu.addContent(openMessageScreenButton);
            CustomizationButton openProgressScreenButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.misc.open_progress_screen", (String[])new String[0]), true, press -> {
                ProgressScreen s = new ProgressScreen(false);
                s.m_6307_((Component)Component.m_237113_((String)"dummy stage name"));
                s.m_6952_(50);
                Minecraft.m_91087_().m_91152_((Screen)s);
            });
            openProgressScreenButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.misc.open_progress_screen.btn.desc", (String[])new String[0]), (String)"%n%"));
            miscMenu.addContent(openProgressScreenButton);
            CustomizationButton openReceivingLevelScreenButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.misc.receiving_level_screen", (String[])new String[0]), true, press -> {
                ReceivingLevelScreen s = new ReceivingLevelScreen();
                Minecraft.m_91087_().m_91152_((Screen)s);
            }){

                public void m_6305_(PoseStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                    this.f_93623_ = Minecraft.m_91087_().f_91073_ == null;
                    super.m_6305_(p_93657_, p_93658_, p_93659_, p_93660_);
                }
            };
            openReceivingLevelScreenButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.misc.receiving_level_screen.btn.desc", (String[])new String[0]), (String)"%n%"));
            miscMenu.addContent(openReceivingLevelScreenButton);
            CustomizationButton openConnectScreenButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.helper.ui.misc.open_connect_screen", (String[])new String[0]), true, press -> ConnectScreen.m_169267_((Screen)new TitleScreen(), (Minecraft)Minecraft.m_91087_(), (ServerAddress)new ServerAddress("%fancymenu_dummy_address%", 25565), null)){

                public void m_6305_(PoseStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                    this.f_93623_ = Minecraft.m_91087_().f_91073_ == null;
                    super.m_6305_(p_93657_, p_93658_, p_93659_, p_93660_);
                }
            };
            openConnectScreenButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.ui.misc.open_connect_screen.btn.desc", (String[])new String[0]), (String)"%n%"));
            miscMenu.addContent(openConnectScreenButton);
            CustomizationButton miscTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.misc", (String[])new String[0]), true, press -> {
                miscMenu.setParentButton((AdvancedButton)press);
                miscMenu.openMenuAt(press.f_93620_, press.f_93621_ + press.m_93694_());
            });
            bar.addElement(miscTab, "fm.ui.tab.misc", MenuBar.ElementAlignment.LEFT, false);
            AdvancedImageButton closeGuiButtonTab = new AdvancedImageButton(20, 20, 20, 20, CLOSE_BUTTON_TEXTURE, true, press -> Minecraft.m_91087_().m_91152_(null)){

                public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
                    this.f_93618_ = this.f_93619_;
                    super.m_6305_(matrix, mouseX, mouseY, partialTicks);
                }
            };
            closeGuiButtonTab.ignoreLeftMouseDownClickBlock = true;
            closeGuiButtonTab.ignoreBlockedInput = true;
            closeGuiButtonTab.enableRightclick = true;
            closeGuiButtonTab.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.misc.closegui.desc", (String[])new String[0]), (String)"%n%"));
            bar.addElement((AdvancedButton)closeGuiButtonTab, "fm.ui.tab.closegui", MenuBar.ElementAlignment.RIGHT, false);
            AdvancedImageButton reloadButtonTab = new AdvancedImageButton(20, 20, 20, 20, RELOAD_BUTTON_TEXTURE, true, press -> CustomizationHelper.reloadSystemAndMenu()){

                public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
                    this.f_93618_ = this.f_93619_;
                    super.m_6305_(matrix, mouseX, mouseY, partialTicks);
                }
            };
            reloadButtonTab.ignoreLeftMouseDownClickBlock = true;
            reloadButtonTab.ignoreBlockedInput = true;
            reloadButtonTab.enableRightclick = true;
            reloadButtonTab.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.reload.desc", (String[])new String[0]), (String)"%n%"));
            bar.addElement((AdvancedButton)reloadButtonTab, "fm.ui.tab.reload", MenuBar.ElementAlignment.RIGHT, false);
            AdvancedButton expandButton = bar.getElement("menubar.default.extendbtn");
            if (expandButton != null && expandButton instanceof AdvancedImageButton && !extended) {
                ((AdvancedImageButton)expandButton).setImage(MenuBar.EXPAND_BTN_TEXTURE);
                expandButton.setDescription(new String[]{Locals.localize((String)"helper.menubar.expand", (String[])new String[0])});
            }
            bar.setExtended(extended);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void render(PoseStack matrix, Screen screen) {
        try {
            if (bar != null && !PopupHandler.isPopupActive() && ((Boolean)FancyMenu.config.getOrDefault("showcustomizationbuttons", (Object)true)).booleanValue() && !(screen instanceof LayoutEditorScreen) && !(screen instanceof ConfigScreen) && !(screen instanceof GameIntroScreen) && AnimationHandler.isReady() && MenuCustomization.isValidScreen(screen)) {
                RenderUtils.setZLevelPre((PoseStack)matrix, (int)400);
                CustomizationHelperUI.renderMenuInfo(matrix, screen);
                CustomizationHelperUI.renderUnicodeWarning(matrix, screen);
                CustomizationHelperUI.renderButtonInfo(matrix, screen);
                CustomizationHelperUI.renderButtonInfoWarning(matrix, screen);
                RenderUtils.setZLevelPost((PoseStack)matrix);
                bar.render(matrix, screen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void renderButtonInfo(PoseStack matrix, Screen screen) {
        if (showButtonInfo) {
            boolean isButtonHovered = false;
            for (ButtonData d : buttons) {
                void var14_17;
                String key;
                if (!d.getButton().m_198029_()) continue;
                isButtonHovered = true;
                long id = d.getId();
                String idString = Locals.localize((String)"helper.buttoninfo.idnotfound", (String[])new String[0]);
                if (id >= 0L) {
                    idString = String.valueOf(id);
                }
                if (d.getCompatibilityId() != null) {
                    idString = d.getCompatibilityId();
                }
                if ((key = ButtonCache.getKeyForButton(d.getButton())) == null) {
                    key = Locals.localize((String)"helper.buttoninfo.keynotfound", (String[])new String[0]);
                }
                ArrayList<Object> info = new ArrayList<Object>();
                int width = Minecraft.m_91087_().f_91062_.m_92895_(Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0])) + 10;
                long now = System.currentTimeMillis();
                info.add("\u00a7f" + Locals.localize((String)"helper.buttoninfo.id", (String[])new String[0]) + ": " + idString);
                info.add("\u00a7f" + Locals.localize((String)"general.width", (String[])new String[0]) + ": " + d.getButton().m_5711_());
                info.add("\u00a7f" + Locals.localize((String)"general.height", (String[])new String[0]) + ": " + d.getButton().m_93694_());
                info.add("\u00a7f" + Locals.localize((String)"helper.buttoninfo.labelwidth", (String[])new String[0]) + ": " + Minecraft.m_91087_().f_91062_.m_92895_(d.getButton().m_6035_().getString()));
                info.add("");
                if (lastButtonInfoRightClick + 2000L < now) {
                    info.add(Locals.localize((String)"fancymenu.helper.button_info.copy_locator", (String[])new String[0]));
                } else {
                    info.add(Locals.localize((String)"fancymenu.helper.button_info.copy_locator.copied", (String[])new String[0]));
                }
                if (MouseInput.isRightMouseDown()) {
                    Screen current = Minecraft.m_91087_().f_91080_;
                    String string = current.getClass().getName() + ":" + idString;
                    Minecraft.m_91087_().f_91068_.m_90911_(string);
                    lastButtonInfoRightClick = now;
                }
                for (String string : info) {
                    int i = Minecraft.m_91087_().f_91062_.m_92895_(string) + 10;
                    if (i <= width) continue;
                    width = i;
                }
                matrix.m_85836_();
                matrix.m_85841_(CustomizationHelperUI.getUIScale(), CustomizationHelperUI.getUIScale(), CustomizationHelperUI.getUIScale());
                MouseInput.setRenderScale((float)CustomizationHelperUI.getUIScale());
                int x = MouseInput.getMouseX();
                if ((float)screen.f_96543_ / CustomizationHelperUI.getUIScale() < (float)(x + width + 10)) {
                    x -= width + 10;
                }
                int n = MouseInput.getMouseY();
                if ((float)screen.f_96544_ / CustomizationHelperUI.getUIScale() < (float)(n + 80)) {
                    var14_17 -= 90;
                }
                CustomizationHelperUI.m_93172_((PoseStack)matrix, (int)x, (int)var14_17, (int)(x + width + 10), (int)(var14_17 + 100), (int)new Color(102, 0, 102, 200).getRGB());
                RenderSystem.m_69478_();
                CustomizationHelperUI.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)("\u00a7f\u00a7l" + Locals.localize((String)"helper.button.buttoninfo", (String[])new String[0])), (int)(x + 10), (int)(var14_17 + 10), (int)-1);
                int i2 = 20;
                for (String string : info) {
                    CustomizationHelperUI.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)string, (int)(x + 10), (int)(var14_17 + 10 + i2), (int)-1);
                    i2 += 10;
                }
                MouseInput.resetRenderScale();
                matrix.m_85849_();
                RenderSystem.m_69461_();
                break;
            }
            if (!isButtonHovered) {
                lastButtonInfoRightClick = 0L;
            }
        }
    }

    protected static void renderButtonInfoWarning(PoseStack matrix, Screen screen) {
        if (showButtonInfo && !MenuCustomization.isMenuCustomizable(screen)) {
            ArrayList<String> info = new ArrayList<String>();
            int width = Minecraft.m_91087_().f_91062_.m_92895_(Locals.localize((String)"fancymenu.helper.ui.tools.buttoninfo.enablecustomizations.cursorwarning.line1", (String[])new String[0])) + 10;
            info.add(Locals.localize((String)"fancymenu.helper.ui.tools.buttoninfo.enablecustomizations.cursorwarning.line2", (String[])new String[0]));
            info.add(Locals.localize((String)"fancymenu.helper.ui.tools.buttoninfo.enablecustomizations.cursorwarning.line3", (String[])new String[0]));
            for (String s : info) {
                int i = Minecraft.m_91087_().f_91062_.m_92895_(s) + 10;
                if (i <= width) continue;
                width = i;
            }
            matrix.m_85836_();
            matrix.m_85841_(CustomizationHelperUI.getUIScale(), CustomizationHelperUI.getUIScale(), CustomizationHelperUI.getUIScale());
            MouseInput.setRenderScale((float)CustomizationHelperUI.getUIScale());
            int x = MouseInput.getMouseX();
            if ((float)screen.f_96543_ / CustomizationHelperUI.getUIScale() < (float)(x + width + 10)) {
                x -= width + 10;
            }
            int y = MouseInput.getMouseY();
            if ((float)screen.f_96544_ / CustomizationHelperUI.getUIScale() < (float)(y + 80)) {
                y -= 90;
            }
            CustomizationHelperUI.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + width + 10), (int)(y + 60), (int)new Color(230, 15, 0, 240).getRGB());
            RenderSystem.m_69478_();
            CustomizationHelperUI.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)("\u00a7f\u00a7l" + Locals.localize((String)"fancymenu.helper.ui.tools.buttoninfo.enablecustomizations.cursorwarning.line1", (String[])new String[0])), (int)(x + 10), (int)(y + 10), (int)-1);
            int i2 = 20;
            for (String s : info) {
                CustomizationHelperUI.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)s, (int)(x + 10), (int)(y + 10 + i2), (int)-1);
                i2 += 10;
            }
            MouseInput.resetRenderScale();
            matrix.m_85849_();
            RenderSystem.m_69461_();
        }
    }

    protected static void renderMenuInfo(PoseStack matrix, Screen screen) {
        if (showMenuInfo) {
            String infoTitle = "\u00a7f\u00a7l" + Locals.localize((String)"helper.menuinfo.identifier", (String[])new String[0]) + ":";
            String id = "";
            id = screen instanceof CustomGuiBase ? ((CustomGuiBase)screen).getIdentifier() : screen.getClass().getName();
            int w = Minecraft.m_91087_().f_91062_.m_92895_(infoTitle);
            int w2 = Minecraft.m_91087_().f_91062_.m_92895_(id);
            if (w2 > w) {
                w = w2;
            }
            int h = bar.getHeight() + 5;
            RenderSystem.m_69478_();
            matrix.m_85836_();
            matrix.m_85841_(CustomizationHelperUI.getUIScale(), CustomizationHelperUI.getUIScale(), CustomizationHelperUI.getUIScale());
            CustomizationHelperUI.m_93172_((PoseStack)matrix, (int)3, (int)h, (int)(3 + w + 4), (int)(h + 23), (int)new Color(0, 0, 0, 240).getRGB());
            CustomizationHelperUI.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)infoTitle, (int)5, (int)(h + 2), (int)0);
            if (tick == 0) {
                CustomizationHelperUI.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)("\u00a7f" + id), (int)5, (int)(h + 13), (int)0);
            } else {
                CustomizationHelperUI.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)("\u00a7a" + Locals.localize((String)"helper.menuinfo.idcopied", (String[])new String[0])), (int)5, (int)(h + 13), (int)0);
            }
            MouseInput.setRenderScale((float)CustomizationHelperUI.getUIScale());
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            if (!bar.isChildOpen() && mouseX >= 5 && mouseX <= 5 + w2 && mouseY >= h + 13 && mouseY <= h + 13 + 10 && tick == 0) {
                CustomizationHelperUI.m_93172_((PoseStack)matrix, (int)5, (int)(h + 13 + 10 - 1), (int)(5 + w2), (int)(h + 13 + 10), (int)-1);
                if (MouseInput.isLeftMouseDown()) {
                    ++tick;
                    Minecraft.m_91087_().f_91068_.m_90911_(id);
                }
            }
            if (tick > 0) {
                tick = tick < 60 ? ++tick : 0;
            }
            MouseInput.resetRenderScale();
            matrix.m_85849_();
            RenderSystem.m_69461_();
        }
    }

    protected static void renderUnicodeWarning(PoseStack matrix, Screen screen) {
        if (!((Boolean)FancyMenu.config.getOrDefault("show_unicode_warning", (Object)true)).booleanValue()) {
            return;
        }
        if (((Boolean)Minecraft.m_91087_().f_91066_.m_231819_().m_231551_()).booleanValue()) {
            String[] lines;
            String title = Locals.localize((String)"helper.ui.warning", (String[])new String[0]);
            int w = Minecraft.m_91087_().f_91062_.m_92895_(title);
            for (String s : lines = StringUtils.splitLines((String)Locals.localize((String)"helper.ui.warning.unicode", (String[])new String[0]), (String)"%n%")) {
                int w2 = Minecraft.m_91087_().f_91062_.m_92895_(s);
                if (w2 <= w) continue;
                w = w2;
            }
            int x = screen.f_96543_ - w - 5;
            int y = (int)((float)(bar.getHeight() + 5) * UIBase.getUIScale());
            RenderSystem.m_69478_();
            int h = 13;
            if (lines.length > 0) {
                h += 10 * lines.length;
            }
            CustomizationHelperUI.m_93172_((PoseStack)matrix, (int)(x - 4), (int)y, (int)(x + w + 2), (int)(y + h), (int)new Color(230, 15, 0, 240).getRGB());
            CustomizationHelperUI.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)title, (int)x, (int)(y + 2), (int)Color.WHITE.getRGB());
            int i = 0;
            for (String s : lines) {
                CustomizationHelperUI.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)s, (int)x, (int)(y + 13 + i), (int)Color.WHITE.getRGB());
                i += 10;
            }
            RenderSystem.m_69461_();
        }
    }

    @SubscribeEvent
    public void onButtonsCached(ButtonCachedEvent e) {
        buttons = e.getButtonDataList();
    }

    @SubscribeEvent
    public void onInitScreen(ScreenEvent.Init.Pre e) {
        try {
            if (e.getScreen() != null && ((Boolean)FancyMenu.config.getOrDefault("showcustomizationbuttons", (Object)true)).booleanValue()) {
                CustomizationHelperUI.updateUI();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void onOverrideWithCustomGui(Screen current, String customGuiIdentifier) {
        if (customGuiIdentifier != null && CustomGuiLoader.guiExists(customGuiIdentifier)) {
            PropertiesSection meta = new PropertiesSection("customization-meta");
            meta.addEntry("identifier", current.getClass().getName());
            PropertiesSection or = new PropertiesSection("customization");
            or.addEntry("action", "overridemenu");
            or.addEntry("identifier", customGuiIdentifier);
            PropertiesSet props = new PropertiesSet("menu");
            props.addProperties(meta);
            props.addProperties(or);
            String screenname = current.getClass().getName();
            if (screenname.contains(".")) {
                screenname = new StringBuilder(new StringBuilder(screenname).reverse().toString().split("[.]", 2)[0]).reverse().toString();
            }
            String filename = FileUtils.generateAvailableFilename((String)FancyMenu.getCustomizationPath().getPath(), (String)("overridemenu_" + screenname), (String)"txt");
            String finalpath = FancyMenu.getCustomizationPath().getPath() + "/" + filename;
            PropertiesSerializer.writeProperties((PropertiesSet)props, (String)finalpath);
            CustomizationHelper.reloadSystemAndMenu();
        }
    }

    static {
        showButtonInfo = false;
        showMenuInfo = false;
        buttons = new ArrayList<ButtonData>();
        tick = 0;
        lastButtonInfoRightClick = 0L;
        CLOSE_BUTTON_TEXTURE = new ResourceLocation("keksuccino", "close_btn.png");
        RELOAD_BUTTON_TEXTURE = new ResourceLocation("keksuccino", "/filechooser/back_icon.png");
    }

    private static class ManageLayoutsContextMenu
    extends FMContextMenu {
        private ManageLayoutsSubContextMenu manageSubPopup;
        private boolean isUniversal;

        public ManageLayoutsContextMenu(boolean isUniversal) {
            this.isUniversal = isUniversal;
            this.manageSubPopup = new ManageLayoutsSubContextMenu();
            this.addChild(this.manageSubPopup);
        }

        public void openMenuAt(AbstractWidget parentBtn) {
            PropertiesSection meta;
            Object sets;
            Object secs;
            PropertiesSection meta2;
            PropertiesSet s;
            Object sets2;
            this.content.clear();
            String identifier = Minecraft.m_91087_().f_91080_.getClass().getName();
            if (Minecraft.m_91087_().f_91080_ instanceof CustomGuiBase) {
                identifier = ((CustomGuiBase)Minecraft.m_91087_().f_91080_).getIdentifier();
            }
            if (this.isUniversal) {
                identifier = "%fancymenu:universal_layout%";
            }
            Object enabled = MenuCustomizationProperties.getPropertiesWithIdentifier(identifier);
            if (!this.isUniversal) {
                sets2 = new ArrayList();
                Iterator<PropertiesSet> iterator = enabled.iterator();
                while (iterator.hasNext()) {
                    String id;
                    s = iterator.next();
                    List metas = s.getPropertiesOfType("customization-meta");
                    if (metas.isEmpty() || (id = (meta2 = (PropertiesSection)metas.get(0)).getEntryValue("identifier")).equals("%fancymenu:universal_layout%")) continue;
                    sets2.add(s);
                }
                enabled = sets2;
            }
            if (!enabled.isEmpty()) {
                sets2 = enabled.iterator();
                while (sets2.hasNext()) {
                    PropertiesSet s2 = (PropertiesSet)sets2.next();
                    secs = s2.getPropertiesOfType("customization-meta");
                    if (secs.isEmpty()) {
                        secs = s2.getPropertiesOfType("type-meta");
                    }
                    if (secs.isEmpty()) continue;
                    String name = "<missing name>";
                    meta2 = (PropertiesSection)secs.get(0);
                    File f = new File(meta2.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s2.getProperties().size() - 1;
                    CustomizationButton layoutEntryBtn = new CustomizationButton(0, 0, 0, 0, "\u00a7a" + name, press -> {
                        this.manageSubPopup.setParentButton((AdvancedButton)press);
                        this.manageSubPopup.openMenuAt(0, press.f_93621_, f, false);
                    });
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"helper.buttons.customization.managelayouts.enabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            Object disabled = MenuCustomizationProperties.getDisabledPropertiesWithIdentifier(identifier);
            if (!this.isUniversal) {
                sets = new ArrayList();
                secs = disabled.iterator();
                while (secs.hasNext()) {
                    String id;
                    PropertiesSet s3 = (PropertiesSet)secs.next();
                    List metas = s3.getPropertiesOfType("customization-meta");
                    if (metas.isEmpty() || (id = (meta = (PropertiesSection)metas.get(0)).getEntryValue("identifier")).equals("%fancymenu:universal_layout%")) continue;
                    sets.add(s3);
                }
                disabled = sets;
            }
            if (!disabled.isEmpty()) {
                sets = disabled.iterator();
                while (sets.hasNext()) {
                    s = (PropertiesSet)sets.next();
                    List secs2 = s.getPropertiesOfType("customization-meta");
                    if (secs2.isEmpty()) {
                        secs2 = s.getPropertiesOfType("type-meta");
                    }
                    if (secs2.isEmpty()) continue;
                    String name = "<missing name>";
                    meta = (PropertiesSection)secs2.get(0);
                    File f = new File(meta.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s.getProperties().size() - 1;
                    CustomizationButton layoutEntryBtn = new CustomizationButton(0, 0, 0, 0, "\u00a7c" + name, press -> {
                        this.manageSubPopup.setParentButton((AdvancedButton)press);
                        this.manageSubPopup.openMenuAt(0, press.f_93621_, f, true);
                    });
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"helper.buttons.customization.managelayouts.disabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            if (enabled.isEmpty() && disabled.isEmpty()) {
                CustomizationButton emptyBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), press -> {});
                this.addContent(emptyBtn);
            }
            this.openMenuAt(parentBtn.f_93620_ - this.getWidth() - 2, parentBtn.f_93621_);
        }

        public void render(PoseStack matrix, int mouseX, int mouseY) {
            super.render(matrix, mouseX, mouseY);
            if (this.manageSubPopup != null) {
                this.manageSubPopup.render(matrix, mouseX, mouseY);
                if (!this.isOpen()) {
                    this.manageSubPopup.closeMenu();
                }
            }
        }

        public void closeMenu() {
            if (!this.manageSubPopup.isHoveredOrFocused()) {
                super.closeMenu();
            }
        }

        @Override
        public boolean isHoveredOrFocused() {
            if (this.manageSubPopup.isOpen() && this.manageSubPopup.isHoveredOrFocused()) {
                return true;
            }
            return super.isHoveredOrFocused();
        }
    }

    private static class OverrideMenuContextMenu
    extends FMContextMenu {
        private OverrideMenuContextMenu() {
        }

        public void openMenuAt(int x, int y) {
            this.content.clear();
            List<String> l = CustomGuiLoader.getCustomGuis();
            if (!l.isEmpty()) {
                this.addContent(new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.pickbyname", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new TextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.buttons.tools.customguis.pickbyname", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (CustomGuiLoader.guiExists(call)) {
                            CustomizationHelperUI.onOverrideWithCustomGui(Minecraft.m_91087_().f_91080_, call);
                        } else {
                            PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"helper.buttons.tools.customguis.invalididentifier", (String[])new String[0])));
                        }
                    }
                }))));
                this.addSeparator();
                for (String s : l) {
                    Object label = s;
                    if (Minecraft.m_91087_().f_91062_.m_92895_((String)label) > 80) {
                        label = Minecraft.m_91087_().f_91062_.m_92834_((String)label, 75) + "..";
                    }
                    this.addContent(new CustomizationButton(0, 0, 0, 0, (String)label, true, press -> CustomizationHelperUI.onOverrideWithCustomGui(Minecraft.m_91087_().f_91080_, s)));
                }
            } else {
                this.addContent(new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), true, press -> {}));
            }
            super.openMenuAt(x, y);
        }
    }

    private static class ManageCustomGuiContextMenu
    extends FMContextMenu {
        private ManageCustomGuiSubContextMenu manageMenu = new ManageCustomGuiSubContextMenu();

        public ManageCustomGuiContextMenu() {
            this.addChild(this.manageMenu);
        }

        public void openMenuAt(int x, int y) {
            this.content.clear();
            List<String> l = CustomGuiLoader.getCustomGuis();
            if (!l.isEmpty()) {
                this.addContent(new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.openbyname", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FMTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.buttons.tools.customguis.openbyname", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (CustomGuiLoader.guiExists(call)) {
                            Minecraft.m_91087_().m_91152_((Screen)CustomGuiLoader.getGui(call, Minecraft.m_91087_().f_91080_, null));
                        } else {
                            PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"helper.buttons.tools.customguis.invalididentifier", (String[])new String[0])));
                        }
                    }
                }))));
                this.addContent(new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.deletebyname", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FMTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.buttons.tools.customguis.deletebyname", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (CustomGuiLoader.guiExists(call)) {
                            PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call2 -> {
                                if (call2.booleanValue() && CustomGuiLoader.guiExists(call)) {
                                    ArrayList<File> delete = new ArrayList<File>();
                                    for (String s : FileUtils.getFiles((String)FancyMenu.getCustomGuiPath().getPath())) {
                                        File f = new File(s);
                                        for (String s2 : FileUtils.getFileLines((File)f)) {
                                            if (!s2.replace(" ", "").toLowerCase().equals("identifier=" + call)) continue;
                                            delete.add(f);
                                        }
                                    }
                                    for (File f : delete) {
                                        if (!f.isFile()) continue;
                                        f.delete();
                                    }
                                    CustomizationHelper.reloadSystemAndMenu();
                                }
                            }, Locals.localize((String)"helper.buttons.tools.customguis.sure", (String[])new String[0])));
                        } else {
                            PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"helper.buttons.tools.customguis.invalididentifier", (String[])new String[0])));
                        }
                    }
                }))));
                this.addSeparator();
                for (String s : l) {
                    Object label = s;
                    if (Minecraft.m_91087_().f_91062_.m_92895_((String)label) > 80) {
                        label = Minecraft.m_91087_().f_91062_.m_92834_((String)label, 75) + "..";
                    }
                    this.addContent(new CustomizationButton(0, 0, 0, 0, (String)label, true, press -> {
                        this.manageMenu.setParentButton((AdvancedButton)press);
                        this.manageMenu.openMenuAt(0, press.f_93621_, s);
                    }));
                }
            }
            super.openMenuAt(x, y);
        }
    }

    private static class ManageLayoutsSubContextMenu
    extends FMContextMenu {
        private ManageLayoutsSubContextMenu() {
        }

        public void openMenuAt(int x, int y, File layout, boolean disabled) {
            this.content.clear();
            String toggleLabel = Locals.localize((String)"helper.buttons.customization.managelayouts.disable", (String[])new String[0]);
            if (disabled) {
                toggleLabel = Locals.localize((String)"helper.buttons.customization.managelayouts.enable", (String[])new String[0]);
            }
            CustomizationButton toggleLayoutBtn = new CustomizationButton(0, 0, 0, 0, toggleLabel, press -> {
                if (disabled) {
                    String name = FileUtils.generateAvailableFilename((String)FancyMenu.getCustomizationPath().getPath(), (String)Files.getNameWithoutExtension((String)layout.getName()), (String)"txt");
                    FileUtils.copyFile((File)layout, (File)new File(FancyMenu.getCustomizationPath().getPath() + "/" + name));
                    layout.delete();
                } else {
                    String disPath = FancyMenu.getCustomizationPath().getPath() + "/.disabled";
                    String name = FileUtils.generateAvailableFilename((String)disPath, (String)Files.getNameWithoutExtension((String)layout.getName()), (String)"txt");
                    FileUtils.copyFile((File)layout, (File)new File(disPath + "/" + name));
                    layout.delete();
                }
                CustomizationHelper.reloadSystemAndMenu();
            });
            this.addContent(toggleLayoutBtn);
            CustomizationButton editLayoutBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.ui.current.layouts.manage.edit", (String[])new String[0]), press -> {
                Screen s = Minecraft.m_91087_().f_91080_;
                if (this.parent != null && this.parent instanceof ManageLayoutsContextMenu && ((ManageLayoutsContextMenu)this.parent).isUniversal) {
                    s = new CustomGuiBase("", "%fancymenu:universal_layout%", true, Minecraft.m_91087_().f_91080_, null);
                }
                CustomizationHelper.editLayout(s, layout);
            });
            editLayoutBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.current.layouts.manage.edit.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(editLayoutBtn);
            CustomizationButton openInTextEditorBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.customization.managelayouts.openintexteditor", (String[])new String[0]), press -> CustomizationHelper.openFile(layout));
            openInTextEditorBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.managelayouts.openintexteditor.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(openInTextEditorBtn);
            CustomizationButton deleteLayoutBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.customization.managelayouts.delete", (String[])new String[0]), press -> {
                PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                    if (call.booleanValue() && layout.exists()) {
                        layout.delete();
                        CustomizationHelper.reloadSystemAndMenu();
                    }
                }, Locals.localize((String)"helper.buttons.customization.managelayouts.delete.msg", (String[])new String[0]), "", "", "", ""));
                CustomizationHelper.reloadSystemAndMenu();
            });
            this.addContent(deleteLayoutBtn);
            this.openMenuAt(x, y);
        }
    }

    private static class ManageCustomGuiSubContextMenu
    extends FMContextMenu {
        private ManageCustomGuiSubContextMenu() {
        }

        public void openMenuAt(int x, int y, String customGuiIdentifier) {
            this.content.clear();
            CustomizationButton openMenuButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.open", (String[])new String[0]), press -> {
                if (CustomGuiLoader.guiExists(customGuiIdentifier)) {
                    Minecraft.m_91087_().m_91152_((Screen)CustomGuiLoader.getGui(customGuiIdentifier, Minecraft.m_91087_().f_91080_, null));
                }
            });
            this.addContent(openMenuButton);
            CustomizationButton deleteMenuButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.buttons.tools.customguis.delete", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                if (call.booleanValue() && CustomGuiLoader.guiExists(customGuiIdentifier)) {
                    ArrayList<File> delete = new ArrayList<File>();
                    for (String s : FileUtils.getFiles((String)FancyMenu.getCustomGuiPath().getPath())) {
                        File f = new File(s);
                        for (String s2 : FileUtils.getFileLines((File)f)) {
                            if (!s2.replace(" ", "").toLowerCase().equals("identifier=" + customGuiIdentifier)) continue;
                            delete.add(f);
                        }
                    }
                    for (File f : delete) {
                        if (!f.isFile()) continue;
                        f.delete();
                    }
                    CustomizationHelper.reloadSystemAndMenu();
                }
            }, Locals.localize((String)"helper.buttons.tools.customguis.sure", (String[])new String[0]))));
            this.addContent(deleteMenuButton);
            this.openMenuAt(x, y);
        }
    }
}

