/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unusualend.entity;

import net.mcreator.unusualend.init.UnusualendModEntities;
import net.mcreator.unusualend.init.UnusualendModItems;
import net.mcreator.unusualend.procedures.EndstoneGolemEntityDiesProcedure;
import net.mcreator.unusualend.procedures.EndstoneGolemEntityIsHurtProcedure;
import net.mcreator.unusualend.procedures.EndstoneGolemOnEntityTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class EndstoneGolemEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKACTIVE = SynchedEntityData.m_135353_(EndstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float clientAnimation;
    private float clientAnimation0;
    private static final float MAX_TICKS_ANIM = 30.0f;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKACTIVE, (Object)false);
    }

    public boolean isAttackActive() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKACTIVE);
    }

    public void setAttackActive(boolean standing) {
        this.f_19804_.m_135381_(ATTACKACTIVE, (Object)standing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackAnimationScale(float p_189795_1_) {
        return Mth.m_14179_((float)p_189795_1_, (float)this.clientAnimation0, (float)this.clientAnimation) / 30.0f;
    }

    public void m_8107_() {
        super.m_8107_();
        this.clientAnimation0 = this.clientAnimation;
        if (this.isAttackActive()) {
            this.clientAnimation = Mth.m_14036_((float)(this.clientAnimation + 1.0f), (float)0.0f, (float)30.0f);
            if (this.clientAnimation == 30.0f) {
                this.setAttackActive(false);
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.m_5496_(SoundEvents.f_12057_, 1.0f, 0.5f);
                this.roar();
            }
        } else {
            this.clientAnimation = Mth.m_14036_((float)(this.clientAnimation - 1.0f), (float)0.0f, (float)30.0f);
        }
    }

    private void roar() {
        if (this.m_6084_()) {
            for (LivingEntity entity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(4.0))) {
                if (entity == this || !entity.m_20096_() && !(this.f_19853_.m_8055_(entity.m_20183_()).m_60734_() instanceof LiquidBlock)) continue;
                this.setDisableShield(entity);
                EndstoneGolemEntity.hurtAndThrowTarget((LivingEntity)this, entity);
                this.f_19853_.m_46796_(2001, entity.m_20183_(), Block.m_49956_((BlockState)this.f_19853_.m_8055_(entity.m_20183_().m_7495_())));
            }
            for (LivingEntity entity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(2.0))) {
                if (entity == this) continue;
                this.setDisableShield(entity);
                this.m_7327_((Entity)entity);
            }
            Vec3 vector3d = this.m_146892_();
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel _lev = (ServerLevel)level;
                _lev.m_8767_((ParticleOptions)ParticleTypes.f_123810_, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 80, 0.0, 0.0, 0.0, 2.0);
            }
        }
    }

    static boolean hurtAndThrowTarget(LivingEntity p_34643_, LivingEntity p_34644_) {
        float f1 = (float)p_34643_.m_21133_(Attributes.f_22281_);
        float f = !p_34643_.m_6162_() && (int)f1 > 0 ? f1 / 2.0f + (float)p_34643_.f_19853_.f_46441_.m_188503_((int)f1) : f1;
        boolean flag = p_34644_.m_6469_(DamageSource.m_19370_((LivingEntity)p_34643_), f);
        if (flag) {
            p_34643_.m_19970_(p_34643_, (Entity)p_34644_);
            if (!p_34643_.m_6162_()) {
                EndstoneGolemEntity.throwTarget(p_34643_, p_34644_);
            }
        }
        return flag;
    }

    static void throwTarget(LivingEntity p_34646_, LivingEntity p_34647_) {
        double d1;
        double d0 = p_34646_.m_21133_(Attributes.f_22282_);
        double d2 = d0 - (d1 = p_34647_.m_21133_(Attributes.f_22278_));
        if (!(d2 <= 0.0)) {
            double d3 = p_34647_.m_20185_() - p_34646_.m_20185_();
            double d4 = p_34647_.m_20189_() - p_34646_.m_20189_();
            float f = p_34646_.f_19853_.f_46441_.m_188503_(21) - 10;
            double d5 = d2 * (double)(p_34646_.f_19853_.f_46441_.m_188501_() * 0.5f + 0.2f);
            Vec3 vec3 = new Vec3(d3, 0.0, d4).m_82541_().m_82490_(d5).m_82524_(f);
            double d6 = d2 * (double)p_34646_.f_19853_.f_46441_.m_188501_() * 0.5;
            p_34647_.m_5997_(vec3.f_82479_, d6, vec3.f_82481_);
            p_34647_.f_19864_ = true;
        }
    }

    public void setDisableShield(LivingEntity entity) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            p.m_36384_(true);
        }
    }

    protected void m_21203_() {
        int i = 60;
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }

    public EndstoneGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<EndstoneGolemEntity>)((EntityType)UnusualendModEntities.ENDSTONE_GOLEM.get()), world);
    }

    public EndstoneGolemEntity(EntityType<EndstoneGolemEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 5000;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_() * entity.m_20205_();
            }

            public void m_8037_() {
                if (this.f_25540_.f_20911_) {
                    this.f_25540_.m_21573_().m_26573_();
                    LivingEntity livingentity = this.f_25540_.m_5448_();
                    this.f_25540_.m_21391_((Entity)livingentity, 45.0f, 45.0f);
                } else {
                    super.m_8037_();
                }
            }

            protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
                double d0 = this.m_6639_(p_25557_);
                if (p_25558_ <= d0 * 5.0 && this.m_25564_() && !EndstoneGolemEntity.this.isAttackActive() && EndstoneGolemEntity.this.clientAnimation < 2.0f) {
                    this.f_25540_.m_5496_(SoundEvents.f_12616_, 2.0f, 1.0f);
                    this.m_25563_();
                    EndstoneGolemEntity.this.setAttackActive(true);
                }
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)UnusualendModItems.SHULKER_ORB.get()));
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.elder_guardian.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.stone.place")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.elder_guardian.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.teleport"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        EndstoneGolemEntityIsHurtProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this, source.m_7639_());
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source == DamageSource.f_19314_) {
            return false;
        }
        if (source == DamageSource.f_19312_) {
            return false;
        }
        if (source == DamageSource.f_19306_) {
            return false;
        }
        if (source.m_19372_()) {
            return false;
        }
        if (source == DamageSource.f_19321_) {
            return false;
        }
        if (source == DamageSource.f_19323_) {
            return false;
        }
        if (source == DamageSource.f_19320_) {
            return false;
        }
        if (source.m_19385_().equals("witherSkull")) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        EndstoneGolemEntityDiesProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public void m_6075_() {
        super.m_6075_();
        EndstoneGolemOnEntityTickUpdateProcedure.execute((Entity)this);
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 1000.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22281_, 18.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 2.0);
        builder = builder.m_22268_(Attributes.f_22282_, 2.0);
        return builder;
    }
}

