/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage.rendering.types;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.config.BlueprintRenderSettings;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToServer;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlueprintPreviewData {
    @NotNull
    private Rotation rotation = Rotation.NONE;
    @NotNull
    private Mirror mirror = Mirror.NONE;
    @Nullable
    private BlockPos pos;
    private int groundOffset = 0;
    private boolean shouldRefresh = false;
    private Future<Blueprint> blueprintFuture;
    private Blueprint blueprint;
    private String blueprintPath = "";
    private String packName = "";

    public BlueprintPreviewData() {
    }

    public BlueprintPreviewData(FriendlyByteBuf byteBuf) {
        this.pos = byteBuf.m_130135_();
        this.packName = byteBuf.m_130136_(Short.MAX_VALUE);
        this.blueprintPath = byteBuf.m_130136_(Short.MAX_VALUE);
        this.blueprintFuture = StructurePacks.hasPack(this.packName) ? StructurePacks.getBlueprintFuture(this.packName, this.blueprintPath) : null;
        this.rotation = Rotation.values()[byteBuf.readInt()];
        this.mirror = Mirror.values()[byteBuf.readInt()];
    }

    public void writeToBuf(FriendlyByteBuf byteBuf) {
        byteBuf.m_130064_(this.pos == null ? BlockPos.f_121853_ : this.pos);
        if (this.blueprint == null) {
            byteBuf.m_130070_(this.packName);
            byteBuf.m_130070_(this.blueprintPath);
        } else {
            byteBuf.m_130070_(StructurePacks.selectedPack.getName());
            byteBuf.m_130070_(StructurePacks.selectedPack.getSubPath(this.blueprint.getFilePath().resolve(this.blueprint.getFileName() + ".blueprint")));
        }
        byteBuf.writeInt(this.rotation.ordinal());
        byteBuf.writeInt(this.mirror.ordinal());
    }

    public void setBlueprintFuture(Future<Blueprint> blueprintFuture) {
        this.blueprintFuture = blueprintFuture;
    }

    public void setGroundOffset(int offset) {
        this.pos = this.pos.m_6625_(this.groundOffset);
        this.groundOffset = offset;
        this.pos = this.pos.m_6630_(this.groundOffset);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Blueprint getBlueprint() {
        if (this.pos == null) {
            return null;
        }
        if (this.blueprintFuture != null && this.blueprintFuture.isDone()) {
            try {
                if (this.blueprintFuture.get() != null) {
                    this.blueprint = this.blueprintFuture.get();
                    this.blueprintFuture = null;
                    this.blueprint.rotateWithMirror(this.rotation, this.mirror, (Level)Minecraft.m_91087_().f_91073_);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.blueprint;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setBlueprint(Blueprint blueprint) {
        this.blueprintFuture = null;
        if (blueprint != null && !blueprint.equals(this.blueprint)) {
            this.blueprint = blueprint;
            this.blueprint.rotateWithMirror(this.rotation, this.mirror, (Level)Minecraft.m_91087_().f_91073_);
            this.scheduleRefresh();
        } else {
            this.blueprint = blueprint;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mirror() {
        if (this.blueprint == null) {
            return;
        }
        this.mirror = this.mirror == Mirror.NONE ? (this.rotation.ordinal() % 2 == 0 ? Mirror.FRONT_BACK : Mirror.LEFT_RIGHT) : Mirror.NONE;
        this.blueprint.rotateWithMirror(this.rotation, this.mirror, (Level)Minecraft.m_91087_().f_91073_);
        this.scheduleRefresh();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void rotate(Rotation rotation) {
        this.rotation = this.rotation.m_55952_(rotation);
        if (this.blueprint != null) {
            this.blueprint.rotateWithMirror(this.rotation, this.mirror, (Level)Minecraft.m_91087_().f_91073_);
        }
        this.scheduleRefresh();
    }

    private void syncChangesToServer() {
        if (BlueprintRenderSettings.instance.renderSettings.get("structurize.share.previews").booleanValue() && (this.blueprint == null || this.blueprint.getName() != null)) {
            Network.getNetwork().sendToServer(new SyncPreviewCacheToServer(this));
        }
    }

    public void move(BlockPos pos) {
        if (this.pos != null) {
            this.pos = this.pos.m_121955_((Vec3i)pos);
            this.syncChangesToServer();
        }
    }

    public boolean shouldRefresh() {
        boolean ret = this.shouldRefresh;
        this.shouldRefresh = false;
        return ret;
    }

    public void scheduleRefresh() {
        this.shouldRefresh = true;
        this.syncChangesToServer();
    }

    public PlacementSettings getPlacementSettings() {
        return new PlacementSettings(this.mirror, this.rotation);
    }

    public boolean isEmpty() {
        return this.blueprintFuture == null && this.blueprint == null;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }
}

