/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.ScanToolData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ScanOnServerMessage
implements IMessage {
    private final ScanToolData.Slot slot;
    private final boolean saveEntities;

    public ScanOnServerMessage(FriendlyByteBuf buf) {
        String name = buf.m_130136_(Short.MAX_VALUE);
        BlockPos from = buf.m_130135_();
        BlockPos to = buf.m_130135_();
        Optional<BlockPos> anchorPos = buf.readBoolean() ? Optional.of(buf.m_130135_()) : Optional.empty();
        this.slot = new ScanToolData.Slot(name, new BoxPreviewData(from, to, anchorPos));
        this.saveEntities = buf.readBoolean();
    }

    public ScanOnServerMessage(ScanToolData.Slot slot, boolean saveEntities) {
        this.slot = slot;
        this.saveEntities = saveEntities;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.slot.getName());
        buf.m_130064_(this.slot.getBox().getPos1());
        buf.m_130064_(this.slot.getBox().getPos2());
        buf.writeBoolean(this.slot.getBox().getAnchor().isPresent());
        this.slot.getBox().getAnchor().ifPresent(arg_0 -> ((FriendlyByteBuf)buf).m_130064_(arg_0));
        buf.writeBoolean(this.saveEntities);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ItemScanTool.saveStructure(ctxIn.getSender().m_20193_(), (Player)ctxIn.getSender(), this.slot, this.saveEntities);
    }
}

