/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtils;
import com.ldtteam.structurize.client.BlueprintBlockAccess;
import com.ldtteam.structurize.config.BlueprintRenderSettings;
import com.ldtteam.structurize.optifine.OptifineCompat;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.FluidRenderer;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BlueprintRenderer
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Supplier<Map<RenderType, VertexBuffer>> blockVertexBuffersFactory = () -> RenderType.m_110506_().stream().collect(Collectors.toMap(type -> type, type -> new VertexBuffer()));
    private static final RenderBuffers renderBuffers = new RenderBuffers();
    private final BlueprintBlockAccess blockAccess;
    private List<Entity> entities;
    private List<BlockEntity> tileEntities;
    private Map<RenderType, VertexBuffer> vertexBuffers;
    private long lastGameTime;

    public static BlueprintRenderer buildRendererForBlueprint(Blueprint blueprint) {
        BlueprintBlockAccess blockAccess = new BlueprintBlockAccess(blueprint);
        return new BlueprintRenderer(blockAccess);
    }

    private BlueprintRenderer(BlueprintBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
    }

    public void updateBlueprint(BlueprintPreviewData previewData) {
        if (this.blockAccess.getBlueprint() != previewData.getBlueprint() && this.blockAccess.getBlueprint().hashCode() == previewData.getBlueprint().hashCode()) {
            this.blockAccess.setBlueprint(previewData.getBlueprint());
            previewData.scheduleRefresh();
        }
    }

    private void init(BlockPos anchorPos) {
        Blueprint blueprint = this.blockAccess.getBlueprint();
        List<BlockInfo> blocks = blueprint.getBlockInfoAsList();
        HashMap<BlockPos, ModelData> teModelData = new HashMap<BlockPos, ModelData>();
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher blockRendererDispatcher = mc.m_91289_();
        RandomSource random = RandomSource.m_216327_();
        ClientLevel serverLevel = mc.m_91091_() ? mc.m_91092_().m_6846_().m_11259_((UUID)mc.f_91074_.m_20148_()).f_19853_ : null;
        BlockState defaultFluidState = BlockUtils.getFluidForDimension((Level)(serverLevel == null ? mc.f_91073_ : serverLevel));
        this.clearVertexBuffers();
        this.entities = BlueprintUtils.instantiateEntities(blueprint, this.blockAccess);
        this.tileEntities = new ArrayList<BlockEntity>(BlueprintUtils.instantiateTileEntities(blueprint, this.blockAccess, teModelData));
        PoseStack matrixStack = new PoseStack();
        OurChunkBufferBuilderPack newBuffers = new OurChunkBufferBuilderPack();
        RenderType[] blockRenderTypes = (RenderType[])RenderType.m_110506_().toArray(RenderType[]::new);
        for (BlockInfo blockInfo : blocks) {
            try {
                BlockPos blockPos = blockInfo.getPos();
                BlockState state = blockInfo.getState();
                if (!BlueprintRenderSettings.instance.renderSettings.get("structurize.render.placeholders").booleanValue()) {
                    if (state.m_60734_() == ModBlocks.blockSubstitution.get()) {
                        state = Blocks.f_50016_.m_49966_();
                    }
                    if (state.m_60734_() == ModBlocks.blockTagSubstitution.get()) {
                        Optional<BlockEntity> tagTE = this.tileEntities.stream().filter(te -> te.m_58899_().equals((Object)blockPos) && te instanceof BlockEntityTagSubstitution).findFirst();
                        if (tagTE.isPresent()) {
                            BlockEntityTagSubstitution.ReplacementBlock replacement = ((BlockEntityTagSubstitution)tagTE.get()).getReplacement();
                            state = replacement.getBlockState();
                            this.tileEntities.remove(tagTE.get());
                            Optional.ofNullable(replacement.createBlockEntity(blockPos)).ifPresent(e -> {
                                e.m_142339_((Level)this.blockAccess);
                                teModelData.put(blockPos, e.getModelData());
                                this.tileEntities.add((BlockEntity)e);
                            });
                        } else {
                            state = Blocks.f_50016_.m_49966_();
                        }
                    }
                    if (state.m_60734_() == ModBlocks.blockFluidSubstitution.get()) {
                        state = defaultFluidState;
                    }
                    if (SharedConstants.f_136183_ && serverLevel != null && state.m_60734_() == ModBlocks.blockSolidSubstitution.get() && (state = BlockUtils.getWorldgenBlock((Level)serverLevel, anchorPos.m_121955_((Vec3i)blockPos), blueprint.getRawBlockStateFunction().compose(b -> b.m_121996_((Vec3i)anchorPos)))) == null) {
                        state = blockInfo.getState();
                    }
                }
                FluidState fluidState = state.m_60819_();
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                BakedModel blockModel = blockRendererDispatcher.m_110910_(state);
                @NotNull ModelData modelData = blockModel.getModelData((BlockAndTintGetter)this.blockAccess, blockPos, state, teModelData.getOrDefault(blockPos, ModelData.EMPTY));
                for (RenderType renderType : blockModel.getRenderTypes(state, random, modelData)) {
                    renderType.m_110185_();
                    BufferBuilder buffer = newBuffers.m_108839_(renderType);
                    renderType.m_110185_();
                    if (state.m_60799_() != RenderShape.INVISIBLE) {
                        blockRendererDispatcher.renderBatched(state, blockPos, (BlockAndTintGetter)this.blockAccess, matrixStack, (VertexConsumer)buffer, true, random, modelData, renderType);
                    }
                    if (!fluidState.m_76178_()) {
                        FluidRenderer.render((BlockAndTintGetter)this.blockAccess, blockPos, (VertexConsumer)buffer, fluidState);
                    }
                    renderType.m_110188_();
                }
                matrixStack.m_85849_();
            }
            catch (ReportedException e2) {
                LOGGER.error("Error while trying to render structure part: " + e2.getMessage(), e2.getCause());
            }
        }
        this.vertexBuffers = blockVertexBuffersFactory.get();
        for (RenderType renderType : blockRenderTypes) {
            BufferBuilder.RenderedBuffer newBuffer = newBuffers.m_108839_(renderType).m_231168_();
            if (newBuffer == null) {
                this.vertexBuffers.remove(renderType);
                continue;
            }
            VertexBuffer vertexBuffer = this.vertexBuffers.get(renderType);
            vertexBuffer.m_85921_();
            vertexBuffer.m_231221_(newBuffer);
        }
        VertexBuffer.m_85931_();
    }

    public void draw(BlueprintPreviewData previewData, BlockPos pos, PoseStack matrixStack, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        long gameTime = mc.f_91073_.m_46467_();
        mc.m_91307_().m_6180_("struct_render_init");
        BlockPos anchorPos = pos.m_121996_((Vec3i)this.blockAccess.getBlueprint().getPrimaryBlockOffset());
        this.blockAccess.setWorldPos(anchorPos);
        if (this.vertexBuffers == null || previewData.shouldRefresh()) {
            this.init(anchorPos);
        }
        mc.m_91307_().m_6182_("struct_render_prepare");
        Vec3 viewPosition = mc.f_91063_.m_109153_().m_90583_();
        Vec3 realRenderRootVecd = Vec3.m_82528_((Vec3i)anchorPos).m_82546_(viewPosition);
        Vector3f realRenderRootVecf = new Vector3f(realRenderRootVecd);
        matrixStack.m_85836_();
        matrixStack.m_85837_(viewPosition.m_7096_(), viewPosition.m_7098_(), viewPosition.m_7094_());
        Matrix4f mvMatrix = matrixStack.m_85850_().m_85861_();
        FogRenderer.m_234172_((Camera)mc.f_91063_.m_109153_(), (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)Math.max(mc.f_91063_.m_109152_(), 32.0f), (mc.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)viewPosition.m_7096_()), Mth.m_14107_((double)viewPosition.m_7098_())) || mc.f_91065_.m_93090_().m_93715_() ? 1 : 0) != 0, (float)partialTicks);
        OptifineCompat.getInstance().setupFog();
        mc.m_91307_().m_6182_("struct_render_blocks");
        this.renderBlockLayer(RenderType.m_110451_(), mvMatrix, realRenderRootVecf);
        mc.m_91304_().m_119428_(InventoryMenu.f_39692_).setBlurMipmap(false, (Integer)mc.f_91066_.m_232119_().m_231551_() > 0);
        this.renderBlockLayer(RenderType.m_110457_(), mvMatrix, realRenderRootVecf);
        mc.m_91304_().m_119428_(InventoryMenu.f_39692_).restoreLastBlurMipmap();
        this.renderBlockLayer(RenderType.m_110463_(), mvMatrix, realRenderRootVecf);
        OptifineCompat.getInstance().endTerrainBeginEntities();
        mc.m_91307_().m_6182_("struct_render_entities");
        MultiBufferSource.BufferSource renderBufferSource = renderBuffers.m_110104_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(realRenderRootVecd.m_7096_(), realRenderRootVecd.m_7098_(), realRenderRootVecd.m_7094_());
        for (Entity entity : this.entities) {
            if (gameTime != this.lastGameTime && entity instanceof EndCrystal) {
                EndCrystal crystal = (EndCrystal)entity;
                ++crystal.f_31032_;
            }
            OptifineCompat.getInstance().preRenderEntity(entity);
            Minecraft.m_91087_().m_91290_().m_114384_(entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), partialTicks, matrixStack, (MultiBufferSource)renderBufferSource, LightTexture.m_109885_((int)15, (int)15));
        }
        matrixStack.m_85849_();
        mc.m_91307_().m_6182_("struct_render_entities_finish");
        renderBufferSource.m_173043_();
        renderBufferSource.m_109912_(RenderType.m_110446_((ResourceLocation)InventoryMenu.f_39692_));
        renderBufferSource.m_109912_(RenderType.m_110452_((ResourceLocation)InventoryMenu.f_39692_));
        renderBufferSource.m_109912_(RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_));
        renderBufferSource.m_109912_(RenderType.m_110476_((ResourceLocation)InventoryMenu.f_39692_));
        OptifineCompat.getInstance().endEntitiesBeginBlockEntities();
        mc.m_91307_().m_6182_("struct_render_blockentities");
        Camera oldActiveRenderInfo = mc.m_167982_().f_112249_;
        Level oldWorld = mc.m_167982_().f_112248_;
        mc.m_167982_().f_112249_ = new Camera();
        mc.m_167982_().f_112249_.m_90581_(viewPosition.m_82492_((double)anchorPos.m_123341_(), (double)anchorPos.m_123342_(), (double)anchorPos.m_123343_()));
        mc.m_167982_().f_112248_ = this.blockAccess;
        for (BlockEntity tileEntity : this.tileEntities) {
            BlockPos tePos = tileEntity.m_58899_();
            Vec3 realRenderTePos = realRenderRootVecd.m_82520_((double)tePos.m_123341_(), (double)tePos.m_123342_(), (double)tePos.m_123343_());
            if (gameTime != this.lastGameTime) {
                if (tileEntity instanceof SpawnerBlockEntity) {
                    SpawnerBlockEntity spawner = (SpawnerBlockEntity)tileEntity;
                    SpawnerBlockEntity.m_155754_((Level)mc.f_91073_, (BlockPos)anchorPos.m_121955_((Vec3i)tePos), (BlockState)this.blockAccess.m_8055_(tePos), (SpawnerBlockEntity)spawner);
                } else if (tileEntity instanceof EnchantmentTableBlockEntity) {
                    EnchantmentTableBlockEntity enchTable = (EnchantmentTableBlockEntity)tileEntity;
                    EnchantmentTableBlockEntity.m_155503_((Level)mc.f_91073_, (BlockPos)anchorPos.m_121955_((Vec3i)tePos), (BlockState)this.blockAccess.m_8055_(tePos), (EnchantmentTableBlockEntity)enchTable);
                } else if (tileEntity instanceof CampfireBlockEntity) {
                    CampfireBlockEntity campfire = (CampfireBlockEntity)tileEntity;
                    bs = this.blockAccess.m_8055_(tePos);
                    if (bs.m_60734_() instanceof CampfireBlock && ((Boolean)bs.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                        CampfireBlockEntity.m_155318_((Level)mc.f_91073_, (BlockPos)anchorPos.m_121955_((Vec3i)tePos), (BlockState)bs, (CampfireBlockEntity)campfire);
                    }
                } else if (tileEntity instanceof SkullBlockEntity) {
                    SkullBlockEntity skull = (SkullBlockEntity)tileEntity;
                    bs = this.blockAccess.m_8055_(tePos);
                    if (bs.m_60734_() instanceof SkullBlock && bs.m_60713_(Blocks.f_50320_) || bs.m_60713_(Blocks.f_50321_)) {
                        SkullBlockEntity.m_155733_((Level)mc.f_91073_, (BlockPos)anchorPos.m_121955_((Vec3i)tePos), (BlockState)bs, (SkullBlockEntity)skull);
                    }
                }
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_(realRenderTePos.f_82479_, realRenderTePos.f_82480_, realRenderTePos.f_82481_);
            OptifineCompat.getInstance().preRenderBlockEntity(tileEntity);
            mc.m_167982_().m_112267_(tileEntity, partialTicks, matrixStack, (MultiBufferSource)renderBufferSource);
            matrixStack.m_85849_();
        }
        mc.m_167982_().f_112249_ = oldActiveRenderInfo;
        mc.m_167982_().f_112248_ = oldWorld;
        mc.m_91307_().m_6182_("struct_render_blockentities_finish");
        renderBufferSource.m_109912_(RenderType.m_110451_());
        renderBufferSource.m_109912_(RenderType.m_173239_());
        renderBufferSource.m_109912_(RenderType.m_173242_());
        renderBufferSource.m_109912_(Sheets.m_110789_());
        renderBufferSource.m_109912_(Sheets.m_110790_());
        renderBufferSource.m_109912_(Sheets.m_110785_());
        renderBufferSource.m_109912_(Sheets.m_110786_());
        renderBufferSource.m_109912_(Sheets.m_110787_());
        renderBufferSource.m_109912_(Sheets.m_110788_());
        if (OptifineCompat.getInstance().isOptifineEnabled()) {
            renderBufferSource.m_109912_(Sheets.m_110762_());
        }
        renderBuffers.m_110109_().m_109928_();
        OptifineCompat.getInstance().endBlockEntitiesBeginDebug(renderBuffers);
        renderBufferSource.m_109912_(Sheets.m_110792_());
        renderBufferSource.m_109912_(Sheets.m_110762_());
        renderBufferSource.m_109912_(Sheets.m_110782_());
        renderBufferSource.m_109912_(RenderType.m_110481_());
        renderBufferSource.m_109912_(RenderType.m_110484_());
        renderBufferSource.m_109912_(RenderType.m_110490_());
        renderBufferSource.m_109912_(RenderType.m_110493_());
        renderBufferSource.m_109912_(RenderType.m_110487_());
        renderBufferSource.m_109912_(RenderType.m_110496_());
        renderBufferSource.m_109912_(RenderType.m_110499_());
        renderBufferSource.m_109912_(RenderType.m_110478_());
        renderBuffers.m_110108_().m_109911_();
        mc.m_91307_().m_6182_("struct_render_blocks2");
        OptifineCompat.getInstance().endDebugPreWaterBeginWater();
        this.renderBlockLayer(RenderType.m_110466_(), mvMatrix, realRenderRootVecf);
        OptifineCompat.getInstance().endWater();
        renderBufferSource.m_109912_(RenderType.m_110504_());
        renderBufferSource.m_109911_();
        this.renderBlockLayer(RenderType.m_110503_(), mvMatrix, realRenderRootVecf);
        OptifineCompat.getInstance().resetFog();
        FogRenderer.m_109017_();
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
        this.lastGameTime = gameTime;
        mc.m_91307_().m_7238_();
    }

    private void clearVertexBuffers() {
        if (this.vertexBuffers != null) {
            this.vertexBuffers.values().forEach(VertexBuffer::close);
            this.vertexBuffers = null;
        }
    }

    @Override
    public void close() {
        this.clearVertexBuffers();
    }

    private void renderBlockLayer(RenderType layerRenderType, Matrix4f mvMatrix, Vector3f realRenderRootPos) {
        VertexBuffer vertexBuffer = this.vertexBuffers.get(layerRenderType);
        if (vertexBuffer == null) {
            return;
        }
        layerRenderType.m_110185_();
        ShaderInstance shaderinstance = RenderSystem.m_157196_();
        BufferUploader.m_166835_();
        for (int k = 0; k < 12; ++k) {
            shaderinstance.m_173350_("Sampler" + k, (Object)RenderSystem.m_157203_((int)k));
        }
        if (shaderinstance.f_173308_ != null) {
            shaderinstance.f_173308_.m_5679_(mvMatrix);
        }
        if (shaderinstance.f_173309_ != null) {
            shaderinstance.f_173309_.m_5679_(RenderSystem.m_157192_());
        }
        if (shaderinstance.f_173312_ != null) {
            shaderinstance.f_173312_.m_5941_(RenderSystem.m_157197_());
        }
        if (shaderinstance.f_173315_ != null) {
            shaderinstance.f_173315_.m_5985_(RenderSystem.m_157200_());
        }
        if (shaderinstance.f_173316_ != null) {
            shaderinstance.f_173316_.m_5985_(RenderSystem.m_157199_());
        }
        if (shaderinstance.f_173317_ != null) {
            shaderinstance.f_173317_.m_5941_(RenderSystem.m_157198_());
        }
        if (shaderinstance.f_202432_ != null) {
            shaderinstance.f_202432_.m_142617_(RenderSystem.m_202041_().m_202324_());
        }
        if (shaderinstance.f_173310_ != null) {
            shaderinstance.f_173310_.m_5679_(RenderSystem.m_157207_());
        }
        if (shaderinstance.f_173319_ != null) {
            shaderinstance.f_173319_.m_5985_(RenderSystem.m_157201_());
        }
        RenderSystem.m_157461_((ShaderInstance)shaderinstance);
        shaderinstance.m_173363_();
        OptifineCompat.getInstance().preLayerDraw(layerRenderType, mvMatrix);
        Uniform uniform = shaderinstance.f_173320_;
        if (uniform != null && !OptifineCompat.getInstance().isShaderProgramActive()) {
            uniform.m_142276_(realRenderRootPos);
            uniform.m_85633_();
        }
        OptifineCompat.getInstance().setUniformChunkOffset(realRenderRootPos.m_122239_(), realRenderRootPos.m_122260_(), realRenderRootPos.m_122269_());
        vertexBuffer.m_85921_();
        vertexBuffer.m_166882_();
        if (uniform != null) {
            uniform.m_142276_(Vector3f.f_176763_);
        }
        OptifineCompat.getInstance().setUniformChunkOffset(0.0f, 0.0f, 0.0f);
        shaderinstance.m_173362_();
        VertexBuffer.m_85931_();
        layerRenderType.m_110188_();
    }

    private static class OurChunkBufferBuilderPack
    extends ChunkBufferBuilderPack {
        private OurChunkBufferBuilderPack() {
        }

        public BufferBuilder m_108839_(RenderType renderType) {
            BufferBuilder buffer = super.m_108839_(renderType);
            if (!buffer.m_85732_()) {
                buffer.m_166779_(renderType.m_173186_(), renderType.m_110508_());
            }
            return buffer;
        }
    }
}

