/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.enchantmentrequirements;

import ca.teamdman.enchantmentrequirements.Config;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="enchantmentrequirements")
public class ClientStuff {
    private static long lastCheck = 0L;
    private static int tablePower = 0;

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        BlockPos pos;
        ItemStack stack = event.getItemStack();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        List tip = event.getToolTip();
        BlockPos blockPos = pos = Minecraft.m_91087_().f_91077_ == null ? BlockPos.f_121853_ : new BlockPos(Minecraft.m_91087_().f_91077_.m_82450_());
        if (stack.m_41619_() || level == null || pos.equals((Object)BlockPos.f_121853_)) {
            return;
        }
        ClientStuff.handleBlockPower(event, stack, level, pos, tip);
        ClientStuff.handleBookLevel(event, stack, level, pos, tip);
        ClientStuff.handleItemPower(event, stack, level, pos, tip);
        ClientStuff.handleTablePower(event, stack, (Level)level, pos, tip);
    }

    private static void handleItemPower(ItemTooltipEvent event, ItemStack stack, ClientLevel level, BlockPos pos, List<Component> tip) {
        int enchantValue = stack.getEnchantmentValue();
        if (enchantValue < (Integer)Config.MIN_ENCHANTMENT_VALUE_TO_SHOW.get()) {
            return;
        }
        tip.add((Component)Component.m_237110_((String)"tooltip.enchantmentrequirements.value", (Object[])new Object[]{enchantValue}));
    }

    private static void handleBlockPower(ItemTooltipEvent event, ItemStack stack, ClientLevel level, BlockPos pos, List<Component> tip) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        float power = blockItem.m_40614_().m_49966_().getEnchantPowerBonus((LevelReader)level, pos);
        if (power > 0.0f) {
            tip.add((Component)Component.m_237110_((String)"tooltip.enchantmentrequirements.power", (Object[])new Object[]{Float.valueOf(power)}));
        }
    }

    private static void handleTablePower(ItemTooltipEvent event, ItemStack stack, Level level, BlockPos pos, List<Component> tip) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof EnchantmentScreen)) {
            return;
        }
        EnchantmentScreen es = (EnchantmentScreen)screen;
        ClientStuff.recalculateTablePower(level, pos);
        tip.add((Component)Component.m_237110_((String)"tooltip.enchantmentrequirements.table_power", (Object[])new Object[]{tablePower}).m_130940_(ChatFormatting.DARK_AQUA));
        int itemPower = stack.getEnchantmentValue();
        if (itemPower == 0) {
            return;
        }
        int pPower = Math.min(tablePower, 15);
        int jLower = 1 + (pPower >> 1);
        int jUpper = 8 + (pPower >> 1) + pPower;
        int cost0Lower = Math.max(jLower / 3, 1);
        int cost0Upper = Math.max(jUpper / 3, 1);
        int cost1Lower = Math.max(jLower * 2 / 3 + 1, 2);
        int cost1Upper = Math.max(jUpper * 2 / 3 + 1, 2);
        int cost2Lower = Math.max(Math.max(jLower, pPower * 2), 3);
        int cost2Upper = Math.max(Math.max(jUpper, pPower * 2), 3);
        tip.add((Component)Component.m_237110_((String)"tooltip.enchantmentrequirements.cost_0", (Object[])new Object[]{cost0Lower, cost0Upper}).m_130940_(ChatFormatting.DARK_AQUA));
        tip.add((Component)Component.m_237110_((String)"tooltip.enchantmentrequirements.cost_1", (Object[])new Object[]{cost1Lower, cost1Upper}).m_130940_(ChatFormatting.DARK_AQUA));
        tip.add((Component)Component.m_237110_((String)"tooltip.enchantmentrequirements.cost_2", (Object[])new Object[]{cost2Lower, cost2Upper}).m_130940_(ChatFormatting.DARK_AQUA));
    }

    private static void recalculateTablePower(Level level, BlockPos pos) {
        if (System.currentTimeMillis() <= lastCheck + 1000L) {
            return;
        }
        if (level == null) {
            tablePower = -1;
        } else {
            tablePower = 0;
            for (BlockPos blockpos : EnchantmentTableBlock.f_207902_) {
                if (!EnchantmentTableBlock.m_207909_((Level)level, (BlockPos)pos, (BlockPos)blockpos)) continue;
                tablePower = (int)((float)tablePower + level.m_8055_(pos.m_121955_((Vec3i)blockpos)).getEnchantPowerBonus((LevelReader)level, pos.m_121955_((Vec3i)blockpos)));
            }
        }
        lastCheck = System.currentTimeMillis();
    }

    private static void handleBookLevel(ItemTooltipEvent event, ItemStack stack, ClientLevel level, BlockPos pos, List<Component> tip) {
        if (!(stack.m_41720_() instanceof EnchantedBookItem)) {
            return;
        }
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchants.size() != 1) {
            return;
        }
        Map.Entry entry = enchants.entrySet().iterator().next();
        Enchantment ench = (Enchantment)entry.getKey();
        Integer enchLevel = (Integer)entry.getValue();
        int minCost = ench.m_6183_(enchLevel.intValue());
        int maxCost = ench.m_6175_(enchLevel.intValue());
        tip.add((Component)Component.m_237110_((String)"tooltip.enchantmentrequirements.cost", (Object[])new Object[]{minCost, maxCost}));
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof EnchantmentScreen)) {
            return;
        }
        EnchantmentScreen es = (EnchantmentScreen)screen;
        ItemStack enchanting = ((Slot)((EnchantmentMenu)es.m_6262_()).f_38839_.get(0)).m_7993_();
        if (enchanting.m_41619_()) {
            return;
        }
        int itemPower = enchanting.getEnchantmentValue();
        if (itemPower <= 0) {
            return;
        }
        int pPower = Math.min(tablePower, 15);
        int jLower = 1 + (pPower >> 1);
        int jUpper = 8 + (pPower >> 1) + pPower;
        int cost0Lower = Math.max(jLower / 3, 1);
        int cost2Upper = Math.max(Math.max(jUpper, pPower * 2), 3);
        int pLevelLower = cost0Lower + 1;
        int pLevelUpper = cost2Upper + 1 + itemPower / 2;
        float fLower = -0.15f;
        float fUpper = 0.15f;
        pLevelLower = Mth.m_14045_((int)Math.round((float)pLevelLower + (float)pLevelLower * fLower), (int)1, (int)Integer.MAX_VALUE);
        pLevelUpper = Mth.m_14045_((int)Math.round((float)pLevelUpper + (float)pLevelUpper * fUpper), (int)1, (int)Integer.MAX_VALUE);
        tip.add((Component)Component.m_237110_((String)"tooltip.enchantmentrequirements.true_cost", (Object[])new Object[]{pLevelLower, pLevelUpper}).m_130940_(ChatFormatting.DARK_AQUA));
        if (!(ench.m_6081_(enchanting) || enchanting.m_41720_() instanceof BookItem && ench.isAllowedOnBooks())) {
            tip.add((Component)Component.m_237115_((String)"tooltip.enchantmentrequirements.cant_enchant").m_130940_(ChatFormatting.RED));
        }
    }
}

