/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util.handlers;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerEquipsUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gobber2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RepairTickEventHandler {
    public static int repairTickRate = (Integer)GobberConfigBuilder.RING_REPAIR_DELAY.get();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Inventory inv = player.m_150109_();
        boolean isServerSide = event.side.equals((Object)LogicalSide.SERVER);
        if (!isServerSide) {
            return;
        }
        if ((PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_REPAIR.get()) || PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_REPAIR.get())) && player.f_19797_ % repairTickRate == 0) {
            RepairTickEventHandler.repairInInventory(player, inv);
        }
    }

    private static void repairInInventory(Player player, Inventory inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack target = inv.m_8020_(slot);
            if (target.m_41619_() || target == player.m_21205_() || !target.m_41768_() || !target.m_41720_().isRepairable(target)) continue;
            target.m_41721_(target.m_41773_() - 1);
            return;
        }
    }
}

