/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util.handlers;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.EnableUtil;
import com.kwpugh.gobber2.util.PlayerEquipsUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gobber2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class AbilityEventHandler {
    static int extraXPOrbs = (Integer)GobberConfigBuilder.MEDALLION_EXP_ORBS.get();
    static int extraLoot = (Integer)GobberConfigBuilder.MEDALLION_EXP_LOOT.get();
    static boolean enableVoidProtection = (Boolean)GobberConfigBuilder.ENABLE_DRAGON_ARMOR_VOID_PROTECTION.get();
    static int hungerLesserHealing = (Integer)GobberConfigBuilder.MEDALLION_LESSER_HEALING_HUNGER.get();
    static double saturationLesserHealing = (Double)GobberConfigBuilder.MEDALLION_LESSER_HEALING_SATURATION.get();
    static int hungerHealing = (Integer)GobberConfigBuilder.MEDALLION_HEALING_HUNGER.get();
    static double saturationHealing = (Double)GobberConfigBuilder.MEDALLION_HEALING_SATURATION.get();
    static int hungerGreaterHealing = (Integer)GobberConfigBuilder.MEDALLION_GREATER_HEALING_HUNGER.get();
    static double saturationGreaterHealing = (Double)GobberConfigBuilder.MEDALLION_GREATER_HEALING_SATURATION.get();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        ItemStack invStack;
        boolean isServerType = event.type.equals((Object)TickEvent.Type.SERVER);
        boolean isEndPhase = event.phase.equals((Object)TickEvent.Phase.END);
        boolean isServerSide = event.side.equals((Object)LogicalSide.SERVER);
        Level level = event.player.f_19853_;
        Player player = event.player;
        if (!isServerSide) {
            return;
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING.get())) {
            invStack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, hungerLesserHealing, (float)saturationLesserHealing);
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING.get())) {
            invStack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, hungerLesserHealing, (float)saturationLesserHealing);
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING2.get())) {
            invStack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING2.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, hungerHealing, (float)saturationHealing);
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING2.get())) {
            invStack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING2.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, hungerHealing, (float)saturationHealing);
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING3.get())) {
            invStack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING3.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, hungerGreaterHealing, (float)saturationGreaterHealing);
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING3.get())) {
            invStack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING3.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, hungerGreaterHealing, (float)saturationGreaterHealing);
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_CONDUIT.get())) {
            invStack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_CONDUIT.get());
            if (EnableUtil.isEnabled(invStack) && player.m_20069_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 300, 2, false, false));
            }
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_CONDUIT.get()) && EnableUtil.isEnabled(invStack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_CONDUIT.get())) && player.m_20069_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 300, 2, false, false));
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_DOLPHIN.get())) {
            invStack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_DOLPHIN.get());
            if (EnableUtil.isEnabled(invStack) && player.m_20069_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 300, 2, false, false));
            }
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_DOLPHIN.get()) && EnableUtil.isEnabled(invStack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_DOLPHIN.get())) && player.m_20069_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 300, 2, false, false));
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HERO.get())) {
            stack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HERO.get());
            if (EnableUtil.isEnabled(stack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 300, 2, false, false));
            }
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HERO.get()) && EnableUtil.isEnabled(stack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HERO.get()))) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 300, 2, false, false));
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_HASTE.get())) {
            stack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_HASTE.get());
            if (EnableUtil.isEnabled(stack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 300, 1, false, false));
            }
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_HASTE.get()) && EnableUtil.isEnabled(stack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_HASTE.get()))) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 300, 1, false, false));
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_CURING.get()) || PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_CURING.get())) {
            PlayerSpecialAbilities.doCuring(player);
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_ATTRACTION.get())) {
            stack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_ATTRACTION.get());
            if (EnableUtil.isEnabled(stack)) {
                PlayerSpecialAbilities.doAttraction(level, player, stack);
            }
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_ATTRACTION.get()) && EnableUtil.isEnabled(stack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_ATTRACTION.get()))) {
            PlayerSpecialAbilities.doAttraction(level, player, stack);
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_SWIFTNESS.get())) {
            stack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_SWIFTNESS.get());
            if (EnableUtil.isEnabled(stack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300, 1, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 300, 3, false, false));
            }
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_SWIFTNESS.get()) && EnableUtil.isEnabled(stack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_SWIFTNESS.get()))) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300, 1, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 300, 3, false, false));
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_VISION.get())) {
            stack = PlayerEquipsUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_VISION.get());
            if (EnableUtil.isEnabled(stack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0, false, false));
                if (player.m_21124_(MobEffects.f_216964_) != null) {
                    player.m_21195_(MobEffects.f_216964_);
                }
            }
        } else if (PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_VISION.get()) && EnableUtil.isEnabled(stack = PlayerEquipsUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_VISION.get()))) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0, false, false));
            if (player.m_21124_(MobEffects.f_216964_) != null) {
                player.m_21195_(MobEffects.f_216964_);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onLivingHurtEvent(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (enableVoidProtection && event.getSource() == DamageSource.f_19317_ && PlayerEquipsUtil.isPlayerGotVoidProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.f_19315_ && PlayerEquipsUtil.isPlayerGotFallProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if ((event.getSource() == DamageSource.f_19305_ || event.getSource() == DamageSource.f_19307_ || event.getSource() == DamageSource.f_19308_) && PlayerEquipsUtil.isPlayerGotFireProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.f_19312_ && PlayerEquipsUtil.isPlayerGotWaterBreathing(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        LivingEntity livingEntity = event.getTarget();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = event.getEntity();
            if (livingEntity instanceof Mob) {
                Mob attacker = (Mob)livingEntity;
                if (PlayerEquipsUtil.isPlayerGotStealth(player)) {
                    attacker.m_6710_(null);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onKillingLootEvent(LootingLevelEvent event) {
        Player player;
        Entity entity;
        if (event.getDamageSource() != null && event.getDamageSource().m_7639_() != null && event.getEntity() instanceof Mob && (entity = event.getDamageSource().m_7639_()) instanceof Player && (PlayerEquipsUtil.hasItemInInventory(player = (Player)entity, (Item)ItemInit.GOBBER2_MEDALLION_EXP.get()) || PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_EXP.get()))) {
            event.setLootingLevel(extraLoot);
        }
    }

    @SubscribeEvent
    public static void onKillingExpDropEvent(LivingExperienceDropEvent event) {
        Player player;
        if (event.getAttackingPlayer() != null && event.getEntity() instanceof Mob && (PlayerEquipsUtil.hasItemInInventory(player = event.getAttackingPlayer(), (Item)ItemInit.GOBBER2_MEDALLION_EXP.get()) || PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_EXP.get()))) {
            int orgExp = event.getOriginalExperience();
            int newExp = orgExp * extraXPOrbs;
            event.setDroppedExperience(newExp);
        }
    }

    @SubscribeEvent
    public static void onMiningExpDropEvent(BlockEvent.BreakEvent event) {
        Player player;
        Block block = event.getState().m_60734_();
        if (block instanceof DropExperienceBlock && event.getPlayer() != null && (PlayerEquipsUtil.hasItemInInventory(player = event.getPlayer(), (Item)ItemInit.GOBBER2_MEDALLION_EXP.get()) || PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_EXP.get())) && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)player) <= 0) {
            event.setExpToDrop(extraXPOrbs);
        }
    }

    @SubscribeEvent
    public static void onDropAirWalkingRing(ItemTossEvent event) {
        Player player = event.getPlayer();
        ItemEntity entity = event.getEntity();
        ItemStack stack = entity.m_32055_();
        if (stack.m_41720_().equals(ItemInit.GOBBER2_RING_AIRWALKING.get())) {
            player.m_20242_(false);
        }
        if (stack.m_41720_().equals(ItemInit.GOBBER2_RING_ASCENT.get()) && player.m_21023_(MobEffects.f_19620_)) {
            player.m_21195_(MobEffects.f_19620_);
        }
    }
}

